/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.stick.undo;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.network.ModMessages;
import mrbysco.constructionstick.network.PacketUndoBlocks;
import mrbysco.constructionstick.stick.undo.ISnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class UndoHistory {
    private final HashMap<UUID, PlayerEntry> history = new HashMap();

    private PlayerEntry getEntryFromPlayer(Player player) {
        return this.history.computeIfAbsent(player.getUUID(), k -> new PlayerEntry());
    }

    public void add(Player player, Level level, List<ISnapshot> placeSnapshots) {
        LinkedList<HistoryEntry> list = this.getEntryFromPlayer((Player)player).entries;
        list.add(new HistoryEntry(placeSnapshots, level));
        while (list.size() > (Integer)ConstructionConfig.UNDO_HISTORY.get()) {
            list.removeFirst();
        }
    }

    public void removePlayer(Player player) {
        this.history.remove(player.getUUID());
    }

    public void updateClient(Player player, boolean keyDown) {
        HistoryEntry entry;
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        PlayerEntry playerEntry = this.getEntryFromPlayer(player);
        playerEntry.undoActive = keyDown;
        LinkedList<HistoryEntry> historyEntries = playerEntry.entries;
        Set<Object> positions = historyEntries.isEmpty() ? Collections.emptySet() : ((entry = historyEntries.getLast()) == null || !entry.level.equals(level) ? Collections.emptySet() : entry.getBlockPositions());
        PacketUndoBlocks packet = new PacketUndoBlocks(positions);
        ModMessages.sendToPlayer(packet, (ServerPlayer)player);
    }

    public boolean isUndoActive(Player player) {
        return this.getEntryFromPlayer((Player)player).undoActive;
    }

    public boolean undo(Player player, Level level, BlockPos pos) {
        PlayerEntry playerEntry = this.getEntryFromPlayer(player);
        if (!playerEntry.undoActive) {
            return false;
        }
        LinkedList<HistoryEntry> historyEntries = playerEntry.entries;
        if (historyEntries.isEmpty()) {
            return false;
        }
        HistoryEntry entry = historyEntries.getLast();
        if (!entry.level.equals(level) || !entry.withinRange(pos)) {
            return false;
        }
        if (entry.undo(player)) {
            historyEntries.remove(entry);
            this.updateClient(player, true);
            return true;
        }
        return false;
    }

    private static class PlayerEntry {
        public final LinkedList<HistoryEntry> entries = new LinkedList();
        public boolean undoActive = false;
    }

    private static class HistoryEntry {
        public final List<ISnapshot> placeSnapshots;
        public final Level level;

        public HistoryEntry(List<ISnapshot> placeSnapshots, Level level) {
            this.placeSnapshots = placeSnapshots;
            this.level = level;
        }

        public Set<BlockPos> getBlockPositions() {
            return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
        }

        public boolean withinRange(BlockPos pos) {
            Set<BlockPos> positions = this.getBlockPositions();
            if (positions.contains(pos)) {
                return true;
            }
            for (BlockPos p : positions) {
                if (!pos.closerThan((Vec3i)p, 3.0)) continue;
                return true;
            }
            return false;
        }

        public boolean undo(Player player) {
            for (ISnapshot snapshot : this.placeSnapshots) {
                if (snapshot.canRestore(this.level, player)) continue;
                return false;
            }
            for (ISnapshot snapshot : this.placeSnapshots) {
                if (!snapshot.restore(this.level, player) || player.isCreative()) continue;
                ItemStack stack = snapshot.getRequiredItems();
                if (player.getInventory().add(stack)) continue;
                player.drop(stack, false);
            }
            player.getInventory().setChanged();
            SoundEvent sound = SoundEvents.CHORUS_FRUIT_TELEPORT;
            this.level.playSound(null, player.blockPosition(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
    }
}

