/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.Collections;
import java.util.List;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSResources;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.audio.SoundManager;
import mchorse.bbs_mod.blocks.entities.ModelProperties;
import mchorse.bbs_mod.camera.clips.ClipFactoryData;
import mchorse.bbs_mod.camera.clips.misc.AudioClientClip;
import mchorse.bbs_mod.camera.clips.misc.CurveClientClip;
import mchorse.bbs_mod.camera.clips.misc.TrackerClientClip;
import mchorse.bbs_mod.camera.controller.CameraController;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.client.renderer.ModelBlockEntityRenderer;
import mchorse.bbs_mod.client.renderer.entity.ActorEntityRenderer;
import mchorse.bbs_mod.client.renderer.entity.GunProjectileEntityRenderer;
import mchorse.bbs_mod.client.renderer.item.GunItemRenderer;
import mchorse.bbs_mod.client.renderer.item.ModelBlockItemRenderer;
import mchorse.bbs_mod.cubic.model.ModelManager;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.Films;
import mchorse.bbs_mod.film.Recorder;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.forms.FormCategories;
import mchorse.bbs_mod.forms.categories.UserFormCategory;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.graphics.FramebufferManager;
import mchorse.bbs_mod.graphics.texture.TextureManager;
import mchorse.bbs_mod.items.GunProperties;
import mchorse.bbs_mod.items.GunZoom;
import mchorse.bbs_mod.l10n.L10n;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.ClientNetwork;
import mchorse.bbs_mod.particles.ParticleManager;
import mchorse.bbs_mod.resources.AssetProvider;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.resources.packs.URLError;
import mchorse.bbs_mod.resources.packs.URLRepository;
import mchorse.bbs_mod.resources.packs.URLSourcePack;
import mchorse.bbs_mod.resources.packs.URLTextureErrorCallback;
import mchorse.bbs_mod.selectors.EntitySelectors;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanel;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIScreen;
import mchorse.bbs_mod.ui.model_blocks.UIModelBlockEditorMenu;
import mchorse.bbs_mod.ui.morphing.UIMorphingPanel;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import mchorse.bbs_mod.ui.utils.keys.KeybindSettings;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.ScreenshotRecorder;
import mchorse.bbs_mod.utils.VideoRecorder;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.resources.MinecraftSourcePack;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.impl.client.rendering.BlockEntityRendererRegistryImpl;
import net.minecraft.class_1041;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
public class BBSModClient
implements ClientModInitializer {
    private static TextureManager textures;
    private static FramebufferManager framebuffers;
    private static SoundManager sounds;
    private static L10n l10n;
    private static ModelManager models;
    private static FormCategories formCategories;
    private static ScreenshotRecorder screenshotRecorder;
    private static VideoRecorder videoRecorder;
    private static EntitySelectors selectors;
    private static ParticleManager particles;
    private static class_304 keyDashboard;
    private static class_304 keyItemEditor;
    private static class_304 keyPlayFilm;
    private static class_304 keyPauseFilm;
    private static class_304 keyRecordReplay;
    private static class_304 keyRecordVideo;
    private static class_304 keyOpenReplays;
    private static class_304 keyOpenMorphing;
    private static class_304 keyDemorph;
    private static class_304 keyTeleport;
    private static class_304 keyZoom;
    private static UIDashboard dashboard;
    private static CameraController cameraController;
    private static ModelBlockItemRenderer modelBlockItemRenderer;
    private static GunItemRenderer gunItemRenderer;
    private static Films films;
    private static GunZoom gunZoom;
    private static float originalFramebufferScale;

    public static TextureManager getTextures() {
        return textures;
    }

    public static FramebufferManager getFramebuffers() {
        return framebuffers;
    }

    public static SoundManager getSounds() {
        return sounds;
    }

    public static L10n getL10n() {
        return l10n;
    }

    public static ModelManager getModels() {
        return models;
    }

    public static FormCategories getFormCategories() {
        return formCategories;
    }

    public static ScreenshotRecorder getScreenshotRecorder() {
        return screenshotRecorder;
    }

    public static VideoRecorder getVideoRecorder() {
        return videoRecorder;
    }

    public static EntitySelectors getSelectors() {
        return selectors;
    }

    public static ParticleManager getParticles() {
        return particles;
    }

    public static CameraController getCameraController() {
        return cameraController;
    }

    public static Films getFilms() {
        return films;
    }

    public static GunZoom getGunZoom() {
        return gunZoom;
    }

    public static class_304 getKeyZoom() {
        return keyZoom;
    }

    public static class_304 getKeyRecordVideo() {
        return keyRecordVideo;
    }

    public static UIDashboard getDashboard() {
        if (dashboard == null) {
            dashboard = new UIDashboard();
        }
        return dashboard;
    }

    public static int getGUIScale() {
        int scale = (Integer)BBSSettings.userIntefaceScale.get();
        if (scale == 0) {
            return (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        }
        return scale;
    }

    public static float getOriginalFramebufferScale() {
        return Math.max(originalFramebufferScale, 1.0f);
    }

    public static ModelProperties getItemStackProperties(class_1799 stack) {
        ModelBlockItemRenderer.Item item = modelBlockItemRenderer.get(stack);
        if (item != null) {
            return item.entity.getProperties();
        }
        GunItemRenderer.Item gunItem = gunItemRenderer.get(stack);
        if (gunItem != null) {
            return gunItem.properties;
        }
        return null;
    }

    public static void onEndKey(long window, int key, int scancode, int action, int modifiers, CallbackInfo info) {
        if (action != 1) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        Morph morph = Morph.getMorph((class_1297)player);
        if (morph != null && morph.getForm() != null && morph.getForm().findState(key, (form, state) -> {
            ClientNetwork.sendFormTrigger((String)state.id.get(), 0);
            form.playState(state);
        })) {
            return;
        }
        if (player != null) {
            ModelProperties main = BBSModClient.getItemStackProperties(player.method_5998(class_1268.field_5808));
            ModelProperties offhand = BBSModClient.getItemStackProperties(player.method_5998(class_1268.field_5810));
            if (main != null && main.getForm() != null && main.getForm().findState(key, (form, state) -> {
                ClientNetwork.sendFormTrigger((String)state.id.get(), 1);
                form.playState(state);
            })) {
                return;
            }
            if (offhand != null && offhand.getForm() != null && offhand.getForm().findState(key, (form, state) -> {
                ClientNetwork.sendFormTrigger((String)state.id.get(), 2);
                form.playState(state);
            })) {
                return;
            }
        }
        for (Form form2 : BBSModClient.getFormCategories().getRecentForms().getCategories().get(0).getForms()) {
            if ((Integer)form2.hotkey.get() != key) continue;
            ClientNetwork.sendPlayerForm(form2);
            return;
        }
        for (UserFormCategory category : BBSModClient.getFormCategories().getUserForms().categories) {
            for (Form form3 : category.getForms()) {
                if ((Integer)form3.hotkey.get() != key) continue;
                ClientNetwork.sendPlayerForm(form3);
                return;
            }
        }
    }

    public void onInitializeClient() {
        AssetProvider provider = BBSMod.getProvider();
        textures = new TextureManager(provider);
        framebuffers = new FramebufferManager();
        sounds = new SoundManager(provider);
        l10n = new L10n();
        l10n.register(lang -> Collections.singletonList(Link.assets("strings/" + lang + ".json")));
        l10n.reload();
        File parentFile = BBSMod.getSettingsFolder().getParentFile();
        particles = new ParticleManager(() -> new File(BBSMod.getAssetsFolder(), "particles"));
        models = new ModelManager(provider);
        formCategories = new FormCategories();
        screenshotRecorder = new ScreenshotRecorder(new File(parentFile, "screenshots"));
        videoRecorder = new VideoRecorder();
        selectors = new EntitySelectors();
        selectors.read();
        films = new Films();
        BBSResources.init();
        URLRepository repository = new URLRepository(new File(parentFile, "url_cache"));
        provider.register(new URLSourcePack("http", repository));
        provider.register(new URLSourcePack("https", repository));
        KeybindSettings.registerClasses();
        BBSMod.setupConfig(Icons.KEY_CAP, "keybinds", new File(BBSMod.getSettingsFolder(), "keybinds.json"), KeybindSettings::register);
        BBSSettings.language.postCallback((v, f) -> BBSModClient.reloadLanguage(BBSModClient.getLanguageKey()));
        BBSSettings.visualizeStructures.postCallback((v, f) -> BBSModClient.getFormCategories().setup());
        BBSSettings.editorSeconds.postCallback((v, f) -> {
            UIDashboardPanel patt12055$temp;
            if (dashboard != null && (patt12055$temp = BBSModClient.dashboard.getPanels().panel) instanceof UIFilmPanel) {
                UIFilmPanel panel = (UIFilmPanel)patt12055$temp;
                panel.fillData();
            }
        });
        BBSSettings.tooltipStyle.modes(UIKeys.ENGINE_TOOLTIP_STYLE_LIGHT, UIKeys.ENGINE_TOOLTIP_STYLE_DARK);
        BBSSettings.keystrokeMode.modes(UIKeys.ENGINE_KEYSTROKES_POSITION_AUTO, UIKeys.ENGINE_KEYSTROKES_POSITION_BOTTOM_LEFT, UIKeys.ENGINE_KEYSTROKES_POSITION_BOTTOM_RIGHT, UIKeys.ENGINE_KEYSTROKES_POSITION_TOP_RIGHT, UIKeys.ENGINE_KEYSTROKES_POSITION_TOP_LEFT);
        BBSSettings.gizmoDesign.modes(UIKeys.GIZMOS_DESIGN_DEFAULT, UIKeys.GIZMOS_DESIGN_CLASSIC, UIKeys.GIZMOS_DESIGN_BLOCKBENCH);
        UIKeys.C_KEYBIND_CATGORIES.load(KeyCombo.getCategoryKeys());
        UIKeys.C_KEYBIND_CATGORIES_TOOLTIP.load(KeyCombo.getCategoryKeys());
        BBSMod.getFactoryCameraClips().register(Link.bbs("audio"), AudioClientClip.class, new ClipFactoryData(Icons.SOUND, 16762917)).register(Link.bbs("tracker"), TrackerClientClip.class, new ClipFactoryData(Icons.USER, 5041660)).register(Link.bbs("curve"), CurveClientClip.class, new ClipFactoryData(Icons.ARC, 16716947));
        keyDashboard = this.createKey("dashboard", 48);
        keyItemEditor = this.createKey("item_editor", 268);
        keyPlayFilm = this.createKey("play_film", 345);
        keyPauseFilm = this.createKey("pause_film", 92);
        keyRecordReplay = this.createKey("record_replay", 346);
        keyRecordVideo = this.createKey("record_video", 293);
        keyOpenReplays = this.createKey("open_replays", 344);
        keyOpenMorphing = this.createKey("open_morphing", 66);
        keyDemorph = this.createKey("demorph", 46);
        keyTeleport = this.createKey("teleport", 89);
        keyZoom = this.createKeyMouse("zoom", 2);
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            float d;
            if (!BBSRendering.isIrisShadersEnabled()) {
                BBSRendering.renderCoolStuff(context);
            }
            if (((Boolean)BBSSettings.chromaSkyEnabled.get()).booleanValue() && (d = ((Float)BBSSettings.chromaSkyBillboard.get()).floatValue()) > 0.0f) {
                class_4587 stack = context.matrixStack();
                Color color = Colors.COLOR.set((Integer)BBSSettings.chromaSkyColor.get());
                stack.method_22903();
                class_4587.class_4665 peek = stack.method_23760();
                peek.method_23761().identity();
                peek.method_23762().identity();
                stack.method_46416(0.0f, 0.0f, -d);
                RenderSystem.enableDepthTest();
                class_287 builder = class_289.method_1348().method_1349();
                builder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
                float fov = ((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue();
                float dd = d * (float)Math.pow(fov / 40.0f, 2.0);
                Draw.fillQuad(builder, stack, -dd, -dd, 0.0f, dd, -dd, 0.0f, dd, dd, 0.0f, -dd, dd, 0.0f, color.r, color.g, color.b, 1.0f);
                RenderSystem.setShader(class_757::method_34540);
                class_286.method_43433((class_287.class_7433)builder.method_1326());
                RenderSystem.disableDepthTest();
                stack.method_22909();
            }
        });
        WorldRenderEvents.LAST.register(context -> {
            if (videoRecorder.isRecording() && BBSRendering.canRender) {
                videoRecorder.recordFrame();
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            dashboard = null;
            films = new Films();
            ClientNetwork.resetHandshake();
            films.reset();
            cameraController.reset();
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> BBSRendering.startTick());
        ClientTickEvents.END_WORLD_TICK.register(client -> {
            class_310 mc = class_310.method_1551();
            if (!mc.method_1493()) {
                films.updateEndWorld();
            }
            BBSResources.tick();
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_310 mc = class_310.method_1551();
            class_437 patt17117$temp = mc.field_1755;
            if (patt17117$temp instanceof UIScreen) {
                UIScreen screen = (UIScreen)patt17117$temp;
                screen.update();
            }
            cameraController.update();
            if (!mc.method_1493()) {
                films.update();
                modelBlockItemRenderer.update();
                gunItemRenderer.update();
                textures.update();
            }
            while (keyDashboard.method_1436()) {
                UIScreen.open(BBSModClient.getDashboard());
            }
            while (keyItemEditor.method_1436()) {
                this.keyOpenModelBlockEditor(mc);
            }
            while (keyPlayFilm.method_1436()) {
                this.keyPlayFilm();
            }
            while (keyPauseFilm.method_1436()) {
                this.keyPauseFilm();
            }
            while (keyRecordReplay.method_1436()) {
                this.keyRecordReplay();
            }
            while (keyRecordVideo.method_1436()) {
                class_1041 window = mc.method_22683();
                int width = Math.max(window.method_4480(), 2);
                int height = Math.max(window.method_4507(), 2);
                if (width % 2 == 1) {
                    width -= width % 2;
                }
                if (height % 2 == 1) {
                    height -= height % 2;
                }
                videoRecorder.toggleRecording(BBSRendering.getTexture().id, width, height);
                BBSRendering.setCustomSize(videoRecorder.isRecording(), width, height);
            }
            while (keyOpenReplays.method_1436()) {
                this.keyOpenReplays();
            }
            while (keyOpenMorphing.method_1436()) {
                UIDashboard dashboard = BBSModClient.getDashboard();
                UIScreen.open(dashboard);
                dashboard.setPanel(dashboard.getPanel(UIMorphingPanel.class));
            }
            while (keyDemorph.method_1436()) {
                ClientNetwork.sendPlayerForm(null);
            }
            while (keyTeleport.method_1436()) {
                this.keyTeleport();
            }
            if (mc.field_1724 != null) {
                boolean zoom = keyZoom.method_1434();
                class_1799 stack = mc.field_1724.method_6047();
                if (gunZoom == null && zoom && stack.method_7909() == BBSMod.GUN_ITEM) {
                    GunProperties properties = GunProperties.get(stack);
                    ClientNetwork.sendZoom(true);
                    gunZoom = new GunZoom(properties.fovTarget, properties.fovInterp, properties.fovDuration);
                }
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            BBSRendering.renderHud(drawContext, tickDelta);
            if (gunZoom != null) {
                gunZoom.update(keyZoom.method_1434(), class_310.method_1551().method_1534());
                if (gunZoom.canBeRemoved()) {
                    ClientNetwork.sendZoom(false);
                    gunZoom = null;
                }
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(e -> BBSResources.stopWatchdog());
        ClientLifecycleEvents.CLIENT_STARTED.register(e -> {
            BBSRendering.setupFramebuffer();
            provider.register(new MinecraftSourcePack());
            class_1041 window = class_310.method_1551().method_22683();
            originalFramebufferScale = window.method_4489() / window.method_4480();
        });
        URLTextureErrorCallback.EVENT.register((url, error) -> {
            UIBaseMenu menu = UIScreen.getCurrentMenu();
            if (menu != null) {
                url = url.substring(0, MathUtils.clamp(url.length(), 0, 40));
                if (error == URLError.FFMPEG) {
                    menu.context.notifyError(UIKeys.TEXTURE_URL_ERROR_FFMPEG.format(url));
                } else if (error == URLError.HTTP_ERROR) {
                    menu.context.notifyError(UIKeys.TEXTURE_URL_ERROR_HTTP.format(url));
                }
            }
        });
        BBSRendering.setup();
        ClientNetwork.setup();
        EntityRendererRegistry.register(BBSMod.ACTOR_ENTITY, ActorEntityRenderer::new);
        EntityRendererRegistry.register(BBSMod.GUN_PROJECTILE_ENTITY, GunProjectileEntityRenderer::new);
        BlockEntityRendererRegistryImpl.register(BBSMod.MODEL_BLOCK_ENTITY, ModelBlockEntityRenderer::new);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)BBSMod.MODEL_BLOCK_ITEM, (BuiltinItemRendererRegistry.DynamicItemRenderer)modelBlockItemRenderer);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)BBSMod.GUN_ITEM, (BuiltinItemRendererRegistry.DynamicItemRenderer)gunItemRenderer);
        BBSMod.getAudioFolder().mkdirs();
        for (String path : List.of("alex", "alex_simple", "steve", "steve_simple")) {
            BBSMod.getAssetsPath("models/emoticons/" + path + "/").mkdirs();
        }
        for (String path : List.of("alex", "alex_bends", "eyes", "eyes_1px", "steve", "steve_bends")) {
            BBSMod.getAssetsPath("models/player/" + path + "/").mkdirs();
        }
    }

    private class_304 createKey(String id, int key) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bbs." + id, class_3675.class_307.field_1668, key, "category.bbs.main"));
    }

    private class_304 createKeyMouse(String id, int button) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bbs." + id, class_3675.class_307.field_1672, button, "category.bbs.main"));
    }

    private void keyOpenModelBlockEditor(class_310 mc) {
        class_1799 stack = mc.field_1724.method_6118(class_1304.field_6173);
        ModelBlockItemRenderer.Item item = modelBlockItemRenderer.get(stack);
        GunItemRenderer.Item gunItem = gunItemRenderer.get(stack);
        if (item != null) {
            UIScreen.open(new UIModelBlockEditorMenu(item.entity.getProperties()));
        } else if (gunItem != null) {
            UIScreen.open(new UIModelBlockEditorMenu(gunItem.properties));
        }
    }

    private void keyPlayFilm() {
        UIFilmPanel panel = BBSModClient.getDashboard().getPanel(UIFilmPanel.class);
        if (panel.getData() != null) {
            Films.playFilm(((Film)panel.getData()).getId(), false);
        }
    }

    private void keyPauseFilm() {
        UIFilmPanel panel = BBSModClient.getDashboard().getPanel(UIFilmPanel.class);
        if (panel.getData() != null) {
            Films.pauseFilm(((Film)panel.getData()).getId());
        }
    }

    private void keyRecordReplay() {
        UIDashboard dashboard = BBSModClient.getDashboard();
        UIFilmPanel panel = dashboard.getPanel(UIFilmPanel.class);
        if (panel != null && panel.getData() != null) {
            Recorder recorder = BBSModClient.getFilms().getRecorder();
            if (recorder != null) {
                recorder = BBSModClient.getFilms().stopRecording();
                if (recorder == null || recorder.hasNotStarted() || panel.getData() == null) {
                    return;
                }
                panel.applyRecordedKeyframes(recorder, (Film)panel.getData());
            } else {
                Replay replay = panel.replayEditor.getReplay();
                int index = ((Film)panel.getData()).replays.getList().indexOf(replay);
                if (index >= 0) {
                    BBSModClient.getFilms().startRecording((Film)panel.getData(), index, 0);
                }
            }
        }
    }

    private void keyOpenReplays() {
        UIFilmPanel panel;
        UIDashboard dashboard = BBSModClient.getDashboard();
        UIScreen.open(dashboard);
        UIDashboardPanel uIDashboardPanel = dashboard.getPanels().panel;
        if (uIDashboardPanel instanceof UIFilmPanel && (panel = (UIFilmPanel)uIDashboardPanel).getData() != null) {
            panel.preview.openReplays();
        } else {
            dashboard.setPanel(dashboard.getPanel(UIFilmPanel.class));
        }
    }

    private void keyTeleport() {
        UIDashboard dashboard = BBSModClient.getDashboard();
        UIFilmPanel panel = dashboard.getPanel(UIFilmPanel.class);
        if (panel != null) {
            panel.replayEditor.teleport();
        }
    }

    public static String getLanguageKey() {
        return BBSModClient.getLanguageKey((String)BBSSettings.language.get());
    }

    public static String getLanguageKey(String key) {
        if (key.isEmpty()) {
            key = class_310.method_1551().field_1690.field_1883;
        }
        return key;
    }

    public static void reloadLanguage(String language) {
        l10n.reload(language, BBSMod.getProvider());
    }

    static {
        cameraController = new CameraController();
        modelBlockItemRenderer = new ModelBlockItemRenderer();
        gunItemRenderer = new GunItemRenderer();
    }
}

