/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.audio;

import java.io.InputStream;
import mchorse.bbs_mod.audio.Wave;
import mchorse.bbs_mod.audio.ogg.VorbisReader;
import mchorse.bbs_mod.audio.wav.WaveReader;
import mchorse.bbs_mod.resources.AssetProvider;
import mchorse.bbs_mod.resources.Link;

public class AudioReader {
    public static Wave read(AssetProvider provider, Link link) throws Exception {
        String pathLower = link.path.toLowerCase();
        if (!pathLower.endsWith(".wav") && !pathLower.endsWith(".ogg")) {
            return null;
        }
        try (InputStream asset = provider.getAsset(link);){
            if (pathLower.endsWith(".wav")) {
                Wave wave = new WaveReader().read(asset);
                return wave;
            }
            if (pathLower.endsWith(".ogg")) {
                Wave wave = VorbisReader.read(link, asset);
                return wave;
            }
        }
        throw new IllegalStateException("Given link " + String.valueOf(link) + " isn't a Wave or a Vorbis file!");
    }
}

