/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.geo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.cubic.data.model.Model;
import mchorse.bbs_mod.cubic.data.model.ModelCube;
import mchorse.bbs_mod.cubic.data.model.ModelGroup;
import mchorse.bbs_mod.cubic.data.model.ModelUV;
import mchorse.bbs_mod.math.molang.MolangParser;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GeoModelParser {
    public static Model parse(JsonObject object, MolangParser parser) {
        Model model = new Model(parser);
        if ((object = object.get("minecraft:geometry").getAsJsonArray().get(0).getAsJsonObject()).has("description")) {
            GeoModelParser.parseDescription(model, object.get("description").getAsJsonObject());
        }
        if (object.has("bones")) {
            GeoModelParser.parseBones(model, object.get("bones").getAsJsonArray());
        }
        model.initialize();
        return model;
    }

    private static void parseDescription(Model model, JsonObject object) {
        if (object.has("texture_width")) {
            model.textureWidth = object.get("texture_width").getAsInt();
        }
        if (object.has("texture_height")) {
            model.textureHeight = object.get("texture_height").getAsInt();
        }
    }

    private static void parseBones(Model model, JsonArray bones) {
        HashMap<String, List> hierarchy = new HashMap<String, List>();
        HashMap<String, ModelGroup> flatBones = new HashMap<String, ModelGroup>();
        for (JsonElement element : bones) {
            JsonObject boneElement = element.getAsJsonObject();
            ModelGroup bone = new ModelGroup(boneElement.get("name").getAsString());
            String parent = boneElement.has("parent") ? boneElement.get("parent").getAsString() : "";
            List list = hierarchy.computeIfAbsent(parent, k -> new ArrayList());
            list.add(bone.id);
            if (boneElement.has("pivot")) {
                GeoModelParser.parseVector(boneElement.get("pivot"), bone.initial.translate);
                bone.initial.pivot.set((Vector3fc)bone.initial.translate);
            }
            if (boneElement.has("scale")) {
                GeoModelParser.parseVector(boneElement.get("scale"), bone.initial.scale);
            }
            if (boneElement.has("rotation")) {
                GeoModelParser.parseVector(boneElement.get("rotation"), bone.initial.rotate);
                bone.initial.rotate.x *= -1.0f;
                bone.initial.rotate.y *= -1.0f;
            }
            bone.initial.translate.x *= -1.0f;
            bone.initial.pivot.x *= -1.0f;
            if (boneElement.has("cubes")) {
                GeoModelParser.parseCubes(model, bone, boneElement.get("cubes").getAsJsonArray());
            }
            flatBones.put(bone.id, bone);
        }
        for (Map.Entry entry : hierarchy.entrySet()) {
            if (((String)entry.getKey()).isEmpty()) continue;
            ModelGroup bone = (ModelGroup)flatBones.get(entry.getKey());
            for (String child : (List)entry.getValue()) {
                bone.children.add((ModelGroup)flatBones.get(child));
            }
        }
        List topLevel = (List)hierarchy.get("");
        if (topLevel != null) {
            for (String topLevelBone : topLevel) {
                model.topGroups.add((ModelGroup)flatBones.get(topLevelBone));
            }
        }
    }

    private static void parseCubes(Model model, ModelGroup bone, JsonArray cubes) {
        for (JsonElement element : cubes) {
            bone.cubes.add(GeoModelParser.parseCube(model, element.getAsJsonObject()));
        }
    }

    private static ModelCube parseCube(Model model, JsonObject object) {
        ModelCube cube = new ModelCube();
        if (object.has("inflate")) {
            cube.inflate = object.get("inflate").getAsFloat();
        }
        GeoModelParser.parseVector(object.get("origin"), cube.origin);
        GeoModelParser.parseVector(object.get("size"), cube.size);
        cube.origin.x *= -1.0f;
        cube.origin.x -= cube.size.x;
        if (object.has("pivot")) {
            GeoModelParser.parseVector(object.get("pivot"), cube.pivot);
            cube.pivot.x *= -1.0f;
        } else {
            cube.pivot.set((Vector3fc)cube.origin);
        }
        if (object.has("rotation")) {
            GeoModelParser.parseVector(object.get("rotation"), cube.rotate);
            cube.rotate.x *= -1.0f;
            cube.rotate.y *= -1.0f;
        }
        if (object.has("uv")) {
            boolean mirror = object.has("mirror") && object.get("mirror").getAsBoolean();
            GeoModelParser.parseUV(cube, object.get("uv"), mirror);
        }
        cube.generateQuads(model.textureWidth, model.textureHeight);
        return cube;
    }

    private static void parseUV(ModelCube cube, JsonElement element, boolean mirror) {
        if (element.isJsonArray()) {
            Vector2f boxUV = new Vector2f();
            GeoModelParser.parseVector((JsonElement)element.getAsJsonArray(), boxUV);
            cube.setupBoxUV(boxUV, mirror);
        } else if (element.isJsonObject()) {
            JsonObject sides = element.getAsJsonObject();
            if (sides.has("north")) {
                cube.front = GeoModelParser.parseUVSide(sides.get("north").getAsJsonObject());
            }
            if (sides.has("east")) {
                cube.right = GeoModelParser.parseUVSide(sides.get("east").getAsJsonObject());
            }
            if (sides.has("south")) {
                cube.back = GeoModelParser.parseUVSide(sides.get("south").getAsJsonObject());
            }
            if (sides.has("west")) {
                cube.left = GeoModelParser.parseUVSide(sides.get("west").getAsJsonObject());
            }
            if (sides.has("up")) {
                cube.top = GeoModelParser.parseUVSide(sides.get("up").getAsJsonObject());
                cube.top.size.mul(-1.0f);
                cube.top.origin.sub((Vector2fc)cube.top.size);
            }
            if (sides.has("down")) {
                cube.bottom = GeoModelParser.parseUVSide(sides.get("down").getAsJsonObject());
                cube.bottom.size.mul(-1.0f);
                cube.bottom.origin.sub((Vector2fc)cube.bottom.size);
            }
        }
    }

    private static ModelUV parseUVSide(JsonObject uvSide) {
        ModelUV uv = new ModelUV();
        GeoModelParser.parseVector(uvSide.get("uv"), uv.origin);
        GeoModelParser.parseVector(uvSide.get("uv_size"), uv.size);
        return uv;
    }

    private static void parseVector(JsonElement element, Vector3f vector) {
        JsonArray array = element.getAsJsonArray();
        vector.x = array.get(0).getAsFloat();
        vector.y = array.get(1).getAsFloat();
        vector.z = array.get(2).getAsFloat();
    }

    private static void parseVector(JsonElement element, Vector2f vector) {
        JsonArray array = element.getAsJsonArray();
        vector.x = array.get(0).getAsFloat();
        vector.y = array.get(1).getAsFloat();
    }
}

