/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.render.vao;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.bobj.BOBJArmature;
import mchorse.bbs_mod.bobj.BOBJBone;
import mchorse.bbs_mod.bobj.BOBJLoader;
import mchorse.bbs_mod.cubic.render.vao.BOBJModelVAO;
import mchorse.bbs_mod.utils.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class BOBJModelSimpleVAO
extends BOBJModelVAO {
    public Joint armLeft;
    public Joint armRight;
    public Joint legLeft;
    public Joint legRight;
    public Joint body;

    public BOBJModelSimpleVAO(BOBJLoader.CompiledData data) {
        super(data);
        this.armLeft = new Joint(this.armature.bones.get("left_arm"), this.armature.bones.get("low_left_arm"));
        this.armRight = new Joint(this.armature.bones.get("right_arm"), this.armature.bones.get("low_right_arm"));
        this.legLeft = new Joint(this.armature.bones.get("left_leg"), this.armature.bones.get("low_left_leg"));
        this.legRight = new Joint(this.armature.bones.get("right_leg"), this.armature.bones.get("low_leg_right"));
        this.body = new Joint(this.armature.bones.get("body"), this.armature.bones.get("low_body"));
    }

    @Override
    protected void processData(float[] newVertices, float[] newNormals) {
        if (!this.armLeft.isFilled()) {
            float rmn1 = 0.34375f;
            float rmx1 = 0.46875f;
            float rmn2 = 0.84375f;
            float rmx2 = 0.96875f;
            float rmn3 = 0.59375f;
            float rmx3 = 0.71875f;
            int c = this.data.posData.length / 3;
            for (int i = 0; i < c; ++i) {
                double v = this.data.texData[i * 2 + 1];
                JointType type = JointType.NONE;
                for (int j = 0; j < 4; ++j) {
                    int boneIndex = this.data.boneIndexData[i * 4 + j];
                    if (boneIndex == -1) continue;
                    BOBJBone bone = this.armature.orderedBones.get(boneIndex);
                    if (bone.name.contains("leg")) {
                        type = JointType.LEG;
                    } else if (bone.name.contains("arm")) {
                        type = JointType.ARM;
                    } else if (bone.name.contains("body")) {
                        type = JointType.BODY;
                    }
                    if (type != JointType.NONE) break;
                }
                if (!(v >= (double)rmn1 && v <= (double)rmx1 || v >= (double)rmn2 && v <= (double)rmx2) && (!(v >= (double)rmn3) || !(v <= (double)rmx3)) || type == JointType.NONE) continue;
                float z = this.data.posData[i * 3 + 2];
                Joint joint = type == JointType.BODY ? this.body : (v > 0.75 ? (type == JointType.LEG ? this.legLeft : this.armLeft) : (type == JointType.LEG ? this.legRight : this.armRight));
                List<Integer> list = z < 0.0f ? joint.back : joint.front;
                list.add(i);
            }
        }
        this.armRight.process(this.data, this.armature, newVertices, newNormals);
        this.armLeft.process(this.data, this.armature, newVertices, newNormals);
        this.legRight.process(this.data, this.armature, newVertices, newNormals);
        this.legLeft.process(this.data, this.armature, newVertices, newNormals);
        this.body.process(this.data, this.armature, newVertices, newNormals);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Joint {
        public static Vector4f temporary = new Vector4f();
        public List<Integer> front = new ArrayList<Integer>();
        public List<Integer> back = new ArrayList<Integer>();
        public BOBJBone top;
        public BOBJBone joint;

        public Joint(BOBJBone top, BOBJBone joint) {
            this.top = top;
            this.joint = joint;
        }

        public boolean isFilled() {
            return !this.front.isEmpty();
        }

        public void process(BOBJLoader.CompiledData data, BOBJArmature armature, float[] posData, float[] normalData) {
            float pi = (float)Math.PI;
            float rotation = this.joint.transform.rotate.x;
            float frontFactor = MathUtils.clamp((rotation + 1.5707964f) / (float)Math.PI, 0.0f, 1.0f);
            float backFactor = 1.0f - frontFactor;
            this.processSide(data, armature, this.front, posData, normalData, frontFactor);
            this.processSide(data, armature, this.back, posData, normalData, backFactor);
        }

        protected void processSide(BOBJLoader.CompiledData data, BOBJArmature armature, List<Integer> indices, float[] posData, float[] normalData, float factor) {
            int prevIndex = 0;
            for (int i : indices) {
                float x = data.posData[i * 3];
                float y = data.posData[i * 3 + 1] + factor * 4.0f / 16.0f - 0.125f;
                float z = data.posData[i * 3 + 2];
                temporary.set(x, y, z, 1.0f);
                armature.matrices[this.top.index].transform(temporary);
                posData[i * 3] = Joint.temporary.x;
                posData[i * 3 + 1] = Joint.temporary.y;
                posData[i * 3 + 2] = Joint.temporary.z;
                int base = i - i % 3;
                int a = i - base;
                int b = prevIndex - base;
                int c = 0;
                if (b >= 0) {
                    if (a == 0 && b == 2 || b == 0 && a == 2) {
                        c = 1;
                    } else if (a == 0 && b == 1 || b == 0 && a == 1) {
                        c = 2;
                    }
                } else {
                    c = a == 1 ? 0 : 1;
                }
                normalData[i * 3] = normalData[(c += base) * 3];
                normalData[i * 3 + 1] = normalData[c * 3 + 1];
                normalData[i * 3 + 2] = normalData[c * 3 + 2];
                if (b >= 0) {
                    normalData[prevIndex * 3] = normalData[c * 3];
                    normalData[prevIndex * 3 + 1] = normalData[c * 3 + 1];
                    normalData[prevIndex * 3 + 2] = normalData[c * 3 + 2];
                }
                prevIndex = i;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum JointType {
        LEG,
        ARM,
        BODY,
        NONE;

    }
}

