/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.forms.VisibilityManager;
import mchorse.bbs_mod.forms.categories.FormCategory;
import mchorse.bbs_mod.forms.sections.ExtraFormSection;
import mchorse.bbs_mod.forms.sections.FormSection;
import mchorse.bbs_mod.forms.sections.ModelFormSection;
import mchorse.bbs_mod.forms.sections.ParticleFormSection;
import mchorse.bbs_mod.forms.sections.RecentFormSection;
import mchorse.bbs_mod.forms.sections.StructureFormSection;
import mchorse.bbs_mod.forms.sections.UserFormSection;
import mchorse.bbs_mod.utils.watchdog.IWatchDogListener;
import mchorse.bbs_mod.utils.watchdog.WatchDogEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FormCategories
implements IWatchDogListener {
    public final VisibilityManager visibility = new VisibilityManager();
    private List<FormSection> sections = new ArrayList<FormSection>();
    private RecentFormSection recentForms = new RecentFormSection(this);
    private UserFormSection userForms = new UserFormSection(this);
    private long lastUpdate;

    public void setup() {
        this.sections.clear();
        this.sections.add(this.recentForms);
        this.sections.add(this.userForms);
        this.sections.add(new ModelFormSection(this));
        this.sections.add(new ParticleFormSection(this));
        if (BBSSettings.visualizeStructures != null && ((Boolean)BBSSettings.visualizeStructures.get()).booleanValue()) {
            this.sections.add(new StructureFormSection(this));
        }
        this.sections.add(new ExtraFormSection(this));
        for (FormSection section : this.sections) {
            section.initiate();
        }
        this.markDirty();
        this.visibility.read();
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void markDirty() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public RecentFormSection getRecentForms() {
        return this.recentForms;
    }

    public UserFormSection getUserForms() {
        return this.userForms;
    }

    public List<FormCategory> getAllCategories() {
        ArrayList<FormCategory> formCategories = new ArrayList<FormCategory>();
        for (FormSection section : this.sections) {
            formCategories.addAll(section.getCategories());
        }
        return formCategories;
    }

    @Override
    public void accept(Path path, WatchDogEvent event) {
        for (FormSection section : this.sections) {
            section.accept(path, event);
        }
    }
}

