/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.BodyPart;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.settings.values.core.ValueTransform;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.keys.KeyCodes;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_284;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_742;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public abstract class FormRenderer<T extends Form> {
    protected T form;

    public FormRenderer(T form) {
        this.form = form;
    }

    public T getForm() {
        return this.form;
    }

    public List<String> getBones() {
        return Collections.emptyList();
    }

    public final void renderUI(UIContext context, int x1, int y1, int x2, int y2) {
        int keybind;
        this.renderInUI(context, x1, y1, x2, y2);
        FontRenderer font = context.batcher.getFont();
        String name = (String)((Form)this.form).name.get();
        if (!name.isEmpty()) {
            name = font.limitToWidth(name, x2 - x1 - 3);
            int w = font.getWidth(name);
            context.batcher.textCard(name, (x2 + x1 - w) / 2, y1 + 6, -1, -2013230849);
        }
        if ((keybind = ((Integer)((Form)this.form).hotkey.get()).intValue()) > 0) {
            name = KeyCodes.getName(keybind);
            name = font.limitToWidth(name, x2 - x1 - 3);
            int w = font.getWidth(name);
            context.batcher.textCard(name, (x2 + x1 - w) / 2, y2 - 6 - font.getHeight(), -1, -2013265920);
        }
    }

    protected abstract void renderInUI(UIContext var1, int var2, int var3, int var4, int var5);

    public boolean renderArm(class_4587 matrices, int light, class_742 player, class_1268 hand) {
        return false;
    }

    public final void render(FormRenderingContext context) {
        if (!((Boolean)((Form)this.form).shaderShadow.get()).booleanValue() && BBSRendering.isIrisShadowPass()) {
            return;
        }
        ((Form)this.form).applyStates(context.transition);
        int light = context.light;
        boolean visible = (Boolean)((Form)this.form).visible.get();
        if (!visible) {
            return;
        }
        boolean isPicking = context.stencilMap != null;
        context.stack.method_22903();
        this.applyTransforms(context.stack, context.getTransition());
        float lf = 1.0f - MathUtils.clamp(((Float)((Form)this.form).lighting.get()).floatValue(), 0.0f, 1.0f);
        int u = context.light & 0xFFFF;
        int v = context.light >> 16 & 0xFFFF;
        u = (int)Lerps.lerp(u, 240.0f, lf);
        context.light = u | v << 16;
        this.render3D(context);
        if (isPicking) {
            this.updateStencilMap(context);
        }
        this.renderBodyParts(context);
        context.stack.method_22909();
        context.light = light;
        ((Form)this.form).unapplyStates();
    }

    protected void applyTransforms(class_4587 stack, float transition) {
        MatrixStackUtils.applyTransform(stack, this.createTransform());
    }

    protected void applyTransforms(Matrix4f matrix, float transition) {
        matrix.mul((Matrix4fc)this.createTransform().createMatrix());
    }

    protected Transform createTransform() {
        Transform transform = new Transform();
        transform.copy((Transform)((Form)this.form).transform.get());
        this.applyTransform(transform, (Transform)((Form)this.form).transformOverlay.get());
        for (ValueTransform t : ((Form)this.form).additionalTransforms) {
            this.applyTransform(transform, (Transform)t.get());
        }
        return transform;
    }

    private void applyTransform(Transform transform, Transform overlay) {
        transform.translate.add((Vector3fc)overlay.translate);
        transform.scale.add((Vector3fc)overlay.scale).sub(1.0f, 1.0f, 1.0f);
        transform.rotate.add((Vector3fc)overlay.rotate);
        transform.rotate2.add((Vector3fc)overlay.rotate2);
        transform.pivot.add((Vector3fc)overlay.pivot);
    }

    protected Supplier<class_5944> getShader(FormRenderingContext context, Supplier<class_5944> normal, Supplier<class_5944> picking) {
        if (context.isPicking()) {
            this.setupTarget(context, picking.get());
            return picking;
        }
        return normal;
    }

    protected void setupTarget(FormRenderingContext context, class_5944 program) {
        class_284 target = program.method_34582("Target");
        if (target != null) {
            int pickingIndex = context.getPickingIndex();
            target.method_35649(pickingIndex);
        }
    }

    protected void updateStencilMap(FormRenderingContext context) {
        context.stencilMap.addPicking((Form)this.form);
    }

    protected void render3D(FormRenderingContext context) {
    }

    public void renderBodyParts(FormRenderingContext context) {
        for (BodyPart part : ((Form)this.form).parts.getAllTyped()) {
            this.renderBodyPart(part, context);
        }
    }

    protected void renderBodyPart(BodyPart part, FormRenderingContext context) {
        IEntity oldEntity = context.entity;
        IEntity iEntity = context.entity = (Boolean)part.useTarget.get() != false ? oldEntity : part.getEntity();
        if (part.getForm() != null) {
            context.stack.method_22903();
            MatrixStackUtils.applyTransform(context.stack, (Transform)part.transform.get());
            FormUtilsClient.render(part.getForm(), context);
            context.stack.method_22909();
        }
        context.entity = oldEntity;
    }

    public Map<String, Matrix4f> collectMatrices(IEntity entity, String target, float transition) {
        HashMap<String, Matrix4f> map = new HashMap<String, Matrix4f>();
        class_4587 stack = new class_4587();
        this.collectMatrices(entity, target, stack, map, "", transition);
        return map;
    }

    public void collectMatrices(IEntity entity, String target, class_4587 stack, Map<String, Matrix4f> matrices, String prefix, float transition) {
        stack.method_22903();
        this.applyTransforms(stack, transition);
        matrices.put(prefix, new Matrix4f((Matrix4fc)stack.method_23760().method_23761()));
        int i = 0;
        for (BodyPart part : ((Form)this.form).parts.getAllTyped()) {
            Form form = part.getForm();
            if (form != null) {
                stack.method_22903();
                MatrixStackUtils.applyTransform(stack, (Transform)part.transform.get());
                FormUtilsClient.getRenderer(form).collectMatrices(entity, target, stack, matrices, StringUtils.combinePaths(prefix, String.valueOf(i)), transition);
                stack.method_22909();
            }
            ++i;
        }
        stack.method_22909();
    }
}

