/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.sections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.forms.FormCategories;
import mchorse.bbs_mod.forms.categories.FormCategory;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.sections.FormSection;
import mchorse.bbs_mod.l10n.keys.IKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class SubFormSection
extends FormSection {
    protected Map<String, FormCategory> categories = new LinkedHashMap<String, FormCategory>();

    public SubFormSection(FormCategories parent) {
        super(parent);
    }

    protected abstract IKey getTitle();

    protected abstract Form create(String var1);

    protected FormCategory createCategory(IKey uiKey, String id) {
        return new FormCategory(uiKey, this.parent.visibility.get(id));
    }

    protected abstract boolean isEqual(Form var1, String var2);

    protected String getKey(String key) {
        int slash = key.lastIndexOf(47);
        return slash >= 0 ? key.substring(0, slash) : "";
    }

    protected FormCategory getCategory(String key) {
        String newKey = this.getKey(key);
        return this.categories.computeIfAbsent(newKey, k -> {
            IKey uiKey = this.getTitle();
            if (!newKey.isEmpty()) {
                uiKey = IKey.comp(Arrays.asList(uiKey, IKey.constant(" (" + newKey + ")")));
            }
            return this.createCategory(uiKey, key);
        });
    }

    protected void add(String key) {
        FormCategory category = this.getCategory(key);
        for (Form form : category.getForms()) {
            if (!this.isEqual(form, key)) continue;
            return;
        }
        category.addForm(this.create(key));
    }

    protected void remove(String key) {
        FormCategory category = this.getCategory(key);
        Iterator<Form> it = category.getDirectForms().iterator();
        while (it.hasNext()) {
            if (!this.isEqual(it.next(), key)) continue;
            it.remove();
            this.parent.markDirty();
        }
        if (category.getForms().isEmpty()) {
            this.categories.remove(this.getKey(key));
            this.parent.markDirty();
        }
    }

    @Override
    public List<FormCategory> getCategories() {
        return new ArrayList<FormCategory>(this.categories.values());
    }
}

