/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.graphics.texture;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.cubic.render.vao.ModelVAO;
import mchorse.bbs_mod.cubic.render.vao.ModelVAOData;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.resources.Pixels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TextureExtruder {
    private Map<Link, ModelVAO> extruded = new HashMap<Link, ModelVAO>();

    public static void fillTexturedNormalQuad(List<Float> vertices, List<Float> normals, List<Float> uvs, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, float nx, float ny, float nz) {
        vertices.add(Float.valueOf(x2));
        vertices.add(Float.valueOf(y2));
        vertices.add(Float.valueOf(z2));
        uvs.add(Float.valueOf(u1));
        uvs.add(Float.valueOf(v2));
        normals.add(Float.valueOf(nx));
        normals.add(Float.valueOf(ny));
        normals.add(Float.valueOf(nz));
        vertices.add(Float.valueOf(x1));
        vertices.add(Float.valueOf(y1));
        vertices.add(Float.valueOf(z1));
        uvs.add(Float.valueOf(u2));
        uvs.add(Float.valueOf(v2));
        normals.add(Float.valueOf(nx));
        normals.add(Float.valueOf(ny));
        normals.add(Float.valueOf(nz));
        vertices.add(Float.valueOf(x4));
        vertices.add(Float.valueOf(y4));
        vertices.add(Float.valueOf(z4));
        uvs.add(Float.valueOf(u2));
        uvs.add(Float.valueOf(v1));
        normals.add(Float.valueOf(nx));
        normals.add(Float.valueOf(ny));
        normals.add(Float.valueOf(nz));
        vertices.add(Float.valueOf(x2));
        vertices.add(Float.valueOf(y2));
        vertices.add(Float.valueOf(z2));
        uvs.add(Float.valueOf(u1));
        uvs.add(Float.valueOf(v2));
        normals.add(Float.valueOf(nx));
        normals.add(Float.valueOf(ny));
        normals.add(Float.valueOf(nz));
        vertices.add(Float.valueOf(x4));
        vertices.add(Float.valueOf(y4));
        vertices.add(Float.valueOf(z4));
        uvs.add(Float.valueOf(u2));
        uvs.add(Float.valueOf(v1));
        normals.add(Float.valueOf(nx));
        normals.add(Float.valueOf(ny));
        normals.add(Float.valueOf(nz));
        vertices.add(Float.valueOf(x3));
        vertices.add(Float.valueOf(y3));
        vertices.add(Float.valueOf(z3));
        uvs.add(Float.valueOf(u1));
        uvs.add(Float.valueOf(v1));
        normals.add(Float.valueOf(nx));
        normals.add(Float.valueOf(ny));
        normals.add(Float.valueOf(nz));
    }

    public void delete(Link key) {
        ModelVAO remove = this.extruded.remove(key);
        if (remove != null) {
            remove.delete();
        }
    }

    public void deleteAll() {
        for (ModelVAO value : this.extruded.values()) {
            value.delete();
        }
        this.extruded.clear();
    }

    public ModelVAO get(Link key) {
        if (this.extruded.containsKey(key)) {
            return this.extruded.get(key);
        }
        Pixels pixels = null;
        try {
            pixels = BBSModClient.getTextures().getPixels(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pixels == null) {
            this.extruded.put(key, null);
            return null;
        }
        ModelVAO buffer = this.generate(pixels);
        pixels.delete();
        this.extruded.put(key, buffer);
        return buffer;
    }

    private ModelVAO generate(Pixels pixels) {
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Float> normals = new ArrayList<Float>();
        ArrayList<Float> uvs = new ArrayList<Float>();
        float px = 0.5f;
        float py = 0.5f;
        float u1 = 0.0f;
        float v1 = 0.0f;
        float u2 = 1.0f;
        float v2 = 1.0f;
        float d = 0.03125f;
        if (pixels.width > pixels.height) {
            py = (float)pixels.height / (float)pixels.width * 0.5f;
        } else if (pixels.height > pixels.width) {
            px = (float)pixels.width / (float)pixels.height * 0.5f;
        }
        float nx = -px;
        float ny = -py;
        TextureExtruder.fillTexturedNormalQuad(vertices, normals, uvs, px, ny, d, nx, ny, d, nx, py, d, px, py, d, u1, v1, u2, v2, 0.0f, 0.0f, 1.0f);
        TextureExtruder.fillTexturedNormalQuad(vertices, normals, uvs, nx, ny, -d, px, ny, -d, px, py, -d, nx, py, -d, u2, v1, u1, v2, 0.0f, 0.0f, -1.0f);
        for (int i = 0; i < pixels.width; ++i) {
            for (int j = 0; j < pixels.height; ++j) {
                if (!this.hasPixel(pixels, i, j)) continue;
                this.generateNeighbors(pixels, vertices, normals, uvs, px, py, i, j, d);
            }
        }
        if (!vertices.isEmpty()) {
            float[] v = CollectionUtils.toArray(vertices);
            float[] n = CollectionUtils.toArray(normals);
            float[] u = CollectionUtils.toArray(uvs);
            float[] t = BBSRendering.calculateTangents(v, n, u);
            return new ModelVAO(new ModelVAOData(v, n, t, u));
        }
        return null;
    }

    private void generateNeighbors(Pixels pixels, List<Float> vertices, List<Float> normals, List<Float> uvs, float px, float py, int x, int y, float d) {
        float w = pixels.width;
        float h = pixels.height;
        float sx = 1.0f / w * (px / 0.5f);
        float sy = 1.0f / h * (py / 0.5f);
        float u = ((float)x + 0.5f) / w;
        float v = ((float)y + 0.5f) / h;
        if (!this.hasPixel(pixels, x - 1, y) || x == 0) {
            TextureExtruder.fillTexturedNormalQuad(vertices, normals, uvs, (float)x * sx - px, (float)(-(y + 1)) * sy + py, -d, (float)x * sx - px, (float)(-y) * sy + py, -d, (float)x * sx - px, (float)(-y) * sy + py, d, (float)x * sx - px, (float)(-(y + 1)) * sy + py, d, u, v, u, v, -1.0f, 0.0f, 0.0f);
        }
        if (!this.hasPixel(pixels, x + 1, y) || (float)x == w - 1.0f) {
            TextureExtruder.fillTexturedNormalQuad(vertices, normals, uvs, (float)(x + 1) * sx - px, (float)(-(y + 1)) * sy + py, d, (float)(x + 1) * sx - px, (float)(-y) * sy + py, d, (float)(x + 1) * sx - px, (float)(-y) * sy + py, -d, (float)(x + 1) * sx - px, (float)(-(y + 1)) * sy + py, -d, u, v, u, v, 1.0f, 0.0f, 0.0f);
        }
        if (!this.hasPixel(pixels, x, y - 1) || y == 0) {
            TextureExtruder.fillTexturedNormalQuad(vertices, normals, uvs, (float)(x + 1) * sx - px, (float)(-y) * sy + py, d, (float)x * sx - px, (float)(-y) * sy + py, d, (float)x * sx - px, (float)(-y) * sy + py, -d, (float)(x + 1) * sx - px, (float)(-y) * sy + py, -d, u, v, u, v, 0.0f, 1.0f, 0.0f);
        }
        if (!this.hasPixel(pixels, x, y + 1) || (float)y == h - 1.0f) {
            TextureExtruder.fillTexturedNormalQuad(vertices, normals, uvs, (float)(x + 1) * sx - px, (float)(-(y + 1)) * sy + py, -d, (float)x * sx - px, (float)(-(y + 1)) * sy + py, -d, (float)x * sx - px, (float)(-(y + 1)) * sy + py, d, (float)(x + 1) * sx - px, (float)(-(y + 1)) * sy + py, d, u, v, u, v, 0.0f, -1.0f, 0.0f);
        }
    }

    private boolean hasPixel(Pixels pixels, int x, int y) {
        Color pixel = pixels.getColor(x, y);
        return pixel != null && pixel.a >= 1.0f;
    }
}

