/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.particles.components.expiration;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.math.Operation;
import mchorse.bbs_mod.math.molang.MolangException;
import mchorse.bbs_mod.math.molang.MolangParser;
import mchorse.bbs_mod.particles.components.IComponentParticleUpdate;
import mchorse.bbs_mod.particles.components.ParticleComponentBase;
import mchorse.bbs_mod.particles.emitter.Particle;
import mchorse.bbs_mod.particles.emitter.ParticleEmitter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Environment(value=EnvType.CLIENT)
public class ParticleComponentKillPlane
extends ParticleComponentBase
implements IComponentParticleUpdate {
    public float a;
    public float b;
    public float c;
    public float d;

    @Override
    public BaseType toData() {
        ListType list = new ListType();
        if (Operation.equals(this.a, 0.0) && Operation.equals(this.b, 0.0) && Operation.equals(this.c, 0.0) && Operation.equals(this.d, 0.0)) {
            return list;
        }
        list.addFloat(this.a);
        list.addFloat(this.b);
        list.addFloat(this.c);
        list.addFloat(this.d);
        return list;
    }

    @Override
    public ParticleComponentBase fromData(BaseType data, MolangParser parser) throws MolangException {
        if (!data.isList()) {
            return super.fromData(data, parser);
        }
        ListType list = data.asList();
        if (list.size() >= 4) {
            this.a = list.getFloat(0);
            this.b = list.getFloat(1);
            this.c = list.getFloat(2);
            this.d = list.getFloat(3);
        }
        return super.fromData(data, parser);
    }

    @Override
    public void update(ParticleEmitter emitter, Particle particle) {
        if (particle.isDead()) {
            return;
        }
        Vector3d prevLocal = new Vector3d((Vector3dc)particle.prevPosition);
        Vector3d local = new Vector3d((Vector3dc)particle.position);
        if (!particle.relativePosition) {
            local.sub((Vector3dc)emitter.lastGlobal);
            prevLocal.sub((Vector3dc)emitter.lastGlobal);
        }
        double prev = (double)this.a * prevLocal.x + (double)this.b * prevLocal.y + (double)this.c * prevLocal.z + (double)this.d;
        double now = (double)this.a * local.x + (double)this.b * local.y + (double)this.c * local.z + (double)this.d;
        if (prev > 0.0 && now < 0.0 || prev < 0.0 && now > 0.0) {
            particle.setDead();
        }
    }

    @Override
    public int getSortingIndex() {
        return 100;
    }
}

