/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.particles.components.meta;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.math.molang.MolangException;
import mchorse.bbs_mod.math.molang.MolangParser;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.particles.components.IComponentEmitterInitialize;
import mchorse.bbs_mod.particles.components.IComponentEmitterUpdate;
import mchorse.bbs_mod.particles.components.ParticleComponentBase;
import mchorse.bbs_mod.particles.emitter.ParticleEmitter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ParticleComponentInitialization
extends ParticleComponentBase
implements IComponentEmitterInitialize,
IComponentEmitterUpdate {
    public MolangExpression creation = MolangParser.ZERO;
    public MolangExpression update = MolangParser.ZERO;

    @Override
    protected void toData(MapType data) {
        if (!MolangExpression.isZero(this.creation)) {
            data.put("creation_expression", this.creation.toData());
        }
        if (!MolangExpression.isZero(this.update)) {
            data.put("per_update_expression", this.update.toData());
        }
    }

    @Override
    public ParticleComponentBase fromData(BaseType data, MolangParser parser) throws MolangException {
        if (!data.isMap()) {
            return super.fromData(data, parser);
        }
        MapType element = data.asMap();
        if (element.has("creation_expression")) {
            this.creation = parser.parseGlobalData(element.get("creation_expression"));
        }
        if (element.has("per_update_expression")) {
            this.update = parser.parseGlobalData(element.get("per_update_expression"));
        }
        return super.fromData(element, parser);
    }

    @Override
    public void apply(ParticleEmitter emitter) {
        this.creation.get();
        emitter.replaceVariables();
    }

    @Override
    public void update(ParticleEmitter emitter) {
        this.update.get();
        emitter.replaceVariables();
    }
}

