/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips;

import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.clips.modifiers.LookClip;
import mchorse.bbs_mod.camera.data.Point;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.clips.UIClip;
import mchorse.bbs_mod.ui.film.clips.modules.UIPointModule;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIAnchorKeyframeFactory;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.RayTracing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class UILookClip
extends UIClip<LookClip> {
    public UIButton selector;
    public UIToggle relative;
    public UIPointModule offset;
    public UIToggle atBlock;
    public UIPointModule block;
    public UIToggle forward;
    public UIElement row;

    public UILookClip(LookClip clip, IUIClipsDelegate editor) {
        super(clip, editor);
    }

    @Override
    protected void registerUI() {
        super.registerUI();
        this.selector = new UIButton(UIKeys.CAMERA_PANELS_TARGET_TITLE, b -> {
            UIFilmPanel panel = this.getParent(UIFilmPanel.class);
            if (panel != null) {
                UIAnchorKeyframeFactory.displayActors(this.getContext(), panel.getController().getEntities(), (Integer)((LookClip)this.clip).selector.get(), i -> ((LookClip)this.clip).selector.set(i));
            }
        });
        this.selector.tooltip(UIKeys.CAMERA_PANELS_TARGET_TOOLTIP);
        this.block = new UIPointModule(this.editor, UIKeys.CAMERA_PANELS_BLOCK).contextMenu();
        this.block.context((ContextMenuManager menu) -> {
            menu.action(Icons.VISIBLE, UIKeys.CAMERA_PANELS_CONTEXT_LOOK_COORDS, () -> this.rayTrace(false));
            menu.action(Icons.BLOCK, UIKeys.CAMERA_PANELS_CONTEXT_LOOK_BLOCK, () -> this.rayTrace(true));
        });
        this.offset = new UIPointModule(this.editor, UIKeys.CAMERA_PANELS_OFFSET).contextMenu();
        this.relative = new UIToggle(UIKeys.CAMERA_PANELS_RELATIVE, false, b -> ((LookClip)this.clip).relative.set(b.getValue()));
        this.relative.tooltip(UIKeys.CAMERA_PANELS_RELATIVE_TOOLTIP);
        this.atBlock = new UIToggle(UIKeys.CAMERA_PANELS_AT_BLOCK, false, b -> ((LookClip)this.clip).atBlock.set(b.getValue()));
        this.forward = new UIToggle(UIKeys.CAMERA_PANELS_FORWARD, false, b -> ((LookClip)this.clip).forward.set(b.getValue()));
        this.forward.tooltip(UIKeys.CAMERA_PANELS_FORWARD_TOOLTIP);
    }

    @Override
    protected void registerPanels() {
        super.registerPanels();
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.CAMERA_PANELS_TARGET), this.selector).marginTop(12));
        this.panels.add((IUIElement)this.relative);
        this.panels.add((IUIElement)this.offset.marginTop(6));
        this.panels.add((IUIElement)this.atBlock.marginTop(6));
        this.panels.add((IUIElement)this.block.marginTop(6));
        this.panels.add((IUIElement)this.forward);
    }

    @Override
    public void fillData() {
        super.fillData();
        this.block.fill(((LookClip)this.clip).block);
        this.offset.fill(((LookClip)this.clip).offset);
        this.relative.setValue((Boolean)((LookClip)this.clip).relative.get());
        this.atBlock.setValue((Boolean)((LookClip)this.clip).atBlock.get());
        this.forward.setValue((Boolean)((LookClip)this.clip).forward.get());
    }

    private void rayTrace(boolean center) {
        class_3966 ehr;
        class_3965 bhr;
        Camera camera = this.editor.getCamera();
        class_638 world = class_310.method_1551().field_1687;
        class_239 result = RayTracing.rayTraceEntity((class_1937)world, camera, 128.0);
        if (center && result instanceof class_3965 && (bhr = (class_3965)result).method_17783() != class_239.class_240.field_1333) {
            class_2338 pos = bhr.method_17777();
            BaseValue.edit(((LookClip)this.clip).block, block -> ((Point)block.get()).set((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5));
            this.fillData();
        } else if (!center && result instanceof class_3966 && (ehr = (class_3966)result).method_17783() != class_239.class_240.field_1333) {
            class_243 vec = ehr.method_17784();
            BaseValue.edit(((LookClip)this.clip).block, block -> ((Point)block.get()).set(vec.field_1352, vec.field_1351, vec.field_1350));
            this.fillData();
        }
    }
}

