/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.panels.widgets;

import java.util.function.Consumer;
import mchorse.bbs_mod.l10n.L10n;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.utils.UILabel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.UIUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class UIPlayerInventoryPanel
extends UIOverlayPanel {
    private static final int PANEL_WIDTH = 200;
    private static final int PADDING_X = 16;
    private static final int PADDING_Y = 16;
    private static final int SECTION_GAP_Y = 16;
    private static final int TITLE_HEIGHT = 14;
    private static final int SLOT_SIZE = 18;
    private static final int SLOT_SPACING = 18;
    private static final int GRID_COLS = 9;
    private static final int SLOT_BG_EMPTY = 0x66000000;
    private static final int SLOT_BG_FILLED = 0x66333333;
    private static final int SLOT_BG_HOVER = -2007673515;
    private static final int SLOT_BORDER = -10066330;
    private static final int SLOT_HOVER_TINT = 0x33FFFFFF;
    private static final int EMPTY_BG = 0x55333333;
    private static final int EMPTY_BG_HOVER = 0x77555555;
    private final Consumer<class_1799> callback;
    private final class_1661 playerInventory;

    public UIPlayerInventoryPanel(Consumer<class_1799> callback) {
        super(L10n.lang("bbs.ui.inventory.title"));
        this.callback = callback;
        class_310 mc = class_310.method_1551();
        this.playerInventory = mc.field_1724 != null ? mc.field_1724.method_31548() : null;
        this.setupUI();
    }

    private void setupUI() {
        this.content.w(200);
        int cursorY = 16;
        UILabel emptyTitle = this.sectionTitle(L10n.lang("bbs.ui.inventory.selection").get());
        this.centerHorizontally(emptyTitle, 14, cursorY);
        this.content.add((IUIElement)emptyTitle);
        UIEmptySlot emptySlot = new UIEmptySlot();
        this.centerSlot(emptySlot, cursorY += 22);
        this.content.add((IUIElement)emptySlot);
        UILabel emptyLabel = UI.label(L10n.lang("bbs.ui.inventory.empty"));
        this.centerLabel(emptyLabel, 12, cursorY += 24);
        this.content.add((IUIElement)emptyLabel);
        cursorY += 28;
        if (this.playerInventory == null) {
            this.content.h(cursorY + 16);
            return;
        }
        UILabel hotbarTitle = this.sectionTitle(L10n.lang("bbs.ui.inventory.hotbar").get());
        this.centerHorizontally(hotbarTitle, 14, cursorY);
        this.content.add((IUIElement)hotbarTitle);
        cursorY += 22;
        int gridStartX = this.gridStartX(200, 9, 18, 18);
        cursorY = this.placeGridRow(cursorY, gridStartX, 0, 9);
        UILabel mainTitle = this.sectionTitle(L10n.lang("bbs.ui.inventory.main").get());
        this.centerHorizontally(mainTitle, 14, cursorY += 16);
        this.content.add((IUIElement)mainTitle);
        cursorY += 22;
        int startIndex = 9;
        for (int row = 0; row < 3; ++row) {
            cursorY = this.placeGridRow(cursorY, gridStartX, startIndex + row * 9, 9);
        }
        this.content.h(cursorY + 16);
    }

    private UILabel sectionTitle(String text) {
        UILabel label = UI.label(IKey.constant(text));
        label.w(200).h(14);
        return label;
    }

    private void centerHorizontally(UIElement element, int h, int y) {
        element.relative(this.content).x(0.5f, -84).y(y).w(168).h(h);
    }

    private void centerLabel(UILabel label, int h, int y) {
        label.relative(this.content).x(0.5f, -40).y(y).w(80).h(h);
    }

    private void centerSlot(UIElement slot, int y) {
        slot.relative(this.content).x(0.5f, -9).y(y).w(18).h(18);
    }

    private int gridStartX(int panelW, int cols, int spacing, int slotSize) {
        int gridWidth = cols * spacing;
        return (panelW - gridWidth) / 2 + (spacing - slotSize) / 2;
    }

    private int placeGridRow(int cursorY, int startX, int indexStart, int count) {
        for (int i = 0; i < count; ++i) {
            UIInventorySlot slot = new UIInventorySlot(indexStart + i);
            slot.relative(this.content).x(startX + i * 18).y(cursorY).w(18).h(18);
            this.content.add((IUIElement)slot);
        }
        return cursorY + 18 + 2;
    }

    @Environment(value=EnvType.CLIENT)
    private class UIEmptySlot
    extends UIElement {
        private UIEmptySlot() {
        }

        @Override
        protected boolean subMouseClicked(UIContext context) {
            if (this.area.isInside(context) && context.mouseButton == 0 && UIPlayerInventoryPanel.this.callback != null) {
                UIPlayerInventoryPanel.this.callback.accept(class_1799.field_8037);
                UIPlayerInventoryPanel.this.close();
                UIUtils.playClick();
                return true;
            }
            return super.subMouseClicked(context);
        }

        @Override
        public void render(UIContext context) {
            boolean hovered = this.area.isInside(context);
            int bg = hovered ? 0x77555555 : 0x55333333;
            context.batcher.box(this.area.x, this.area.y, this.area.ex(), this.area.ey(), bg);
            context.batcher.outline(this.area.x, this.area.y, this.area.ex(), this.area.ey(), -10066330);
            int cx = this.area.mx();
            int cy = this.area.my();
            context.batcher.box(cx - 6, cy - 1, cx + 6, cy + 1, -1);
            context.batcher.box(cx - 1, cy - 6, cx + 1, cy + 6, -1);
            super.render(context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class UIInventorySlot
    extends UIElement {
        private final int slotIndex;

        public UIInventorySlot(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        private class_1799 getStack() {
            if (UIPlayerInventoryPanel.this.playerInventory == null || this.slotIndex < 0 || this.slotIndex >= UIPlayerInventoryPanel.this.playerInventory.method_5439()) {
                return class_1799.field_8037;
            }
            return UIPlayerInventoryPanel.this.playerInventory.method_5438(this.slotIndex);
        }

        @Override
        protected boolean subMouseClicked(UIContext context) {
            class_1799 stack;
            if (this.area.isInside(context) && context.mouseButton == 0 && !(stack = this.getStack()).method_7960() && UIPlayerInventoryPanel.this.callback != null) {
                UIPlayerInventoryPanel.this.callback.accept(stack.method_7972());
                UIPlayerInventoryPanel.this.close();
                UIUtils.playClick();
                return true;
            }
            return super.subMouseClicked(context);
        }

        @Override
        public void render(UIContext context) {
            int bg;
            class_1799 stack = this.getStack();
            boolean isEmpty = stack.method_7960();
            boolean hovered = this.area.isInside(context);
            int n = bg = isEmpty ? 0x66000000 : 0x66333333;
            if (hovered && !isEmpty) {
                bg = -2007673515;
            }
            context.batcher.box(this.area.x, this.area.y, this.area.ex(), this.area.ey(), bg);
            context.batcher.outline(this.area.x, this.area.y, this.area.ex(), this.area.ey(), -10066330);
            if (!isEmpty) {
                int itemX = this.area.x + 1;
                int itemY = this.area.y + 1;
                context.batcher.getContext().method_51427(stack, itemX, itemY);
                context.batcher.getContext().method_51431(context.batcher.getFont().getRenderer(), stack, itemX, itemY);
                if (hovered) {
                    context.batcher.box(this.area.x, this.area.y, this.area.ex(), this.area.ey(), 0x33FFFFFF);
                }
            }
            super.render(context);
        }
    }
}

