/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories;

import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.context.UIInterpolationContextMenu;
import mchorse.bbs_mod.ui.framework.elements.events.UITrackpadDragEndEvent;
import mchorse.bbs_mod.ui.framework.elements.events.UITrackpadDragStartEvent;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.IAxisConverter;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIActionsConfigKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIAnchorKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIBlockStateKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIBooleanKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIColorKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIDoubleKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIFloatKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIIntegerKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIItemStackKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UILinkKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIParticleSettingsKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIPivotSettingsKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIPoseKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIShapeKeysKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIStringKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIStructureLightSettingsKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UITransformKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIVector4fKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.shapes.IKeyframeShapeRenderer;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.shapes.KeyframeShapeRenderers;
import mchorse.bbs_mod.ui.framework.tooltips.InterpolationTooltip;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.interps.Interpolation;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeShape;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class UIKeyframeFactory<T>
extends UIElement {
    private static final Map<IKeyframeFactory, IUIKeyframeFactoryFactory> FACTORIES = new HashMap<IKeyframeFactory, IUIKeyframeFactoryFactory>();
    private static final Map<IKeyframeFactory, Integer> SCROLLS = new HashMap<IKeyframeFactory, Integer>();
    public UIScrollView scroll;
    public UITrackpad tick;
    public UITrackpad duration;
    public UIIcon interp;
    public UIIcon shape;
    public UIColor color;
    protected Keyframe<T> keyframe;
    protected UIKeyframes editor;

    public static <T> void register(IKeyframeFactory<T> clazz, IUIKeyframeFactoryFactory<T> factory) {
        FACTORIES.put(clazz, factory);
    }

    public static void saveScroll(UIKeyframeFactory editor) {
        if (editor != null) {
            SCROLLS.put(editor.keyframe.getFactory(), (int)editor.scroll.scroll.getScroll());
        }
    }

    public static <T> UIKeyframeFactory createPanel(Keyframe<T> keyframe, UIKeyframes editor) {
        UIKeyframeFactory<T> uiEditor;
        IUIKeyframeFactoryFactory factory = FACTORIES.get(keyframe.getFactory());
        UIKeyframeFactory<T> uIKeyframeFactory = uiEditor = factory == null ? null : factory.create(keyframe, editor);
        if (uiEditor != null) {
            uiEditor.scroll.scroll.setScroll(SCROLLS.getOrDefault(keyframe.getFactory(), 0).intValue());
        }
        return uiEditor;
    }

    public UIKeyframeFactory(Keyframe<T> keyframe, UIKeyframes editor) {
        this.keyframe = keyframe;
        this.editor = editor;
        this.scroll = UI.scrollView(5, 10, new UIElement[0]);
        this.scroll.scroll.cancelScrolling();
        this.scroll.full(this);
        this.tick = new UITrackpad(this::setTick);
        this.tick.limit(1.4E-45f, 3.4028234663852886E38).tooltip(UIKeys.KEYFRAMES_TICK);
        this.tick.getEvents().register(UITrackpadDragStartEvent.class, e -> this.editor.cacheKeyframes());
        this.tick.getEvents().register(UITrackpadDragEndEvent.class, e -> this.editor.submitKeyframes());
        this.duration = new UITrackpad(v -> this.setDuration(v.floatValue()));
        this.duration.limit(0.0, 3.4028234663852886E38).tooltip(UIKeys.KEYFRAMES_FORCED_DURATION);
        this.interp = new UIIcon(Icons.GRAPH, b -> {
            Interpolation interp = this.keyframe.getInterpolation();
            UIInterpolationContextMenu menu = new UIInterpolationContextMenu(interp);
            this.getContext().replaceContextMenu(menu.callback(() -> this.editor.getGraph().setInterpolation(interp)));
        });
        this.interp.tooltip(new InterpolationTooltip(0.0f, 0.5f, () -> this.keyframe.getInterpolation()));
        this.interp.keys().register(Keys.KEYFRAMES_INTERP, this.interp::clickItself).category(UIKeys.KEYFRAMES_KEYS_CATEGORY);
        this.color = new UIColor(c -> {
            for (UIKeyframeSheet sheet : this.editor.getGraph().getSheets()) {
                for (Keyframe kf : sheet.selection.getSelected()) {
                    kf.setColor(new Color().set((int)c));
                }
            }
        });
        this.color.setColor(keyframe.getColor() == null ? 0 : keyframe.getColor().getRGBColor());
        this.color.noLabel().w(40).tooltip(UIKeys.KEYFRAMES_CHANGE_COLOR);
        this.color.context((ContextMenuManager menu) -> menu.action(Icons.COLOR, UIKeys.KEYFRAMES_RESET_COLOR, () -> {
            for (UIKeyframeSheet sheet : this.editor.getGraph().getSheets()) {
                for (Keyframe kf : sheet.selection.getSelected()) {
                    kf.setColor(null);
                }
            }
            this.color.setColor(0);
        }));
        this.shape = new UIIcon(Icons.SHAPES, b -> {
            KeyframeShape currentShape = keyframe.getShape() == null ? KeyframeShape.SQUARE : keyframe.getShape();
            this.getContext().replaceContextMenu(menu -> {
                for (KeyframeShape shape : KeyframeShape.values()) {
                    IKeyframeShapeRenderer shapeRenderer = KeyframeShapeRenderers.SHAPES.get((Object)shape);
                    menu.action(shapeRenderer.getIcon(), shapeRenderer.getLabel(), shape == currentShape, () -> {
                        for (UIKeyframeSheet sheet : this.editor.getGraph().getSheets()) {
                            for (Keyframe kf : sheet.selection.getSelected()) {
                                kf.setShape(shape);
                            }
                        }
                    });
                }
            });
        });
        this.shape.tooltip(UIKeys.KEYFRAMES_CHANGE_SHAPE);
        this.scroll.add((IUIElement)UI.row(this.interp, this.tick, this.duration, this.color, this.shape));
        this.add((IUIElement)this.scroll);
        IAxisConverter converter = this.editor.getConverter();
        this.tick.setValue(converter == null ? (double)keyframe.getTick() : converter.to(keyframe.getTick()));
        this.duration.setValue(converter == null ? (double)keyframe.getDuration() : converter.to(keyframe.getDuration()));
    }

    public Keyframe<T> getKeyframe() {
        return this.keyframe;
    }

    public void setTick(double tick) {
        IAxisConverter converter = this.editor.getConverter();
        float time = (float)(converter == null ? tick : converter.from(tick));
        this.editor.getGraph().setTick(time, false);
    }

    public void setDuration(float value) {
        this.editor.getGraph().setDuration(value);
    }

    public void setValue(Object value) {
        this.editor.getGraph().setValue(value, true);
    }

    public void update() {
        IAxisConverter converter = this.editor.getConverter();
        this.tick.setValue(converter == null ? (double)this.keyframe.getTick() : converter.to(this.keyframe.getTick()));
    }

    static {
        UIKeyframeFactory.register(KeyframeFactories.ANCHOR, UIAnchorKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.BOOLEAN, UIBooleanKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.COLOR, UIColorKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.FLOAT, UIFloatKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.DOUBLE, UIDoubleKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.INTEGER, UIIntegerKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.LINK, UILinkKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.POSE, UIPoseKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.STRING, UIStringKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.TRANSFORM, UITransformKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.VECTOR4F, UIVector4fKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.BLOCK_STATE, UIBlockStateKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.ITEM_STACK, UIItemStackKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.ACTIONS_CONFIG, UIActionsConfigKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.SHAPE_KEYS, UIShapeKeysKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.PARTICLE_SETTINGS, UIParticleSettingsKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.PIVOT_SETTINGS, UIPivotSettingsKeyframeFactory::new);
        UIKeyframeFactory.register(KeyframeFactories.STRUCTURE_LIGHT_SETTINGS, UIStructureLightSettingsKeyframeFactory::new);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface IUIKeyframeFactoryFactory<T> {
        public UIKeyframeFactory<T> create(Keyframe<T> var1, UIKeyframes var2);
    }
}

