/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.particles.ParticleScheme;
import mchorse.bbs_mod.particles.components.expiration.ParticleComponentKillPlane;
import mchorse.bbs_mod.particles.emitter.ParticleEmitter;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.utils.UIModelRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class UIParticleSchemeRenderer
extends UIModelRenderer {
    public ParticleEmitter emitter;
    private Vector3f vector = new Vector3f(0.0f, 0.0f, 0.0f);

    public UIParticleSchemeRenderer() {
        this.emitter = new ParticleEmitter();
    }

    public void setScheme(ParticleScheme scheme) {
        this.emitter = new ParticleEmitter();
        this.emitter.setScheme(scheme);
    }

    @Override
    protected void update() {
        super.update();
        if (this.emitter != null) {
            this.emitter.rotation.identity();
            this.emitter.update();
        }
    }

    @Override
    protected void renderUserModel(UIContext context) {
        if (this.emitter == null || this.emitter.scheme == null) {
            return;
        }
        this.emitter.setupCameraProperties(this.camera);
        this.emitter.rotation.identity();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_4587 stack = context.batcher.getContext().method_51448();
        stack.method_22903();
        stack.method_34426();
        stack.method_34425(new Matrix4f((Matrix3fc)RenderSystem.getInverseViewRotationMatrix()).invert());
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        this.emitter.render(class_290.field_1584, class_757::method_34546, stack, class_4608.field_21444, context.getTransition());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        stack.method_22909();
        ParticleComponentKillPlane plane = this.emitter.scheme.get(ParticleComponentKillPlane.class);
        if (plane.a != 0.0f || plane.b != 0.0f || plane.c != 0.0f) {
            this.renderPlane(context, plane.a, plane.b, plane.c, plane.d);
        }
    }

    private void renderPlane(UIContext context, float a, float b, float c, float d) {
        Matrix4f matrix = context.batcher.getContext().method_51448().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        float alpha = 0.5f;
        builder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        this.calculate(0.0f, 0.0f, a, b, c, d);
        builder.method_22918(matrix, this.vector.x, this.vector.y, this.vector.z).method_22915(0.0f, 1.0f, 0.0f, 0.5f).method_1344();
        this.calculate(0.0f, 1.0f, a, b, c, d);
        builder.method_22918(matrix, this.vector.x, this.vector.y, this.vector.z).method_22915(0.0f, 1.0f, 0.0f, 0.5f).method_1344();
        this.calculate(1.0f, 0.0f, a, b, c, d);
        builder.method_22918(matrix, this.vector.x, this.vector.y, this.vector.z).method_22915(0.0f, 1.0f, 0.0f, 0.5f).method_1344();
        this.calculate(1.0f, 0.0f, a, b, c, d);
        builder.method_22918(matrix, this.vector.x, this.vector.y, this.vector.z).method_22915(0.0f, 1.0f, 0.0f, 0.5f).method_1344();
        this.calculate(0.0f, 1.0f, a, b, c, d);
        builder.method_22918(matrix, this.vector.x, this.vector.y, this.vector.z).method_22915(0.0f, 1.0f, 0.0f, 0.5f).method_1344();
        this.calculate(1.0f, 1.0f, a, b, c, d);
        builder.method_22918(matrix, this.vector.x, this.vector.y, this.vector.z).method_22915(0.0f, 1.0f, 0.0f, 0.5f).method_1344();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableCull();
        class_286.method_43433((class_287.class_7433)builder.method_1326());
        RenderSystem.enableCull();
    }

    private void calculate(float i, float j, float a, float b, float c, float d) {
        float radius = 5.0f;
        if (b != 0.0f) {
            this.vector.x = -5.0f + 10.0f * i;
            this.vector.z = -5.0f + 10.0f * j;
            this.vector.y = (a * this.vector.x + c * this.vector.z + d) / -b;
        } else if (a != 0.0f) {
            this.vector.y = -5.0f + 10.0f * i;
            this.vector.z = -5.0f + 10.0f * j;
            this.vector.x = (b * this.vector.y + c * this.vector.z + d) / -a;
        } else if (c != 0.0f) {
            this.vector.x = -5.0f + 10.0f * i;
            this.vector.y = -5.0f + 10.0f * j;
            this.vector.z = (b * this.vector.y + a * this.vector.x + d) / -c;
        }
    }

    @Override
    protected void renderGrid(UIContext context) {
        super.renderGrid(context);
        if (UIBaseMenu.renderAxes && !((Boolean)BBSSettings.modelBlockGizmosEnabled.get()).booleanValue()) {
            Draw.coolerAxes(context.batcher.getContext().method_51448(), 1.0f, 0.01f, 1.01f, 0.02f);
        }
    }
}

