/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.pose;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BoneCategoriesManager {
    private static final String FILE_NAME = "bone_categories.json";
    private final Map<String, Map<String, List<String>>> cache = new HashMap<String, Map<String, List<String>>>();

    public BoneCategoriesManager() {
        this.load();
    }

    private File getFile() {
        return BBSMod.getSettingsPath(FILE_NAME);
    }

    private void load() {
        try {
            BaseType type = DataToString.read(this.getFile());
            if (type != null && type.isMap()) {
                MapType map = (MapType)type;
                for (String group : map.keys()) {
                    LinkedHashMap categories = new LinkedHashMap();
                    MapType cats = map.getMap(group);
                    if (cats != null) {
                        for (String catName : cats.keys()) {
                            ArrayList<String> bones = new ArrayList<String>();
                            ListType list = cats.getList(catName);
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    bones.add(list.getString(i));
                                }
                            }
                            categories.put(catName, bones);
                        }
                    }
                    this.cache.put(group, categories);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void save() {
        MapType root = new MapType();
        for (Map.Entry<String, Map<String, List<String>>> entry : this.cache.entrySet()) {
            MapType cats = new MapType();
            for (Map.Entry<String, List<String>> cat : entry.getValue().entrySet()) {
                ListType bones = new ListType();
                for (String b : cat.getValue()) {
                    bones.addString(b);
                }
                cats.put(cat.getKey(), bones);
            }
            root.put(entry.getKey(), cats);
        }
        DataToString.writeSilently(this.getFile(), root, true);
    }

    public List<String> getCategories(String groupKey) {
        return new ArrayList<String>(this.cache.computeIfAbsent(groupKey, g -> new LinkedHashMap()).keySet());
    }

    public List<String> getBones(String groupKey, String category) {
        Map cats = this.cache.computeIfAbsent(groupKey, g -> new LinkedHashMap());
        return new ArrayList<String>(cats.getOrDefault(category, Collections.emptyList()));
    }

    public void addCategory(String groupKey, String category) {
        Map cats = this.cache.computeIfAbsent(groupKey, g -> new LinkedHashMap());
        cats.putIfAbsent(category, new ArrayList());
        this.save();
    }

    public void removeCategory(String groupKey, String category) {
        Map cats = this.cache.computeIfAbsent(groupKey, g -> new LinkedHashMap());
        cats.remove(category);
        this.save();
    }

    public void renameCategory(String groupKey, String oldName, String newName) {
        if (Objects.equals(oldName, newName)) {
            return;
        }
        Map cats = this.cache.computeIfAbsent(groupKey, g -> new LinkedHashMap());
        ArrayList bones = (ArrayList)cats.remove(oldName);
        if (bones == null) {
            bones = new ArrayList();
        }
        cats.put(newName, bones);
        this.save();
    }

    public void addBone(String groupKey, String category, String bone) {
        Map cats = this.cache.computeIfAbsent(groupKey, g -> new LinkedHashMap());
        List bones = cats.computeIfAbsent(category, c -> new ArrayList());
        if (!bones.contains(bone)) {
            bones.add(bone);
            this.save();
        }
    }

    public void removeBone(String groupKey, String category, String bone) {
        Map cats = this.cache.computeIfAbsent(groupKey, g -> new LinkedHashMap());
        List bones = (List)cats.get(category);
        if (bones != null && bones.remove(bone)) {
            this.save();
        }
    }
}

