/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.keyframes.factories;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.IntType;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;

public class ColorKeyframeFactory
implements IKeyframeFactory<Color> {
    private Color i = new Color();

    @Override
    public Color fromData(BaseType data) {
        if (!data.isNumeric()) {
            return new Color();
        }
        return Color.rgba(data.asNumeric().intValue());
    }

    @Override
    public BaseType toData(Color value) {
        return new IntType(value.getARGBColor());
    }

    @Override
    public Color createEmpty() {
        return new Color().set(-1);
    }

    @Override
    public Color copy(Color value) {
        return value.copy();
    }

    @Override
    public Color interpolate(Color preA, Color a, Color b, Color postB, IInterp interpolation, float x) {
        this.i.r = MathUtils.clamp((float)interpolation.interpolate(IInterp.context.set(preA.r, a.r, b.r, postB.r, x)), 0.0f, 1.0f);
        this.i.g = MathUtils.clamp((float)interpolation.interpolate(IInterp.context.set(preA.g, a.g, b.g, postB.g, x)), 0.0f, 1.0f);
        this.i.b = MathUtils.clamp((float)interpolation.interpolate(IInterp.context.set(preA.b, a.b, b.b, postB.b, x)), 0.0f, 1.0f);
        this.i.a = MathUtils.clamp((float)interpolation.interpolate(IInterp.context.set(preA.a, a.a, b.a, postB.a, x)), 0.0f, 1.0f);
        return this.i;
    }
}

