/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.audio;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.audio.ColorCode;
import mchorse.bbs_mod.audio.Wave;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.resources.Pixels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class Waveform {
    public float[] average;
    public float[] maximum;
    private List<Texture> sprites = new ArrayList<Texture>();
    private int w;
    private int h;
    private int pixelsPerSecond;
    private float duration;

    public void generate(Wave data, List<ColorCode> colorCodes, int pixelsPerSecond, int height) {
        if (data.getBytesPerSample() != 2) {
            throw new IllegalStateException("Waveform generation doesn't support non 16-bit audio data!");
        }
        this.populate(data, pixelsPerSecond, height);
        this.render(colorCodes, data.getCues());
    }

    public void render(List<ColorCode> colorCodes, float[] cues) {
        this.delete();
        int maxTextureSize = GL11.glGetInteger((int)3379) / 2;
        int count = (int)Math.ceil((double)this.w / (double)maxTextureSize);
        int offset = 0;
        float time = 0.0f;
        ColorCode code = this.getColorCode(colorCodes, time);
        Color tmp = new Color();
        for (int t = 0; t < count; ++t) {
            Texture texture = new Texture();
            int width = Math.min(this.w - offset, maxTextureSize);
            Pixels pixels = Pixels.fromSize(width, this.h);
            int i = offset;
            int j = 0;
            int c = Math.min(offset + width, this.average.length);
            while (i < c) {
                float average = this.average[i];
                float maximum = this.maximum[i];
                int maxHeight = (int)(maximum * (float)this.h);
                int avgHeight = (int)(average * (float)(this.h - 1)) + 1;
                int color = -1;
                boolean background = false;
                if (code != null && !code.isInside(time)) {
                    code = null;
                }
                if (code == null) {
                    code = this.getColorCode(colorCodes, time);
                }
                if (code != null) {
                    color = Colors.setA(code.color, 1.0f);
                    background = true;
                }
                if (this.hasCue(cues, time)) {
                    pixels.drawRect(j, 0, 1, this.h, -1157592833);
                }
                if (avgHeight > 0) {
                    if (background) {
                        tmp.set(color);
                        for (int k = 0; k < this.h; ++k) {
                            tmp.a = 0.125f + 0.25f * ((float)k / (float)this.h);
                            pixels.setColor(j, k, tmp);
                        }
                    }
                    pixels.drawRect(j, this.h / 2 - maxHeight / 2, 1, maxHeight, color);
                    pixels.drawRect(j, this.h / 2 - avgHeight / 2, 1, avgHeight, Colors.mulRGB(color, 0.8f));
                }
                time += 1.0f / (float)this.pixelsPerSecond;
                ++i;
                ++j;
            }
            pixels.rewindBuffer();
            texture.bind();
            texture.uploadTexture(pixels);
            texture.setFilter(9728);
            texture.setParameter(10242, 33069);
            texture.unbind();
            this.sprites.add(texture);
            offset += maxTextureSize;
        }
    }

    private boolean hasCue(float[] cues, float time) {
        if (cues == null) {
            return false;
        }
        for (float cue : cues) {
            if (!(time >= cue) || !(time - cue < 1.5f / (float)this.pixelsPerSecond)) continue;
            return true;
        }
        return false;
    }

    private ColorCode getColorCode(List<ColorCode> colorCodes, float time) {
        if (colorCodes == null) {
            return null;
        }
        for (ColorCode colorCode : colorCodes) {
            if (!colorCode.isInside(time)) continue;
            return colorCode;
        }
        return null;
    }

    public void populate(Wave data, int pixelsPerSecond, int height) {
        this.pixelsPerSecond = pixelsPerSecond;
        this.w = (int)(data.getDuration() * (float)pixelsPerSecond);
        this.h = height;
        this.average = new float[this.w];
        this.maximum = new float[this.w];
        int region = data.getScanRegion(pixelsPerSecond);
        for (int i = 0; i < this.w; ++i) {
            int offset = i * region;
            int count = 0;
            float average = 0.0f;
            float maximum = 0.0f;
            for (int j = 0; j < region && offset + j + 1 < data.data.length; j += 2 * data.numChannels) {
                byte a = data.data[offset + j];
                byte b = data.data[offset + j + 1];
                float sample = a + (b << 8);
                maximum = Math.max(maximum, Math.abs(sample));
                average += Math.abs(sample);
                ++count;
            }
            average /= (float)count;
            this.average[i] = average /= 32767.0f;
            this.maximum[i] = maximum /= 32767.0f;
        }
        this.duration = data.getDuration();
    }

    public void delete() {
        for (Texture sprite : this.sprites) {
            sprite.delete();
        }
        this.sprites.clear();
    }

    public boolean isCreated() {
        return !this.sprites.isEmpty();
    }

    public int getPixelsPerSecond() {
        return this.pixelsPerSecond;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public float getDuration() {
        return this.duration;
    }

    public List<Texture> getSprites() {
        return this.sprites;
    }

    public void render(Batcher2D batcher, int color, int x, int y, int w, int h, float startTime, float endTime) {
        float pixelsPerSecond = (float)w / (endTime - startTime);
        float xOffset = (float)x - startTime * pixelsPerSecond;
        float timeOffset = 0.0f;
        batcher.clip(x, y, w, h, 0, 0);
        for (Texture sprite : this.sprites) {
            float duration = (float)sprite.width / (float)this.pixelsPerSecond;
            float timeEnd = timeOffset + duration;
            float spriteW = duration * pixelsPerSecond;
            float u1 = 0.0f;
            float u2 = sprite.width;
            if (timeOffset >= endTime) break;
            batcher.texturedBox(sprite, color, xOffset, (float)y, spriteW, (float)h, u1, 0.0f, u2, (float)sprite.height, sprite.width, sprite.height);
            timeOffset = timeEnd;
            xOffset += spriteW;
        }
        batcher.unclip(0, 0);
    }
}

