/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.model.loaders;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mchorse.bbs_mod.cubic.CubicLoader;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.cubic.data.animation.Animation;
import mchorse.bbs_mod.cubic.data.animation.Animations;
import mchorse.bbs_mod.cubic.data.model.Model;
import mchorse.bbs_mod.cubic.data.model.ModelData;
import mchorse.bbs_mod.cubic.data.model.ModelGroup;
import mchorse.bbs_mod.cubic.data.model.ModelMesh;
import mchorse.bbs_mod.cubic.model.ModelManager;
import mchorse.bbs_mod.cubic.model.loaders.IModelLoader;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.obj.MeshOBJ;
import mchorse.bbs_mod.obj.MeshesOBJ;
import mchorse.bbs_mod.obj.OBJMaterial;
import mchorse.bbs_mod.obj.OBJParser;
import mchorse.bbs_mod.resources.AssetProvider;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.utils.BoxPacker;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.IOUtils;
import mchorse.bbs_mod.utils.PNGEncoder;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.resources.Pixels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class CubicModelLoader
implements IModelLoader {
    @Override
    public ModelInstance load(String id, ModelManager models, Link model, Collection<Link> links, MapType config) {
        Link modelBBS = IModelLoader.getLink(model.combine("model.bbs.json"), links, ".bbs.json");
        Link modelTexture = IModelLoader.getLink(model.combine("model.png"), links, ".png");
        ModelInstance newModel = new ModelInstance(id, null, new Animations(models.parser), modelTexture);
        Map<String, MeshesOBJ> compile = this.tryLoadingOBJMeshes(models, model, IModelLoader.getLinks(links, ".obj"));
        Model theModel = null;
        try (InputStream stream = models.provider.getAsset(modelBBS);){
            Iterator loader = new CubicLoader();
            CubicLoader.LoadingInfo loadingInfo = ((CubicLoader)((Object)loader)).load(models.parser, stream, modelBBS.path);
            if (loadingInfo.model != null) {
                theModel = loadingInfo.model;
            }
            if (loadingInfo.animations != null) {
                for (Animation animation : loadingInfo.animations.getAll()) {
                    newModel.animations.add(animation);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load BBS file: " + String.valueOf(modelBBS));
        }
        if (!compile.isEmpty()) {
            HashSet<String> declined = new HashSet<String>();
            if (theModel == null) {
                theModel = new Model(models.parser);
                theModel.textureWidth = 1;
                theModel.textureHeight = 1;
            }
            this.tryMakingFlatMaterials(models.provider, links, model, newModel, theModel, compile);
            for (Map.Entry entry : compile.entrySet()) {
                MeshesOBJ value = (MeshesOBJ)entry.getValue();
                ModelGroup group = theModel.getGroup((String)entry.getKey());
                if (group == null) {
                    group = new ModelGroup((String)entry.getKey());
                    theModel.topGroups.add(group);
                }
                for (MeshOBJ mesh : value.meshes) {
                    ModelMesh modelMesh = new ModelMesh();
                    modelMesh.baseData.fill(mesh, theModel.textureWidth, theModel.textureHeight);
                    group.meshes.add(modelMesh);
                }
                this.fillShapes(declined, value.shapes, group, theModel.textureWidth, theModel.textureHeight);
            }
            theModel.initialize();
            for (String string : declined) {
                System.out.println("Model \"" + String.valueOf(model) + "\" has shape keys \"" + string + "\" that have invalid shape keys (triangle count doesn't match)!");
            }
        }
        if (theModel == null || theModel.topGroups.isEmpty()) {
            return null;
        }
        newModel.model = theModel;
        for (Animation animation : this.tryLoadingExternalAnimations(models, config).getAll()) {
            newModel.animations.add(animation);
        }
        newModel.applyConfig(config);
        return newModel;
    }

    private void tryMakingFlatMaterials(AssetProvider provider, Collection<Link> links, Link model, ModelInstance newModel, Model theModel, Map<String, MeshesOBJ> compile) {
        Link paletteLink = model.combine("baked.png");
        File paletteFile = provider.getFile(paletteLink);
        HashMap<OBJMaterial, Pair<Pixels, Area>> pixels = new HashMap<OBJMaterial, Pair<Pixels, Area>>();
        ArrayList<OBJMaterial> materials = new ArrayList<OBJMaterial>();
        for (MeshesOBJ value : compile.values()) {
            for (MeshOBJ mesh : value.meshes) {
                if (mesh.material == null || materials.contains(mesh.material)) continue;
                materials.add(mesh.material);
            }
        }
        if (materials.isEmpty() || ((OBJMaterial)materials.get((int)0)).useTexture) {
            return;
        }
        Link bakedOffsets = model.combine("baked.json");
        if (paletteFile.exists()) {
            newModel.texture = paletteLink;
            try (InputStream stream22 = provider.getAsset(bakedOffsets);){
                MapType mapType = DataToString.mapFromString(IOUtils.readText(stream22));
                ListType size = mapType.getList("size");
                MapType offsets = mapType.getMap("offsets");
                for (OBJMaterial material : materials) {
                    ListType list = offsets.getList(material.name);
                    if (list.size() < 4) continue;
                    pixels.putIfAbsent(material, new Pair<Object, Area>(null, new Area(list.getInt(0), list.getInt(1), list.getInt(2), list.getInt(3))));
                }
                this.applyBakedOffsets(compile, pixels, new Vector2i(size.getInt(0), size.getInt(1)));
            }
            catch (Exception stream22) {
                // empty catch block
            }
            return;
        }
        for (OBJMaterial oBJMaterial : materials) {
            if (oBJMaterial.useTexture) {
                List<Link> materialTextures = IModelLoader.getLinks(links, (Link a) -> {
                    String string = a.toString();
                    return string.startsWith(model.toString()) && string.contains("/" + material.name + "/") && string.endsWith(".png");
                });
                Link link = materialTextures.get(0);
                try (InputStream stream = provider.getAsset(link);){
                    Pixels newPixels = Pixels.fromPNGStream(stream);
                    Area area = new Area();
                    pixels.put(oBJMaterial, new Pair<Pixels, Area>(newPixels, area));
                    area.setSize(newPixels.width, newPixels.height);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            Pixels newPixels = Pixels.fromSize(1, 1);
            Area area = new Area();
            Color set = new Color().set(oBJMaterial.r, oBJMaterial.g, oBJMaterial.b, 1.0f);
            newPixels.setColor(0, 0, set);
            pixels.put(oBJMaterial, new Pair<Pixels, Object>(newPixels, area));
            area.setSize(newPixels.width, newPixels.height);
        }
        ArrayList<Area> boxes = new ArrayList<Area>();
        for (Pair value : pixels.values()) {
            boxes.add((Area)value.b);
        }
        Vector2i vector2i = BoxPacker.pack(boxes, 0);
        Pixels output = Pixels.fromSize(vector2i.x, vector2i.y);
        for (Pair value : pixels.values()) {
            output.draw((Pixels)value.a, ((Area)value.b).x, ((Area)value.b).y);
            ((Pixels)value.a).delete();
        }
        try {
            PNGEncoder.writeToFile(output, paletteFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        output.delete();
        this.applyBakedOffsets(compile, pixels, vector2i);
        MapType data = new MapType();
        ListType dSize = new ListType();
        MapType dOffsets = new MapType();
        data.put("size", dSize);
        data.put("offsets", dOffsets);
        for (Map.Entry entry : pixels.entrySet()) {
            ListType dOffset = new ListType();
            dOffset.addInt(((Area)((Pair)entry.getValue()).b).x);
            dOffset.addInt(((Area)((Pair)entry.getValue()).b).y);
            dOffset.addInt(((Area)((Pair)entry.getValue()).b).w);
            dOffset.addInt(((Area)((Pair)entry.getValue()).b).h);
            dOffsets.put(((OBJMaterial)entry.getKey()).name, dOffset);
        }
        dSize.addInt(vector2i.x);
        dSize.addInt(vector2i.y);
        DataToString.writeSilently(provider.getFile(bakedOffsets), data, true);
        newModel.texture = paletteLink;
        theModel.textureWidth = 1;
        theModel.textureHeight = 1;
    }

    private void applyBakedOffsets(Map<String, MeshesOBJ> compile, Map<OBJMaterial, Pair<Pixels, Area>> pixels, Vector2i size) {
        for (MeshesOBJ value : compile.values()) {
            for (MeshOBJ mesh : value.meshes) {
                Pair<Pixels, Area> pair = pixels.get(mesh.material);
                int c = mesh.triangles;
                for (int i = 0; i < c; ++i) {
                    float u = mesh.texData[i * 2];
                    float v = mesh.texData[i * 2 + 1];
                    u = (u * (float)((Area)pair.b).w + (float)((Area)pair.b).x) / (float)size.x;
                    v = (v * (float)((Area)pair.b).h + (float)((Area)pair.b).y) / (float)size.y;
                    mesh.texData[i * 2] = u;
                    mesh.texData[i * 2 + 1] = v;
                }
            }
        }
    }

    private Map<String, MeshesOBJ> tryLoadingOBJMeshes(ModelManager models, Link model, List<Link> modelsOBJ) {
        HashMap<String, MeshesOBJ> compile = new HashMap<String, MeshesOBJ>();
        for (Link link : modelsOBJ) {
            String path = link.path.substring(model.path.length() + 1);
            if (path.contains("/")) continue;
            Link mtl = new Link(link.source, StringUtils.removeExtension(link.path) + ".mtl");
            try (InputStream stream = models.provider.getAsset(link);){
                InputStream mtlStream = null;
                try {
                    mtlStream = models.provider.getAsset(mtl);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OBJParser parser = new OBJParser(stream, mtlStream);
                parser.read();
                compile.putAll(parser.compile());
                if (mtlStream == null) break;
                mtlStream.close();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Link link : modelsOBJ) {
            if (!link.path.contains("/shapes/")) continue;
            try {
                InputStream stream = models.provider.getAsset(link);
                try {
                    OBJParser parser = new OBJParser(stream, null);
                    String name = StringUtils.fileName(StringUtils.removeExtension(link.path));
                    parser.read();
                    Map<String, MeshesOBJ> compiled = parser.compile();
                    for (Map.Entry<String, MeshesOBJ> entry : compiled.entrySet()) {
                        MeshesOBJ meshesOBJ = (MeshesOBJ)compile.get(entry.getKey());
                        if (meshesOBJ == null) {
                            compile.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        meshesOBJ.mergeShape(name, entry.getValue());
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return compile;
    }

    private void fillShapes(Set<String> declined, Map<String, List<MeshOBJ>> shapes, ModelGroup group, int tw, int th) {
        if (shapes == null) {
            return;
        }
        for (Map.Entry<String, List<MeshOBJ>> shapeEntry : shapes.entrySet()) {
            int i = 0;
            for (MeshOBJ mesh : shapeEntry.getValue()) {
                ModelMesh modelMesh = CollectionUtils.getSafe(group.meshes, i);
                ModelData data = new ModelData();
                data.fill(mesh, tw, th);
                if (data.vertices.size() == modelMesh.baseData.vertices.size() && data.normals.size() == modelMesh.baseData.normals.size() && data.uvs.size() == modelMesh.baseData.uvs.size()) {
                    modelMesh.data.put(shapeEntry.getKey(), data);
                } else {
                    declined.add(shapeEntry.getKey());
                }
                ++i;
            }
        }
    }

    private Animations tryLoadingExternalAnimations(ModelManager models, MapType config) {
        Animations animations = new Animations(models.parser);
        if (config == null) {
            return animations;
        }
        for (BaseType type : config.getList("animations")) {
            if (!type.isString()) continue;
            Link animationFile = Link.create(type.asString());
            try {
                InputStream asset = models.provider.getAsset(animationFile);
                try {
                    CubicLoader loader = new CubicLoader();
                    CubicLoader.LoadingInfo info = loader.load(models.parser, asset, type.asString());
                    if (info.animations == null) continue;
                    for (Animation animation : info.animations.getAll()) {
                        animations.add(animation);
                    }
                }
                finally {
                    if (asset == null) continue;
                    asset.close();
                }
            }
            catch (FileNotFoundException e) {
                return new Animations(models.parser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return animations;
    }
}

