/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.render;

import mchorse.bbs_mod.cubic.data.model.Model;
import mchorse.bbs_mod.cubic.data.model.ModelGroup;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public interface ICubicRenderer {
    public static void translateGroup(class_4587 stack, ModelGroup group) {
        Vector3f translate = group.current.translate;
        Vector3f pivot = group.current.pivot;
        stack.method_46416(-(translate.x - pivot.x) / 16.0f, (translate.y - pivot.y) / 16.0f, (translate.z - pivot.z) / 16.0f);
    }

    public static void moveToGroupPivot(class_4587 stack, ModelGroup group) {
        Vector3f pivot = group.current.pivot;
        stack.method_46416(pivot.x / 16.0f, pivot.y / 16.0f, pivot.z / 16.0f);
    }

    public static void rotateGroup(class_4587 stack, ModelGroup group) {
        if (group.current.rotate.z != 0.0f) {
            stack.method_22907(class_7833.field_40718.rotation(MathUtils.toRad(group.current.rotate.z)));
        }
        if (group.current.rotate.y != 0.0f) {
            stack.method_22907(class_7833.field_40716.rotation(MathUtils.toRad(group.current.rotate.y)));
        }
        if (group.current.rotate.x != 0.0f) {
            stack.method_22907(class_7833.field_40714.rotation(MathUtils.toRad(group.current.rotate.x)));
        }
        if (group.current.rotate2.z != 0.0f) {
            stack.method_22907(class_7833.field_40718.rotation(MathUtils.toRad(group.current.rotate2.z)));
        }
        if (group.current.rotate2.y != 0.0f) {
            stack.method_22907(class_7833.field_40716.rotation(MathUtils.toRad(group.current.rotate2.y)));
        }
        if (group.current.rotate2.x != 0.0f) {
            stack.method_22907(class_7833.field_40714.rotation(MathUtils.toRad(group.current.rotate2.x)));
        }
    }

    public static void scaleGroup(class_4587 stack, ModelGroup group) {
        Vector3f scale = group.current.scale;
        MatrixStackUtils.scaleStack(stack, scale.x, scale.y, scale.z);
    }

    public static void moveBackFromGroupPivot(class_4587 stack, ModelGroup group) {
        Vector3f pivot = group.current.pivot;
        stack.method_46416(-pivot.x / 16.0f, -pivot.y / 16.0f, -pivot.z / 16.0f);
    }

    default public void applyGroupTransformations(class_4587 stack, ModelGroup group) {
        ICubicRenderer.translateGroup(stack, group);
        ICubicRenderer.moveToGroupPivot(stack, group);
        ICubicRenderer.rotateGroup(stack, group);
        ICubicRenderer.scaleGroup(stack, group);
        ICubicRenderer.moveBackFromGroupPivot(stack, group);
    }

    public boolean renderGroup(class_287 var1, class_4587 var2, ModelGroup var3, Model var4);
}

