/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.data.types;

import java.io.IOException;
import mchorse.bbs_mod.data.DataStorageContext;
import mchorse.bbs_mod.data.types.ByteArrayType;
import mchorse.bbs_mod.data.types.ByteType;
import mchorse.bbs_mod.data.types.DoubleType;
import mchorse.bbs_mod.data.types.FloatType;
import mchorse.bbs_mod.data.types.IntArrayType;
import mchorse.bbs_mod.data.types.IntType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.LongType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.data.types.NumericType;
import mchorse.bbs_mod.data.types.ShortArrayType;
import mchorse.bbs_mod.data.types.ShortType;
import mchorse.bbs_mod.data.types.StringType;

public abstract class BaseType {
    public static final byte TYPE_MAP = 0;
    public static final byte TYPE_LIST = 1;
    public static final byte TYPE_STRING = 2;
    public static final byte TYPE_BYTE = 3;
    public static final byte TYPE_SHORT = 4;
    public static final byte TYPE_INT = 5;
    public static final byte TYPE_FLOAT = 6;
    public static final byte TYPE_LONG = 7;
    public static final byte TYPE_DOUBLE = 8;
    public static final byte TYPE_BYTE_ARRAY = 9;
    public static final byte TYPE_SHORT_ARRAY = 10;
    public static final byte TYPE_INT_ARRAY = 11;

    public static BaseType fromData(DataStorageContext context) throws IOException {
        byte type = context.in.readByte();
        BaseType output = null;
        if (type == 0) {
            output = new MapType();
        } else if (type == 1) {
            output = new ListType();
        } else if (type == 2) {
            output = new StringType();
        } else if (type == 3) {
            output = new ByteType();
        } else if (type == 4) {
            output = new ShortType();
        } else if (type == 5) {
            output = new IntType();
        } else if (type == 6) {
            output = new FloatType();
        } else if (type == 7) {
            output = new LongType();
        } else if (type == 8) {
            output = new DoubleType();
        } else if (type == 9) {
            output = new ByteArrayType();
        } else if (type == 10) {
            output = new ShortArrayType();
        } else if (type == 11) {
            output = new IntArrayType();
        }
        if (output != null) {
            output.read(context);
            return output;
        }
        throw new IllegalStateException("Data type " + type + " doesn't exist!");
    }

    public static void toData(DataStorageContext context, BaseType type) throws IOException {
        context.out.writeByte(type.getTypeId());
        type.write(context);
    }

    public static boolean isMap(BaseType data) {
        return BaseType.is(data, (byte)0);
    }

    public static boolean isList(BaseType data) {
        return BaseType.is(data, (byte)1);
    }

    public static boolean isString(BaseType data) {
        return BaseType.is(data, (byte)2);
    }

    public static boolean isNumeric(BaseType data) {
        return data instanceof NumericType;
    }

    public static boolean isPrimitive(BaseType data) {
        return BaseType.isString(data) || BaseType.isNumeric(data);
    }

    public static boolean is(BaseType data, byte type) {
        return data != null && data.getTypeId() == type;
    }

    public void traverseKeys(DataStorageContext context) {
    }

    public boolean isMap() {
        return this instanceof MapType;
    }

    public boolean isList() {
        return this instanceof ListType;
    }

    public boolean isString() {
        return this instanceof StringType;
    }

    public boolean isNumeric() {
        return this instanceof NumericType;
    }

    public MapType asMap() {
        return (MapType)this;
    }

    public ListType asList() {
        return (ListType)this;
    }

    public String asString() {
        return ((StringType)this).value;
    }

    public NumericType asNumeric() {
        return (NumericType)this;
    }

    public abstract byte getTypeId();

    public abstract BaseType copy();

    public abstract void read(DataStorageContext var1) throws IOException;

    public abstract void write(DataStorageContext var1) throws IOException;
}

