/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormArchitect;
import mchorse.bbs_mod.forms.forms.BodyPart;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.states.AnimationState;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.base.BaseValueBasic;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;

public class FormUtils {
    public static final String PATH_SEPARATOR = "/";
    private static final List<String> path = new ArrayList<String>();

    public static Form fromData(BaseType data) {
        if (data instanceof MapType) {
            MapType map = (MapType)data;
            return FormUtils.fromData(map);
        }
        return null;
    }

    public static Form fromData(MapType data) {
        try {
            return data == null ? null : (Form)BBSMod.getForms().fromData(data);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static MapType toData(Form form) {
        return form == null ? null : BBSMod.getForms().toData(form);
    }

    public static Form copy(Form form) {
        if (form != null) {
            FormArchitect forms = BBSMod.getForms();
            return (Form)forms.fromData(forms.toData(form));
        }
        return null;
    }

    public static Form getRoot(Form form) {
        while (form.getParent() != null) {
            form = form.getParentForm();
        }
        return form;
    }

    public static Form getForm(BaseValue property) {
        BaseValue baseValue = property.getParent();
        if (baseValue instanceof Form) {
            Form form = (Form)baseValue;
            return form;
        }
        return null;
    }

    public static Form getForm(Form form, String path) {
        String[] split;
        for (String s : split = path.split(PATH_SEPARATOR)) {
            try {
                int index = Integer.parseInt(s);
                BodyPart safe = (BodyPart)CollectionUtils.getSafe(form.parts.getAllTyped(), index);
                if (safe == null) break;
                form = safe.getForm();
            }
            catch (Exception e) {
                break;
            }
        }
        return form;
    }

    public static String getPath(Form form) {
        if (form.getParent() == null) {
            return "";
        }
        path.clear();
        while (form != null) {
            Form parent = form.getParentForm();
            if (parent != null) {
                int i = 0;
                for (BodyPart part : parent.parts.getAllTyped()) {
                    if (part.getForm() == form) {
                        path.add(String.valueOf(i));
                    }
                    ++i;
                }
            }
            form = parent;
        }
        Collections.reverse(path);
        return String.join((CharSequence)PATH_SEPARATOR, path);
    }

    public static String getPropertyPath(BaseValue property) {
        path.clear();
        path.add(property.getId());
        Form form = FormUtils.getForm(property);
        while (form != null) {
            Form parent = form.getParentForm();
            if (parent != null) {
                int i = 0;
                for (BodyPart part : parent.parts.getAllTyped()) {
                    if (part.getForm() == form) {
                        path.add(String.valueOf(i));
                    }
                    ++i;
                }
            }
            form = parent;
        }
        Collections.reverse(path);
        return String.join((CharSequence)PATH_SEPARATOR, path);
    }

    public static List<String> collectPropertyPaths(Form form) {
        ArrayList<String> properties = new ArrayList<String>();
        FormUtils.collectPropertyPaths(form, properties, "");
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).endsWith("/anchor")) continue;
            it.remove();
        }
        return properties;
    }

    public static void collectPropertyPaths(Form form, List<String> properties, String prefix) {
        if (form == null || !((Boolean)form.animatable.get()).booleanValue()) {
            return;
        }
        for (BaseValue property : form.getAll()) {
            if (!property.isVisible()) continue;
            properties.add(StringUtils.combinePaths(prefix, property.getId()));
        }
        List all = form.parts.getAllTyped();
        for (int i = 0; i < all.size(); ++i) {
            String newPrefix = StringUtils.combinePaths(prefix, String.valueOf(i));
            FormUtils.collectPropertyPaths(((BodyPart)all.get(i)).getForm(), properties, newPrefix);
        }
    }

    public static BaseValueBasic getProperty(Form form, String path) {
        if (form == null) {
            return null;
        }
        if (!path.contains(PATH_SEPARATOR)) {
            return form.getAllMap().get(path);
        }
        String[] segments = path.split(PATH_SEPARATOR);
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            BaseValueBasic property = form.getAllMap().get(segment);
            if (property == null) {
                try {
                    int index = Integer.parseInt(segment);
                    if (CollectionUtils.inRange(form.parts.getAll(), index)) {
                        form = ((BodyPart)form.parts.getAllTyped().get(index)).getForm();
                        if (form != null) continue;
                        return null;
                    }
                    return null;
                }
                catch (Exception exception) {}
                continue;
            }
            return property;
        }
        return null;
    }

    public static void readOldStateTriggers(Form form, MapType map) {
        if (map.has("stateTriggers") && map.getMap("stateTriggers").has("list")) {
            ListType list = map.getMap("stateTriggers").getList("list");
            for (BaseType type : list) {
                if (!type.isMap()) continue;
                MapType stateTrigger = type.asMap();
                AnimationState state = new AnimationState("");
                MapType states = stateTrigger.getMap("states");
                state.id.set(stateTrigger.getString("id"));
                state.keybind.set(stateTrigger.getInt("hotkey"));
                for (String key : states.keys()) {
                    BaseType stateData = states.get(key);
                    KeyframeChannel channel = state.properties.getOrCreate(form, key);
                    if (channel == null) continue;
                    Object o = channel.getFactory().fromData(stateData);
                    channel.insert(0.0f, o);
                }
                form.states.add(state);
            }
        }
        form.states.sync();
    }
}

