/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.client.BBSShaders;
import mchorse.bbs_mod.cubic.render.vao.IModelVAO;
import mchorse.bbs_mod.cubic.render.vao.ModelVAO;
import mchorse.bbs_mod.cubic.render.vao.ModelVAOData;
import mchorse.bbs_mod.cubic.render.vao.ModelVAORenderer;
import mchorse.bbs_mod.cubic.render.vao.StructureVAOCollector;
import mchorse.bbs_mod.forms.CustomVertexConsumerProvider;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.forms.StructureForm;
import mchorse.bbs_mod.forms.forms.utils.PivotSettings;
import mchorse.bbs_mod.forms.forms.utils.StructureLightSettings;
import mchorse.bbs_mod.forms.renderers.FormRenderType;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.forms.renderers.utils.RecolorVertexConsumer;
import mchorse.bbs_mod.forms.renderers.utils.VirtualBlockRenderView;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2372;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2541;
import net.minecraft.class_2553;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5365;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_7923;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_9799;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class StructureFormRenderer
extends FormRenderer<StructureForm> {
    private final List<BlockEntry> blocks = new ArrayList<BlockEntry>();
    private String lastFile = null;
    private class_2338 size = class_2338.field_10980;
    private class_2338 boundsMin = null;
    private class_2338 boundsMax = null;
    private IModelVAO structureVao = null;
    private boolean vaoDirty = true;
    private boolean capturingVAO = false;
    private IModelVAO structureVaoPicking = null;
    private boolean vaoPickingDirty = true;
    private boolean capturingIncludeSpecialBlocks = false;

    public StructureFormRenderer(StructureForm form) {
        super(form);
    }

    @Override
    public void renderInUI(UIContext context, int x1, int y1, int x2, int y2) {
        boolean lightsEnabled;
        context.batcher.getContext().method_51452();
        this.ensureLoaded();
        class_4587 matrices = context.batcher.getContext().method_51448();
        Matrix4f uiMatrix = ModelFormRenderer.getUIMatrix(context, x1, y1, x2, y2);
        matrices.method_22903();
        MatrixStackUtils.multiply(matrices, uiMatrix);
        RenderSystem.depthFunc((int)515);
        float cellW = x2 - x1;
        float cellH = y2 - y1;
        float baseScale = cellH / 2.5f;
        int wUnits = 1;
        int hUnits = 1;
        int dUnits = 1;
        if (this.boundsMin != null && this.boundsMax != null) {
            wUnits = Math.max(1, this.boundsMax.method_10263() - this.boundsMin.method_10263() + 1);
            hUnits = Math.max(1, this.boundsMax.method_10264() - this.boundsMin.method_10264() + 1);
            dUnits = Math.max(1, this.boundsMax.method_10260() - this.boundsMin.method_10260() + 1);
        } else {
            wUnits = Math.max(1, this.size.method_10263());
            hUnits = Math.max(1, this.size.method_10264());
            dUnits = Math.max(1, this.size.method_10260());
        }
        int maxUnits = Math.max(wUnits, Math.max(hUnits, dUnits));
        float targetPixels = Math.min(cellW, cellH) * 0.9f;
        float auto = maxUnits > 0 ? targetPixels / (baseScale * (float)maxUnits) : 1.0f;
        float finalScale = ((Float)((StructureForm)this.form).uiScale.get()).floatValue() * Math.min(1.0f, auto);
        matrices.method_22905(finalScale, finalScale, finalScale);
        matrices.method_23760().method_23762().getScale(Vectors.EMPTY_3F);
        matrices.method_23760().method_23762().scale(1.0f / Vectors.EMPTY_3F.x, -1.0f / Vectors.EMPTY_3F.y, 1.0f / Vectors.EMPTY_3F.z);
        boolean optimize = (Boolean)BBSSettings.structureOptimization.get();
        StructureLightSettings sl = (StructureLightSettings)((StructureForm)this.form).structureLight.getRuntimeValue();
        boolean bl = lightsEnabled = sl != null ? sl.enabled : (Boolean)((StructureForm)this.form).emitLight.get();
        if (lightsEnabled) {
            optimize = false;
        }
        if (!optimize) {
            boolean shaders = this.isShadersActive();
            class_4597.class_4598 consumers = shaders ? class_310.method_1551().method_22940().method_23000() : class_4597.method_22991((class_9799)new class_9799(256));
            try {
                FormRenderingContext uiContext = new FormRenderingContext().set(FormRenderType.PREVIEW, null, matrices, 240, class_4608.field_21444, 0.0f);
                this.renderStructureCulledWorld(uiContext, matrices, (class_4597)consumers, 240, class_4608.field_21444, shaders);
                if (consumers instanceof class_4597.class_4598) {
                    class_4597.class_4598 immediate = consumers;
                    immediate.method_22993();
                }
            }
            catch (Throwable uiContext) {}
        } else {
            if (this.structureVao == null || this.vaoDirty) {
                this.buildStructureVAO();
            }
            if (this.structureVao != null) {
                class_4597.class_4598 immediate;
                Color tint = (Color)((StructureForm)this.form).color.get();
                class_757 gameRenderer = class_310.method_1551().field_1773;
                gameRenderer.method_22974().method_3316();
                gameRenderer.method_22975().method_23209();
                class_5944 shader = BBSShaders.getModel();
                RenderSystem.setShader(() -> shader);
                RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                ModelVAORenderer.render(shader, this.structureVao, matrices, tint.r, tint.g, tint.b, tint.a, 240, class_4608.field_21444);
                try {
                    class_4597.class_4598 beConsumers = class_310.method_1551().method_22940().method_23000();
                    FormRenderingContext beContext = new FormRenderingContext().set(FormRenderType.PREVIEW, null, matrices, 240, class_4608.field_21444, 0.0f);
                    this.renderBlockEntitiesOnly(beContext, matrices, (class_4597)beConsumers, 240, class_4608.field_21444);
                    if (beConsumers instanceof class_4597.class_4598) {
                        class_4597.class_4598 immediate2 = beConsumers;
                        immediate2.method_22993();
                    }
                }
                catch (Throwable beConsumers) {
                    // empty catch block
                }
                try {
                    boolean shadersEnabled = BBSRendering.isIrisShadersEnabled() && BBSRendering.isRenderingWorld();
                    class_4597.class_4598 consumersTint = shadersEnabled ? class_310.method_1551().method_22940().method_23000() : class_4597.method_22991((class_9799)new class_9799(256));
                    FormRenderingContext tintContext = new FormRenderingContext().set(FormRenderType.PREVIEW, null, matrices, 240, class_4608.field_21444, 0.0f);
                    this.renderBiomeTintedBlocksVanilla(tintContext, matrices, (class_4597)consumersTint, 240, class_4608.field_21444);
                    if (consumersTint instanceof class_4597.class_4598) {
                        immediate = consumersTint;
                        immediate.method_22993();
                    }
                }
                catch (Throwable shadersEnabled) {
                    // empty catch block
                }
                try {
                    boolean shadersEnabled = BBSRendering.isIrisShadersEnabled() && BBSRendering.isRenderingWorld();
                    class_4597.class_4598 consumersAnim = shadersEnabled ? class_310.method_1551().method_22940().method_23000() : class_4597.method_22991((class_9799)new class_9799(256));
                    FormRenderingContext animContext = new FormRenderingContext().set(FormRenderType.PREVIEW, null, matrices, 240, class_4608.field_21444, 0.0f);
                    this.renderAnimatedBlocksVanilla(animContext, matrices, (class_4597)consumersAnim, 240, class_4608.field_21444);
                    if (consumersAnim instanceof class_4597.class_4598) {
                        immediate = consumersAnim;
                        immediate.method_22993();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                gameRenderer.method_22974().method_3315();
                gameRenderer.method_22975().method_23213();
                RenderSystem.disableBlend();
            }
        }
        matrices.method_22909();
        RenderSystem.depthFunc((int)519);
    }

    @Override
    protected void render3D(FormRenderingContext context) {
        this.ensureLoaded();
        context.stack.method_22903();
        boolean optimize = (Boolean)BBSSettings.structureOptimization.get();
        boolean picking = context.isPicking();
        if (optimize && (this.structureVao == null || this.vaoDirty)) {
            this.buildStructureVAO();
        }
        if (!optimize) {
            if (picking) {
                if (this.structureVaoPicking == null || this.vaoPickingDirty) {
                    this.buildStructureVAOPicking();
                }
                Color tint3D = (Color)((StructureForm)this.form).color.get();
                int light = 0;
                class_757 gameRenderer = class_310.method_1551().field_1773;
                gameRenderer.method_22974().method_3316();
                gameRenderer.method_22975().method_23209();
                this.setupTarget(context, BBSShaders.getPickerModelsProgram());
                RenderSystem.setShader(BBSShaders::getPickerModelsProgram);
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
                ModelVAORenderer.render(BBSShaders.getPickerModelsProgram(), this.structureVaoPicking, context.stack, tint3D.r, tint3D.g, tint3D.b, tint3D.a, light, context.overlay);
                gameRenderer.method_22974().method_3315();
                gameRenderer.method_22975().method_23213();
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
            } else {
                int light = context.light;
                boolean shaders = this.isShadersActive();
                class_4597.class_4598 consumers = shaders ? class_310.method_1551().method_22940().method_23000() : class_4597.method_22991((class_9799)new class_9799(256));
                class_757 gameRenderer = class_310.method_1551().field_1773;
                gameRenderer.method_22974().method_3316();
                gameRenderer.method_22975().method_23209();
                RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
                try {
                    this.renderStructureCulledWorld(context, context.stack, (class_4597)consumers, light, context.overlay, shaders);
                    if (consumers instanceof class_4597.class_4598) {
                        class_4597.class_4598 immediate = consumers;
                        immediate.method_22993();
                    }
                }
                catch (Throwable immediate) {
                    // empty catch block
                }
                gameRenderer.method_22974().method_3315();
                gameRenderer.method_22975().method_23213();
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
            }
        } else if (this.structureVao != null) {
            Color tint3D = (Color)((StructureForm)this.form).color.get();
            int light = context.isPicking() ? 0 : context.light;
            class_757 gameRenderer = class_310.method_1551().field_1773;
            gameRenderer.method_22974().method_3316();
            gameRenderer.method_22975().method_23209();
            if (context.isPicking()) {
                if (this.structureVaoPicking == null || this.vaoPickingDirty) {
                    this.buildStructureVAOPicking();
                }
                this.setupTarget(context, BBSShaders.getPickerModelsProgram());
                RenderSystem.setShader(BBSShaders::getPickerModelsProgram);
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
                ModelVAORenderer.render(BBSShaders.getPickerModelsProgram(), this.structureVaoPicking, context.stack, tint3D.r, tint3D.g, tint3D.b, tint3D.a, light, context.overlay);
            } else {
                class_5944 shader = BBSRendering.isIrisShadersEnabled() && BBSRendering.isRenderingWorld() ? class_757.method_34507() : BBSShaders.getModel();
                RenderSystem.setShader(() -> shader);
                RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                ModelVAORenderer.render(shader, this.structureVao, context.stack, tint3D.r, tint3D.g, tint3D.b, tint3D.a, light, context.overlay);
                try {
                    class_4597.class_4598 beConsumers = class_310.method_1551().method_22940().method_23000();
                    this.renderBlockEntitiesOnly(context, context.stack, (class_4597)beConsumers, light, context.overlay);
                    if (beConsumers instanceof class_4597.class_4598) {
                        class_4597.class_4598 immediate = beConsumers;
                        immediate.method_22993();
                    }
                }
                catch (Throwable beConsumers) {
                    // empty catch block
                }
                try {
                    class_4597.class_4598 tintConsumers = class_4597.method_22991((class_9799)new class_9799(256));
                    this.renderBiomeTintedBlocksVanilla(context, context.stack, (class_4597)tintConsumers, light, context.overlay);
                    tintConsumers.method_22993();
                }
                catch (Throwable tintConsumers) {
                    // empty catch block
                }
                try {
                    class_4597.class_4598 animConsumers = class_4597.method_22991((class_9799)new class_9799(256));
                    this.renderAnimatedBlocksVanilla(context, context.stack, (class_4597)animConsumers, light, context.overlay);
                    animConsumers.method_22993();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            gameRenderer.method_22974().method_3315();
            gameRenderer.method_22975().method_23213();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
        }
        CustomVertexConsumerProvider.clearRunnables();
        context.stack.method_22909();
    }

    private void renderStructure(class_4587 stack, CustomVertexConsumerProvider consumers, int light, int overlay) {
        float cy;
        float cz;
        float cx;
        if (this.boundsMin != null && this.boundsMax != null) {
            cx = (float)(this.boundsMin.method_10263() + this.boundsMax.method_10263()) / 2.0f;
            cz = (float)(this.boundsMin.method_10260() + this.boundsMax.method_10260()) / 2.0f;
            cy = this.boundsMin.method_10264();
        } else {
            cx = (float)this.size.method_10263() / 2.0f;
            cy = 0.0f;
            cz = (float)this.size.method_10260() / 2.0f;
        }
        float parityXAuto = 0.0f;
        float parityZAuto = 0.0f;
        if (this.boundsMin != null && this.boundsMax != null) {
            int widthX = this.boundsMax.method_10263() - this.boundsMin.method_10263() + 1;
            int widthZ = this.boundsMax.method_10260() - this.boundsMin.method_10260() + 1;
            parityXAuto = widthX % 2 == 1 ? -0.5f : 0.0f;
            parityZAuto = widthZ % 2 == 1 ? -0.5f : 0.0f;
        }
        float pivotX = cx - parityXAuto;
        float pivotY = cy;
        float pivotZ = cz - parityZAuto;
        for (BlockEntry entry : this.blocks) {
            stack.method_22903();
            stack.method_46416((float)entry.pos.method_10263() - pivotX, (float)entry.pos.method_10264() - pivotY, (float)entry.pos.method_10260() - pivotZ);
            class_310.method_1551().method_1541().method_3353(entry.state, stack, (class_4597)consumers, light, overlay);
            stack.method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderStructureCulledWorld(FormRenderingContext context, class_4587 stack, class_4597 consumers, int light, int overlay, boolean useEntityLayers) {
        class_2338 anchor;
        boolean isItemContext;
        int lightIntensity;
        boolean lightsEnabled;
        float cy;
        float cz;
        float cx;
        if (this.boundsMin != null && this.boundsMax != null) {
            cx = (float)(this.boundsMin.method_10263() + this.boundsMax.method_10263()) / 2.0f;
            cz = (float)(this.boundsMin.method_10260() + this.boundsMax.method_10260()) / 2.0f;
            cy = this.boundsMin.method_10264();
        } else {
            cx = (float)this.size.method_10263() / 2.0f;
            cy = 0.0f;
            cz = (float)this.size.method_10260() / 2.0f;
        }
        float parityXAuto2 = 0.0f;
        float parityZAuto2 = 0.0f;
        if (this.boundsMin != null && this.boundsMax != null) {
            int widthX = this.boundsMax.method_10263() - this.boundsMin.method_10263() + 1;
            int widthZ = this.boundsMax.method_10260() - this.boundsMin.method_10260() + 1;
            parityXAuto2 = widthX % 2 == 1 ? -0.5f : 0.0f;
            parityZAuto2 = widthZ % 2 == 1 ? -0.5f : 0.0f;
        }
        float pivotX = cx - parityXAuto2;
        float pivotY = cy;
        float pivotZ = cz - parityZAuto2;
        ArrayList<VirtualBlockRenderView.Entry> entries = new ArrayList<VirtualBlockRenderView.Entry>();
        for (BlockEntry be : this.blocks) {
            entries.add(new VirtualBlockRenderView.Entry(be.state, be.pos));
        }
        StructureLightSettings slRuntime = (StructureLightSettings)((StructureForm)this.form).structureLight.getRuntimeValue();
        if (slRuntime != null) {
            lightsEnabled = slRuntime.enabled;
            lightIntensity = slRuntime.intensity;
        } else {
            lightsEnabled = (Boolean)((StructureForm)this.form).emitLight.get();
            lightIntensity = (Integer)((StructureForm)this.form).lightIntensity.get();
        }
        VirtualBlockRenderView view = new VirtualBlockRenderView(entries).setBiomeOverride((String)((StructureForm)this.form).biomeId.get()).setLightsEnabled(lightsEnabled).setLightIntensity(lightIntensity);
        class_824 beDispatcher = class_310.method_1551().method_31975();
        boolean bl = isItemContext = context.type == FormRenderType.ITEM || context.type == FormRenderType.ITEM_FP || context.type == FormRenderType.ITEM_TP || context.type == FormRenderType.ITEM_INVENTORY;
        if (isItemContext || context.entity == null) {
            class_310 mc = class_310.method_1551();
            anchor = mc.field_1724 != null ? mc.field_1724.method_24515() : class_2338.field_10980;
        } else {
            anchor = new class_2338((int)Math.floor(context.entity.getX()), (int)Math.floor(context.entity.getY()), (int)Math.floor(context.entity.getZ()));
        }
        int baseDx = (int)Math.floor(-pivotX);
        int baseDy = (int)Math.floor(-pivotY);
        int baseDz = (int)Math.floor(-pivotZ);
        view.setWorldAnchor(anchor, baseDx, baseDy, baseDz).setForceMaxSkyLight(context.ui || context.type == FormRenderType.PREVIEW || context.type == FormRenderType.ITEM_INVENTORY);
        for (BlockEntry entry : this.blocks) {
            int dz;
            int dy;
            int dx;
            class_2338 worldPos;
            class_2586 be;
            stack.method_22903();
            stack.method_46416((float)entry.pos.method_10263() - pivotX, (float)entry.pos.method_10264() - pivotY, (float)entry.pos.method_10260() - pivotZ);
            if (this.capturingVAO && !this.capturingIncludeSpecialBlocks && (this.isAnimatedTexture(entry.state) || this.isBiomeTinted(entry.state))) {
                stack.method_22909();
                continue;
            }
            class_1921 layer = useEntityLayers ? class_4696.method_23683((class_2680)entry.state, (boolean)false) : class_4696.method_23679((class_2680)entry.state);
            float globalAlpha = ((Color)((StructureForm)this.form).color.get()).a;
            if (globalAlpha < 0.999f) {
                layer = useEntityLayers ? class_4722.method_24076() : class_1921.method_23583();
            }
            class_4588 vc = consumers.getBuffer(layer);
            Color tint = (Color)((StructureForm)this.form).color.get();
            Function<class_4588, class_4588> recolor = BBSRendering.getColorConsumer(tint);
            if (recolor != null) {
                vc = recolor.apply(vc);
            }
            class_310.method_1551().method_1541().method_3355(entry.state, entry.pos, (class_1920)view, stack, vc, true, class_5819.method_43047());
            class_2248 block = entry.state.method_26204();
            if (!this.capturingVAO && block instanceof class_2343 && (be = ((class_2343)block).method_10123(worldPos = anchor.method_10069(dx = (int)Math.floor((float)entry.pos.method_10263() - pivotX), dy = (int)Math.floor((float)entry.pos.method_10264() - pivotY), dz = (int)Math.floor((float)entry.pos.method_10260() - pivotZ)), entry.state)) != null) {
                if (class_310.method_1551().field_1687 != null) {
                    be.method_31662((class_1937)class_310.method_1551().field_1687);
                }
                class_827 renderer = beDispatcher.method_3550(be);
                int skyLight = view.method_8314(class_1944.field_9284, entry.pos);
                int blockLight = view.method_8314(class_1944.field_9282, entry.pos);
                int beLight = class_765.method_23687((int)blockLight, (int)skyLight);
                if (renderer != null) {
                    class_827 raw = renderer;
                    CustomVertexConsumerProvider beProvider = FormUtilsClient.getProvider();
                    beProvider.setSubstitute(BBSRendering.getColorConsumer((Color)((StructureForm)this.form).color.get()));
                    try {
                        raw.method_3569(be, 0.0f, stack, (class_4597)beProvider, beLight, overlay);
                    }
                    finally {
                        beProvider.method_22993();
                        beProvider.setSubstitute(null);
                        CustomVertexConsumerProvider.clearRunnables();
                    }
                }
            }
            stack.method_22909();
        }
        RecolorVertexConsumer.newColor = null;
    }

    private void renderAnimatedBlocksVanilla(FormRenderingContext context, class_4587 stack, class_4597 consumers, int light, int overlay) {
        class_2338 anchor;
        boolean isItemContextAnim;
        int lightIntensity2;
        boolean lightsEnabled2;
        float cy;
        float cz;
        float cx;
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        if (this.boundsMin != null && this.boundsMax != null) {
            cx = (float)(this.boundsMin.method_10263() + this.boundsMax.method_10263()) / 2.0f;
            cz = (float)(this.boundsMin.method_10260() + this.boundsMax.method_10260()) / 2.0f;
            cy = this.boundsMin.method_10264();
        } else {
            cx = (float)this.size.method_10263() / 2.0f;
            cy = 0.0f;
            cz = (float)this.size.method_10260() / 2.0f;
        }
        float parityXAuto3 = 0.0f;
        float parityZAuto3 = 0.0f;
        if (this.boundsMin != null && this.boundsMax != null) {
            int widthX = this.boundsMax.method_10263() - this.boundsMin.method_10263() + 1;
            int widthZ = this.boundsMax.method_10260() - this.boundsMin.method_10260() + 1;
            parityXAuto3 = widthX % 2 == 1 ? -0.5f : 0.0f;
            parityZAuto3 = widthZ % 2 == 1 ? -0.5f : 0.0f;
        }
        float pivotX = cx - parityXAuto3;
        float pivotY = cy;
        float pivotZ = cz - parityZAuto3;
        ArrayList<VirtualBlockRenderView.Entry> entries = new ArrayList<VirtualBlockRenderView.Entry>();
        for (BlockEntry be : this.blocks) {
            entries.add(new VirtualBlockRenderView.Entry(be.state, be.pos));
        }
        StructureLightSettings slRuntime2 = (StructureLightSettings)((StructureForm)this.form).structureLight.getRuntimeValue();
        if (slRuntime2 != null) {
            lightsEnabled2 = slRuntime2.enabled;
            lightIntensity2 = slRuntime2.intensity;
        } else {
            lightsEnabled2 = (Boolean)((StructureForm)this.form).emitLight.get();
            lightIntensity2 = (Integer)((StructureForm)this.form).lightIntensity.get();
        }
        VirtualBlockRenderView view = new VirtualBlockRenderView(entries).setBiomeOverride((String)((StructureForm)this.form).biomeId.get()).setLightsEnabled(lightsEnabled2).setLightIntensity(lightIntensity2);
        boolean bl = isItemContextAnim = context.type == FormRenderType.ITEM || context.type == FormRenderType.ITEM_FP || context.type == FormRenderType.ITEM_TP || context.type == FormRenderType.ITEM_INVENTORY;
        if (isItemContextAnim || context.entity == null) {
            class_310 mc2 = class_310.method_1551();
            anchor = mc2.field_1724 != null ? mc2.field_1724.method_24515() : class_2338.field_10980;
        } else {
            anchor = new class_2338((int)Math.floor(context.entity.getX()), (int)Math.floor(context.entity.getY()), (int)Math.floor(context.entity.getZ()));
        }
        int baseDx = (int)Math.floor(-pivotX);
        int baseDy = (int)Math.floor(-pivotY);
        int baseDz = (int)Math.floor(-pivotZ);
        view.setWorldAnchor(anchor, baseDx, baseDy, baseDz).setForceMaxSkyLight(context.ui || context.type == FormRenderType.PREVIEW || context.type == FormRenderType.ITEM_INVENTORY);
        for (BlockEntry entry : this.blocks) {
            if (!this.isAnimatedTexture(entry.state)) continue;
            stack.method_22903();
            stack.method_46416((float)entry.pos.method_10263() - pivotX, (float)entry.pos.method_10264() - pivotY, (float)entry.pos.method_10260() - pivotZ);
            boolean shadersEnabled = BBSRendering.isIrisShadersEnabled() && BBSRendering.isRenderingWorld();
            class_1921 layer = shadersEnabled ? class_4696.method_23683((class_2680)entry.state, (boolean)true) : class_1921.method_29380();
            float globalAlphaAnim = ((Color)((StructureForm)this.form).color.get()).a;
            if (globalAlphaAnim < 0.999f) {
                layer = shadersEnabled ? class_4722.method_24076() : class_1921.method_29380();
            }
            class_4588 vc = consumers.getBuffer(layer);
            Color tint = (Color)((StructureForm)this.form).color.get();
            Function<class_4588, class_4588> recolor = BBSRendering.getColorConsumer(tint);
            if (recolor != null) {
                vc = recolor.apply(vc);
            }
            class_310.method_1551().method_1541().method_3355(entry.state, entry.pos, (class_1920)view, stack, vc, true, class_5819.method_43047());
            stack.method_22909();
        }
        RecolorVertexConsumer.newColor = null;
    }

    private void renderBiomeTintedBlocksVanilla(FormRenderingContext context, class_4587 stack, class_4597 consumers, int light, int overlay) {
        class_2338 anchor;
        boolean isItemContextTint;
        float cy;
        float cz;
        float cx;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        if (this.boundsMin != null && this.boundsMax != null) {
            cx = (float)(this.boundsMin.method_10263() + this.boundsMax.method_10263()) / 2.0f;
            cz = (float)(this.boundsMin.method_10260() + this.boundsMax.method_10260()) / 2.0f;
            cy = this.boundsMin.method_10264();
        } else {
            cx = (float)this.size.method_10263() / 2.0f;
            cy = 0.0f;
            cz = (float)this.size.method_10260() / 2.0f;
        }
        float parityXAuto4 = 0.0f;
        float parityZAuto4 = 0.0f;
        if (this.boundsMin != null && this.boundsMax != null) {
            int widthX = this.boundsMax.method_10263() - this.boundsMin.method_10263() + 1;
            int widthZ = this.boundsMax.method_10260() - this.boundsMin.method_10260() + 1;
            parityXAuto4 = widthX % 2 == 1 ? -0.5f : 0.0f;
            parityZAuto4 = widthZ % 2 == 1 ? -0.5f : 0.0f;
        }
        float pivotX = cx - parityXAuto4;
        float pivotY = cy;
        float pivotZ = cz - parityZAuto4;
        ArrayList<VirtualBlockRenderView.Entry> entries = new ArrayList<VirtualBlockRenderView.Entry>();
        for (BlockEntry be : this.blocks) {
            entries.add(new VirtualBlockRenderView.Entry(be.state, be.pos));
        }
        VirtualBlockRenderView view = new VirtualBlockRenderView(entries).setBiomeOverride((String)((StructureForm)this.form).biomeId.get()).setLightsEnabled((Boolean)((StructureForm)this.form).emitLight.get()).setLightIntensity((Integer)((StructureForm)this.form).lightIntensity.get());
        boolean bl = isItemContextTint = context.type == FormRenderType.ITEM || context.type == FormRenderType.ITEM_FP || context.type == FormRenderType.ITEM_TP || context.type == FormRenderType.ITEM_INVENTORY;
        if (isItemContextTint || context.entity == null) {
            class_310 mc3 = class_310.method_1551();
            anchor = mc3.field_1724 != null ? mc3.field_1724.method_24515() : class_2338.field_10980;
        } else {
            anchor = new class_2338((int)Math.floor(context.entity.getX()), (int)Math.floor(context.entity.getY()), (int)Math.floor(context.entity.getZ()));
        }
        int baseDx = (int)Math.floor(-pivotX);
        int baseDy = (int)Math.floor(-pivotY);
        int baseDz = (int)Math.floor(-pivotZ);
        view.setWorldAnchor(anchor, baseDx, baseDy, baseDz).setForceMaxSkyLight(context.ui || context.type == FormRenderType.PREVIEW || context.type == FormRenderType.ITEM_INVENTORY);
        for (BlockEntry entry : this.blocks) {
            if (!this.isBiomeTinted(entry.state)) continue;
            stack.method_22903();
            stack.method_46416((float)entry.pos.method_10263() - pivotX, (float)entry.pos.method_10264() - pivotY, (float)entry.pos.method_10260() - pivotZ);
            boolean shadersEnabledTint = BBSRendering.isIrisShadersEnabled() && BBSRendering.isRenderingWorld();
            class_1921 layer = shadersEnabledTint ? class_4696.method_23683((class_2680)entry.state, (boolean)false) : class_4696.method_23679((class_2680)entry.state);
            float globalAlpha = ((Color)((StructureForm)this.form).color.get()).a;
            if (globalAlpha < 0.999f) {
                layer = shadersEnabledTint ? class_4722.method_24076() : class_1921.method_23583();
            }
            class_4588 vc = consumers.getBuffer(layer);
            Color tint = (Color)((StructureForm)this.form).color.get();
            Function<class_4588, class_4588> recolor = BBSRendering.getColorConsumer(tint);
            if (recolor != null) {
                vc = recolor.apply(vc);
            }
            class_310.method_1551().method_1541().method_3355(entry.state, entry.pos, (class_1920)view, stack, vc, true, class_5819.method_43047());
            stack.method_22909();
        }
        RenderSystem.disableBlend();
        RecolorVertexConsumer.newColor = null;
    }

    private boolean isAnimatedTexture(class_2680 state) {
        if (state == null) {
            return false;
        }
        if (state.method_27852(class_2246.field_10316)) {
            return true;
        }
        class_3610 fs = state.method_26227();
        return fs != null && (fs.method_15772() == class_3612.field_15910 || fs.method_15772() == class_3612.field_15909 || fs.method_15772() == class_3612.field_15908 || fs.method_15772() == class_3612.field_15907);
    }

    private boolean isBiomeTinted(class_2680 state) {
        if (state == null) {
            return false;
        }
        class_2248 b = state.method_26204();
        return b instanceof class_2397 || b instanceof class_2372 || b instanceof class_2541 || b instanceof class_2553;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBlockEntitiesOnly(FormRenderingContext context, class_4587 stack, class_4597 consumers, int light, int overlay) {
        float pivotZ;
        float pivotY;
        float pivotX;
        boolean useAuto;
        float cy;
        float cz;
        float cx;
        if (this.boundsMin != null && this.boundsMax != null) {
            cx = (float)(this.boundsMin.method_10263() + this.boundsMax.method_10263()) / 2.0f;
            cz = (float)(this.boundsMin.method_10260() + this.boundsMax.method_10260()) / 2.0f;
            cy = this.boundsMin.method_10264();
        } else {
            cx = (float)this.size.method_10263() / 2.0f;
            cy = 0.0f;
            cz = (float)this.size.method_10260() / 2.0f;
        }
        PivotSettings pivotSettingsRuntime = (PivotSettings)((StructureForm)this.form).pivot.getRuntimeValue();
        boolean bl = useAuto = pivotSettingsRuntime != null ? pivotSettingsRuntime.auto : (Boolean)((StructureForm)this.form).autoPivot.get();
        if (useAuto) {
            float parityXAuto = 0.0f;
            float parityZAuto = 0.0f;
            if (this.boundsMin != null && this.boundsMax != null) {
                int widthX = this.boundsMax.method_10263() - this.boundsMin.method_10263() + 1;
                int widthZ = this.boundsMax.method_10260() - this.boundsMin.method_10260() + 1;
                parityXAuto = widthX % 2 == 1 ? -0.5f : 0.0f;
                parityZAuto = widthZ % 2 == 1 ? -0.5f : 0.0f;
            }
            pivotX = cx - parityXAuto;
            pivotY = cy;
            pivotZ = cz - parityZAuto;
        } else if (pivotSettingsRuntime != null) {
            pivotX = pivotSettingsRuntime.pivot.x;
            pivotY = pivotSettingsRuntime.pivot.y;
            pivotZ = pivotSettingsRuntime.pivot.z;
        } else {
            pivotX = ((Float)((StructureForm)this.form).pivotX.get()).floatValue();
            pivotY = ((Float)((StructureForm)this.form).pivotY.get()).floatValue();
            pivotZ = ((Float)((StructureForm)this.form).pivotZ.get()).floatValue();
        }
        class_2338 anchor = context.entity != null ? new class_2338((int)Math.floor(context.entity.getX()), (int)Math.floor(context.entity.getY()), (int)Math.floor(context.entity.getZ())) : class_2338.field_10980;
        class_824 beDispatcher = class_310.method_1551().method_31975();
        for (BlockEntry entry : this.blocks) {
            class_2248 block = entry.state.method_26204();
            if (!(block instanceof class_2343)) continue;
            stack.method_22903();
            stack.method_46416((float)entry.pos.method_10263() - pivotX, (float)entry.pos.method_10264() - pivotY, (float)entry.pos.method_10260() - pivotZ);
            int dx = (int)Math.floor((float)entry.pos.method_10263() - pivotX);
            int dy = (int)Math.floor((float)entry.pos.method_10264() - pivotY);
            int dz = (int)Math.floor((float)entry.pos.method_10260() - pivotZ);
            class_2338 worldPos = anchor.method_10069(dx, dy, dz);
            class_2586 be = ((class_2343)block).method_10123(worldPos, entry.state);
            if (be != null) {
                int lightIntensityBE;
                boolean lightsEnabledBE;
                if (class_310.method_1551().field_1687 != null) {
                    be.method_31662((class_1937)class_310.method_1551().field_1687);
                }
                class_827 renderer = beDispatcher.method_3550(be);
                ArrayList<VirtualBlockRenderView.Entry> entries = new ArrayList<VirtualBlockRenderView.Entry>();
                for (BlockEntry beEntry : this.blocks) {
                    entries.add(new VirtualBlockRenderView.Entry(beEntry.state, beEntry.pos));
                }
                StructureLightSettings slRuntimeBE = (StructureLightSettings)((StructureForm)this.form).structureLight.getRuntimeValue();
                if (slRuntimeBE != null) {
                    lightsEnabledBE = slRuntimeBE.enabled;
                    lightIntensityBE = slRuntimeBE.intensity;
                } else {
                    lightsEnabledBE = (Boolean)((StructureForm)this.form).emitLight.get();
                    lightIntensityBE = (Integer)((StructureForm)this.form).lightIntensity.get();
                }
                VirtualBlockRenderView beView = new VirtualBlockRenderView(entries).setBiomeOverride((String)((StructureForm)this.form).biomeId.get()).setLightsEnabled(lightsEnabledBE).setLightIntensity(lightIntensityBE).setWorldAnchor(anchor, (int)Math.floor(-pivotX), (int)Math.floor(-pivotY), (int)Math.floor(-pivotZ));
                int skyLight = beView.method_8314(class_1944.field_9284, entry.pos);
                int blockLight = beView.method_8314(class_1944.field_9282, entry.pos);
                int beLight = class_765.method_23687((int)blockLight, (int)skyLight);
                if (renderer != null) {
                    class_827 raw = renderer;
                    CustomVertexConsumerProvider beProvider = FormUtilsClient.getProvider();
                    beProvider.setSubstitute(BBSRendering.getColorConsumer((Color)((StructureForm)this.form).color.get()));
                    try {
                        raw.method_3569(be, 0.0f, stack, (class_4597)beProvider, beLight, overlay);
                    }
                    finally {
                        beProvider.method_22993();
                        beProvider.setSubstitute(null);
                        CustomVertexConsumerProvider.clearRunnables();
                    }
                }
            }
            stack.method_22909();
        }
    }

    private boolean isShadersActive() {
        try {
            Class<?> apiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Object api = apiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object result = apiClass.getMethod("isShaderPackInUse", new Class[0]).invoke(api, new Object[0]);
            return result instanceof Boolean && (Boolean)result != false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void ensureLoaded() {
        String file = (String)((StructureForm)this.form).structureFile.get();
        if (file == null || file.isEmpty()) {
            this.blocks.clear();
            this.size = class_2338.field_10980;
            this.boundsMin = null;
            this.boundsMax = null;
            this.lastFile = null;
            this.vaoDirty = true;
            this.vaoPickingDirty = true;
            if (this.structureVao instanceof ModelVAO) {
                ((ModelVAO)this.structureVao).delete();
            }
            this.structureVao = null;
            if (this.structureVaoPicking instanceof ModelVAO) {
                ((ModelVAO)this.structureVaoPicking).delete();
            }
            this.structureVaoPicking = null;
            return;
        }
        if (file.equals(this.lastFile)) {
            return;
        }
        File nbtFile = BBSMod.getProvider().getFile(Link.assets(file));
        this.blocks.clear();
        this.size = class_2338.field_10980;
        this.boundsMin = null;
        this.boundsMax = null;
        this.lastFile = file;
        this.vaoDirty = true;
        this.vaoPickingDirty = true;
        if (this.structureVao instanceof ModelVAO) {
            ((ModelVAO)this.structureVao).delete();
        }
        this.structureVao = null;
        if (this.structureVaoPicking instanceof ModelVAO) {
            ((ModelVAO)this.structureVaoPicking).delete();
        }
        this.structureVaoPicking = null;
        if (nbtFile != null && nbtFile.exists()) {
            try {
                class_2487 root = class_2507.method_30613((Path)nbtFile.toPath(), (class_2505)class_2505.method_53898());
                this.parseStructure(root);
                return;
            }
            catch (IOException root) {
                // empty catch block
            }
        }
        try (InputStream is = BBSMod.getProvider().getAsset(Link.assets(file));){
            try {
                class_2487 root = class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898());
                this.parseStructure(root);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStructureVAO() {
        CustomVertexConsumerProvider provider = FormUtilsClient.getProvider();
        StructureVAOCollector collector = new StructureVAOCollector();
        provider.setSubstitute(vc -> collector);
        class_4587 captureStack = new class_4587();
        FormRenderingContext captureContext = new FormRenderingContext().set(FormRenderType.PREVIEW, null, captureStack, 240, class_4608.field_21444, 0.0f);
        try {
            class_5365 gm = (class_5365)class_310.method_1551().field_1690.method_42534().method_41753();
            class_4696.method_23682((gm != class_5365.field_25427 ? 1 : 0) != 0);
        }
        catch (Throwable gm) {
            // empty catch block
        }
        boolean useEntityLayers = false;
        this.capturingVAO = true;
        this.capturingIncludeSpecialBlocks = false;
        try {
            this.renderStructureCulledWorld(captureContext, captureStack, (class_4597)provider, 240, class_4608.field_21444, useEntityLayers);
        }
        finally {
            this.capturingVAO = false;
            this.capturingIncludeSpecialBlocks = false;
        }
        provider.method_22993();
        provider.setSubstitute(null);
        ModelVAOData data = collector.toData();
        this.structureVao = new ModelVAO(data);
        this.vaoDirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStructureVAOPicking() {
        CustomVertexConsumerProvider provider = FormUtilsClient.getProvider();
        StructureVAOCollector collector = new StructureVAOCollector();
        provider.setSubstitute(vc -> collector);
        class_4587 captureStack = new class_4587();
        FormRenderingContext captureContext = new FormRenderingContext().set(FormRenderType.PREVIEW, null, captureStack, 240, class_4608.field_21444, 0.0f);
        try {
            class_5365 gm = (class_5365)class_310.method_1551().field_1690.method_42534().method_41753();
            class_4696.method_23682((gm != class_5365.field_25427 ? 1 : 0) != 0);
        }
        catch (Throwable gm) {
            // empty catch block
        }
        boolean useEntityLayers = false;
        this.capturingVAO = true;
        this.capturingIncludeSpecialBlocks = true;
        try {
            this.renderStructureCulledWorld(captureContext, captureStack, (class_4597)provider, 240, class_4608.field_21444, useEntityLayers);
        }
        finally {
            this.capturingVAO = false;
            this.capturingIncludeSpecialBlocks = false;
        }
        provider.method_22993();
        provider.setSubstitute(null);
        ModelVAOData data = collector.toData();
        this.structureVaoPicking = new ModelVAO(data);
        this.vaoPickingDirty = false;
    }

    private void parseStructure(class_2487 root) {
        int[] sz;
        if (root.method_10573("size", 11) && (sz = root.method_10561("size")).length >= 3) {
            this.size = new class_2338(sz[0], sz[1], sz[2]);
        }
        ArrayList<class_2680> paletteStates = new ArrayList<class_2680>();
        if (root.method_10573("palette", 9)) {
            class_2499 palette = root.method_10554("palette", 10);
            for (int i = 0; i < palette.size(); ++i) {
                class_2487 entry = palette.method_10602(i);
                class_2680 state = this.readBlockState(entry);
                paletteStates.add(state);
            }
        }
        if (root.method_10573("blocks", 9)) {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            class_2499 list = root.method_10554("blocks", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 be = list.method_10602(i);
                class_2338 pos = this.readBlockPos(be.method_10554("pos", 3));
                int stateIndex = be.method_10550("state");
                if (stateIndex < 0 || stateIndex >= paletteStates.size()) continue;
                class_2680 state = (class_2680)paletteStates.get(stateIndex);
                this.blocks.add(new BlockEntry(state, pos));
                if (pos.method_10263() < minX) {
                    minX = pos.method_10263();
                }
                if (pos.method_10264() < minY) {
                    minY = pos.method_10264();
                }
                if (pos.method_10260() < minZ) {
                    minZ = pos.method_10260();
                }
                if (pos.method_10263() > maxX) {
                    maxX = pos.method_10263();
                }
                if (pos.method_10264() > maxY) {
                    maxY = pos.method_10264();
                }
                if (pos.method_10260() <= maxZ) continue;
                maxZ = pos.method_10260();
            }
            if (!this.blocks.isEmpty()) {
                this.boundsMin = new class_2338(minX, minY, minZ);
                this.boundsMax = new class_2338(maxX, maxY, maxZ);
            }
        }
    }

    private class_2338 readBlockPos(class_2499 list) {
        if (list == null || list.size() < 3) {
            return class_2338.field_10980;
        }
        int x = list.method_10600(0);
        int y = list.method_10600(1);
        int z = list.method_10600(2);
        return new class_2338(x, y, z);
    }

    private class_2680 readBlockState(class_2487 entry) {
        class_2248 block;
        String name = entry.method_10558("Name");
        try {
            class_2960 id = class_2960.method_60654((String)name);
            block = (class_2248)class_7923.field_41175.method_10223(id);
            if (block == null) {
                block = class_2246.field_10124;
            }
        }
        catch (Exception e) {
            block = class_2246.field_10124;
        }
        class_2680 state = block.method_9564();
        if (entry.method_10573("Properties", 10)) {
            class_2487 props = entry.method_10562("Properties");
            for (String key : props.method_10541()) {
                Optional parsed;
                String value = props.method_10558(key);
                class_2769 property = block.method_9595().method_11663(key);
                if (property == null || !(parsed = property.method_11900(value)).isPresent()) continue;
                try {
                    class_2769 raw = property;
                    Comparable c = (Comparable)parsed.get();
                    state = (class_2680)state.method_11657(raw, c);
                }
                catch (Exception exception) {}
            }
        }
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    private static class BlockEntry {
        final class_2680 state;
        final class_2338 pos;

        BlockEntry(class_2680 state, class_2338 pos) {
            this.state = state;
            this.pos = pos;
        }
    }
}

