/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.states;

import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.states.AnimationState;
import mchorse.bbs_mod.utils.interps.Lerps;

public class StatePlayer {
    private AnimationState state;
    private int tick;
    private boolean kill;
    private int killTimer;
    private boolean first = true;

    public StatePlayer(AnimationState state) {
        this.state = state;
    }

    public AnimationState getState() {
        return this.state;
    }

    public boolean canBeRemoved() {
        if (this.kill) {
            return this.killTimer <= 0;
        }
        if (((Boolean)this.state.main.get()).booleanValue() || ((Boolean)this.state.looping.get()).booleanValue()) {
            return false;
        }
        return this.tick >= (Integer)this.state.duration.get();
    }

    public void update() {
        ++this.tick;
        if ((((Boolean)this.state.main.get()).booleanValue() || ((Boolean)this.state.looping.get()).booleanValue()) && this.tick >= (Integer)this.state.duration.get()) {
            this.tick = (Integer)this.state.offset.get();
            this.first = false;
        }
        if (this.kill) {
            --this.killTimer;
        }
    }

    public void assignValues(Form form, float transition) {
        float t = (float)this.tick + transition;
        int duration = (Integer)this.state.duration.get();
        float blend = Lerps.envelope(t, 0.0f, ((Integer)this.state.fadeIn.get()).intValue(), duration - (Integer)this.state.fadeOut.get(), duration);
        if (((Boolean)this.state.looping.get()).booleanValue()) {
            blend = this.first ? Lerps.envelope(t, 0.0f, ((Integer)this.state.fadeIn.get()).intValue(), duration, duration) : 1.0f;
            blend *= this.kill ? ((float)this.killTimer - transition) / (float)((Integer)this.state.fadeOut.get()).intValue() : 1.0f;
        }
        this.state.properties.applyProperties(form, t, blend);
    }

    public void resetValues(Form form) {
        this.state.properties.resetProperties(form);
    }

    public void expire() {
        this.kill = true;
        this.killTimer = (Integer)this.state.fadeOut.get();
    }
}

