/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.particles.emitter;

import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.particles.emitter.ParticleEmitter;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class Particle {
    public float random1 = (float)Math.random();
    public float random2 = (float)Math.random();
    public float random3 = (float)Math.random();
    public float random4 = (float)Math.random();
    public final int index;
    public final float offset;
    public int age;
    public int lifetime;
    private boolean dead;
    public boolean relativePosition;
    public boolean relativeRotation;
    public boolean relativeVelocity;
    public boolean textureScale;
    public boolean manual;
    public float rotation;
    public float initialRotation;
    public float prevRotation;
    public float rotationVelocity;
    public float rotationAcceleration;
    public float rotationDrag;
    public Vector3d position = new Vector3d();
    public Vector3d initialPosition = new Vector3d();
    public Vector3d prevPosition = new Vector3d();
    public Matrix3f matrix = new Matrix3f();
    private boolean matrixSet;
    public Vector3f speed = new Vector3f();
    public Vector3f acceleration = new Vector3f();
    public Vector3f accelerationFactor = new Vector3f(1.0f, 1.0f, 1.0f);
    public float drag = 0.0f;
    public float dragFactor = 0.0f;
    public float r = 1.0f;
    public float g = 1.0f;
    public float b = 1.0f;
    public float a = 1.0f;
    private Vector3d global = new Vector3d();
    public Map<String, Double> localValues = new HashMap<String, Double>();

    public Particle(int index, float offset) {
        this.index = index;
        this.offset = offset;
        this.speed.set((float)Math.random() - 0.5f, (float)Math.random() - 0.5f, (float)Math.random() - 0.5f);
        this.speed.normalize();
    }

    public void setDead() {
        this.dead = true;
    }

    public boolean isDead() {
        return this.dead;
    }

    public double getAge(float transition) {
        return (double)((float)this.age + transition) / 20.0;
    }

    public Vector3d getGlobalPosition(ParticleEmitter emitter) {
        return this.getGlobalPosition(emitter, this.position);
    }

    public Vector3d getGlobalPosition(ParticleEmitter emitter, Vector3d vector) {
        double px = vector.x;
        double py = vector.y;
        double pz = vector.z;
        if (this.relativePosition && this.relativeRotation) {
            Vector3f v = new Vector3f((float)px, (float)py, (float)pz);
            emitter.rotation.transform(v);
            px = v.x;
            py = v.y;
            pz = v.z;
            px += emitter.lastGlobal.x;
            py += emitter.lastGlobal.y;
            pz += emitter.lastGlobal.z;
        }
        this.global.set(px, py, pz);
        return this.global;
    }

    public void update(ParticleEmitter emitter) {
        this.prevRotation = this.rotation;
        this.prevPosition.set((Vector3dc)this.position);
        this.setupMatrix(emitter);
        if (!this.manual) {
            float rotationAcceleration = this.rotationAcceleration / 20.0f - this.rotationDrag * this.rotationVelocity;
            this.rotationVelocity += rotationAcceleration / 20.0f;
            this.rotation = this.initialRotation + this.rotationVelocity * (float)this.age;
            Vector3f vec = new Vector3f((Vector3fc)this.speed);
            vec.mul(-(this.drag + this.dragFactor));
            this.acceleration.add((Vector3fc)vec);
            this.acceleration.div(20.0f);
            if (this.relativeVelocity) {
                if (this.age == 0) {
                    this.matrix.transform(this.speed);
                }
                this.speed.add((Vector3fc)this.acceleration);
                vec.set((Vector3fc)this.speed);
                vec.x *= this.accelerationFactor.x;
                vec.y *= this.accelerationFactor.y;
                vec.z *= this.accelerationFactor.z;
            } else {
                this.speed.add((Vector3fc)this.acceleration);
                vec.set((Vector3fc)this.speed);
                vec.x *= this.accelerationFactor.x;
                vec.y *= this.accelerationFactor.y;
                vec.z *= this.accelerationFactor.z;
                this.matrix.transform(vec);
            }
            if (this.age == 0) {
                vec.mul(1.0f + this.offset);
            }
            this.position.x += (double)(vec.x / 20.0f);
            this.position.y += (double)(vec.y / 20.0f);
            this.position.z += (double)(vec.z / 20.0f);
        }
        if (this.lifetime >= 0 && this.age >= this.lifetime) {
            this.setDead();
        }
        ++this.age;
    }

    public void setupMatrix(ParticleEmitter emitter) {
        if (this.relativePosition) {
            if (this.relativeRotation) {
                this.matrix.identity();
            } else if (!this.matrixSet) {
                this.matrix.set((Matrix3fc)emitter.rotation);
                this.matrixSet = true;
            }
        } else if (this.relativeRotation) {
            this.matrix.set((Matrix3fc)emitter.rotation);
        } else if (this.relativeVelocity && !this.matrixSet) {
            this.matrix.set((Matrix3fc)emitter.rotation);
            this.matrixSet = true;
        } else if (this.textureScale && !this.matrixSet) {
            this.matrix.identity().scale(emitter.rotation.getRow(0, Vectors.TEMP_3F).length());
            this.matrixSet = true;
        }
    }
}

