/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.settings.values.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.data.IDataSerializable;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.settings.values.IValueListener;
import mchorse.bbs_mod.settings.values.IValueNotifier;
import mchorse.bbs_mod.utils.DataPath;

public abstract class BaseValue
implements IDataSerializable<BaseType>,
IValueNotifier {
    protected String id;
    protected BaseValue parent;
    private boolean visible = true;
    private List<IValueListener> preCallbacks;
    private List<IValueListener> postCallbacks;

    public static <T extends BaseValue> void edit(T value, Consumer<T> callback) {
        BaseValue.edit(value, 0, callback);
    }

    public static <T extends BaseValue> void edit(T value, int flag, Consumer<T> callback) {
        if (callback == null) {
            return;
        }
        value.preNotify(flag);
        callback.accept(value);
        value.postNotify(flag);
    }

    public BaseValue(String id) {
        this.setId(id);
    }

    public void setId(String id) {
        this.id = id;
    }

    public BaseValue invisible() {
        this.visible = false;
        return this;
    }

    public BaseValue preCallback(IValueListener callback) {
        if (this.preCallbacks == null) {
            this.preCallbacks = new ArrayList<IValueListener>();
        }
        this.preCallbacks.add(callback);
        return this;
    }

    public BaseValue postCallback(IValueListener callback) {
        if (this.postCallbacks == null) {
            this.postCallbacks = new ArrayList<IValueListener>();
        }
        this.postCallbacks.add(callback);
        return this;
    }

    public boolean isVisible() {
        boolean visible = true;
        for (BaseValue value = this; value != null; value = value.getParent()) {
            visible = visible && value.visible;
        }
        return visible;
    }

    public BaseValue getRoot() {
        BaseValue value = this;
        while (value.getParent() != null) {
            value = value.getParent();
        }
        return value;
    }

    public void setParent(BaseValue parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public void resetCallbacks() {
        this.postCallbacks = null;
        this.preCallbacks = null;
    }

    @Override
    public void preNotify(int flag) {
        this.preNotify(this, flag);
    }

    @Override
    public void preNotify(BaseValue value, int flag) {
        IValueNotifier.super.preNotify(value, flag);
        if (this.preCallbacks != null) {
            for (IValueListener callback : this.preCallbacks) {
                callback.accept(value, flag);
            }
        }
    }

    @Override
    public void postNotify(int flag) {
        this.postNotify(this, flag);
    }

    @Override
    public void postNotify(BaseValue value, int flag) {
        IValueNotifier.super.postNotify(value, flag);
        if (this.postCallbacks != null) {
            for (IValueListener callback : this.postCallbacks) {
                callback.accept(value, flag);
            }
        }
    }

    @Override
    public BaseValue getParent() {
        return this.parent;
    }

    public List<String> getPathSegments() {
        ArrayList<String> strings = new ArrayList<String>();
        for (BaseValue value = this; value != null; value = value.getParent()) {
            String id = value.getId();
            if (id.isEmpty()) continue;
            strings.add(id);
        }
        Collections.reverse(strings);
        return strings;
    }

    public DataPath getPath() {
        List<String> segments = this.getPathSegments();
        DataPath path = new DataPath(false);
        path.strings.addAll(segments);
        return path;
    }

    public DataPath getRelativePath(BaseValue ancestor) {
        DataPath strings = new DataPath(false);
        BaseValue value = this;
        while (value != null) {
            String id = value.getId();
            if (!id.isEmpty()) {
                strings.strings.add(id);
            }
            if ((value = value.getParent()) != ancestor) continue;
            strings.strings.add(value.getId());
            Collections.reverse(strings.strings);
            return strings;
        }
        return null;
    }

    public void copy(BaseValue value) {
        this.copy(value, 0);
    }

    public void copy(BaseValue value, int flag) {
        this.preNotify(flag);
        if (value != null) {
            this.fromData(value.toData());
        }
        this.postNotify(flag);
    }
}

