/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.dashboard.panels.overlay;

import java.io.File;
import java.util.function.Consumer;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.panels.UIDataDashboardPanel;
import mchorse.bbs_mod.ui.dashboard.panels.overlay.UICRUDOverlayPanel;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.DataPath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIDataOverlayPanel<T extends ValueGroup>
extends UICRUDOverlayPanel {
    protected UIDataDashboardPanel<T> panel;

    public UIDataOverlayPanel(IKey title, UIDataDashboardPanel<T> panel, Consumer<String> callback) {
        super(title, callback);
        this.panel = panel;
        this.namesList.context((ContextMenuManager menu) -> {
            menu.action(Icons.FOLDER, UIKeys.PANELS_MODALS_ADD_FOLDER_TITLE, this::addNewFolder);
            if (this.panel.getData() != null) {
                menu.action(Icons.COPY, UIKeys.PANELS_CONTEXT_COPY, this::copy);
            }
            try {
                MapType data = Window.getClipboardMap("_ContentType_" + this.panel.getType().getId());
                if (data != null) {
                    menu.action(Icons.PASTE, UIKeys.PANELS_CONTEXT_PASTE, () -> this.paste(data));
                }
            }
            catch (Exception data) {
                // empty catch block
            }
            File folder = this.panel.getType().getRepository().getFolder();
            if (folder != null) {
                menu.action(Icons.FOLDER, UIKeys.PANELS_CONTEXT_OPEN, () -> UIUtils.openFolder(new File(folder, this.namesList.getPath().toString())));
            }
        });
    }

    private void copy() {
        Window.setClipboard(((ValueGroup)this.panel.getData()).toData().asMap(), "_ContentType_" + this.panel.getType().getId());
    }

    private void paste(MapType data) {
        this.addNewData(data);
    }

    @Override
    protected void addNewData(String name, MapType mapType) {
        if (name.trim().isEmpty()) {
            this.getContext().notifyError(UIKeys.PANELS_MODALS_EMPTY);
            return;
        }
        if (!this.namesList.hasInHierarchy(name)) {
            this.panel.save();
            ValueGroup data = null;
            this.namesList.addFile(name);
            if (mapType == null) {
                data = this.panel.getType().getRepository().create(name);
                this.fillDefaultData(data);
            } else {
                data = this.panel.getType().getRepository().create(name, mapType);
            }
            this.panel.fill(data);
        }
    }

    @Override
    protected void addNewFolder(String path) {
        if (path.trim().isEmpty()) {
            this.getContext().notifyError(UIKeys.PANELS_MODALS_EMPTY);
            return;
        }
        this.panel.getType().getRepository().addFolder(path, bool -> {
            if (bool.booleanValue()) {
                this.panel.requestNames();
            }
        });
    }

    protected void fillDefaultData(T data) {
        this.panel.fillDefaultData(data);
    }

    @Override
    protected void dupeData(String name) {
        if (name.trim().isEmpty()) {
            this.getContext().notifyError(UIKeys.PANELS_MODALS_EMPTY);
            return;
        }
        if (this.panel.getData() != null && !this.namesList.hasInHierarchy(name)) {
            this.panel.save();
            this.panel.getType().getRepository().save(name, ((ValueGroup)this.panel.getData()).toData().asMap());
            this.namesList.addFile(name);
            ValueGroup data = this.panel.getType().getRepository().create(name, ((ValueGroup)this.panel.getData()).toData().asMap());
            this.panel.fill(data);
        }
    }

    @Override
    protected void renameData(String name) {
        if (name.trim().isEmpty()) {
            this.getContext().notifyError(UIKeys.PANELS_MODALS_EMPTY);
            return;
        }
        if (this.panel.getData() != null && !this.namesList.hasInHierarchy(name)) {
            this.panel.getType().getRepository().rename(((BaseValue)this.panel.getData()).getId(), name);
            this.namesList.removeFile(((BaseValue)this.panel.getData()).getId());
            this.namesList.addFile(name);
            ((BaseValue)this.panel.getData()).setId(name);
        }
    }

    @Override
    protected void renameFolder(String name) {
        if (name.trim().isEmpty()) {
            this.getContext().notifyError(UIKeys.PANELS_MODALS_EMPTY);
            return;
        }
        String path = ((DataPath)this.namesList.getCurrentFirst()).toString();
        this.panel.getType().getRepository().renameFolder(path, name, bool -> {
            if (bool.booleanValue()) {
                if (this.panel.getData() != null) {
                    String id = ((BaseValue)this.panel.getData()).getId();
                    ((BaseValue)this.panel.getData()).setId(name + "/" + id.substring(path.length()));
                }
                this.panel.requestNames();
            }
        });
    }

    @Override
    protected void removeData() {
        if (this.panel.getData() != null) {
            this.panel.getType().getRepository().delete(((BaseValue)this.panel.getData()).getId());
            this.namesList.removeFile(((BaseValue)this.panel.getData()).getId());
            this.panel.fill(null);
        }
    }

    @Override
    protected void removeFolder() {
        String path = ((DataPath)this.namesList.getCurrentFirst()).toString();
        this.panel.getType().getRepository().deleteFolder(path, bool -> {
            if (bool.booleanValue()) {
                this.panel.requestNames();
            }
        });
    }
}

