/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.dashboard.textures.undo;

import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.resources.Pixels;
import mchorse.bbs_mod.utils.undo.IUndo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class PixelsUndo
implements IUndo<Pixels> {
    public Map<Vector2i, Pair<Color, Color>> pixels = new HashMap<Vector2i, Pair<Color, Color>>();

    public void setColor(Pixels pixels, int x, int y, Color color) {
        if (x < 0 || y < 0 || x >= pixels.width || y >= pixels.height) {
            return;
        }
        Vector2i key = new Vector2i(x, y);
        Pair pair = this.pixels.computeIfAbsent(key, k -> new Pair<Color, Object>(pixels.getColor(x, y).copy(), null));
        pair.b = color.copy();
        pixels.setColor(x, y, color);
    }

    @Override
    public IUndo<Pixels> noMerging() {
        return this;
    }

    @Override
    public boolean isMergeable(IUndo<Pixels> undo) {
        return false;
    }

    @Override
    public void merge(IUndo<Pixels> undo) {
    }

    @Override
    public void undo(Pixels context) {
        for (Map.Entry<Vector2i, Pair<Color, Color>> entry : this.pixels.entrySet()) {
            Vector2i key = entry.getKey();
            context.setColor(key.x, key.y, (Color)entry.getValue().a);
        }
    }

    @Override
    public void redo(Pixels context) {
        for (Map.Entry<Vector2i, Pair<Color, Color>> entry : this.pixels.entrySet()) {
            Vector2i key = entry.getKey();
            context.setColor(key.x, key.y, (Color)entry.getValue().b);
        }
    }
}

