/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips.modules;

import mchorse.bbs_mod.camera.data.Angle;
import mchorse.bbs_mod.camera.values.ValueAngle;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.clips.UIClip;
import mchorse.bbs_mod.ui.film.clips.modules.UIAbstractModule;
import mchorse.bbs_mod.ui.film.utils.UICameraUtils;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIAngleModule
extends UIAbstractModule {
    public UITrackpad yaw = new UITrackpad(v -> BaseValue.edit(this.angle, value -> {
        ((Angle)value.get()).yaw = v.floatValue();
    }));
    public UITrackpad pitch;
    public UITrackpad roll;
    public UITrackpad fov;
    public ValueAngle angle;

    public UIAngleModule(IUIClipsDelegate editor) {
        super(editor);
        this.yaw.tooltip(UIKeys.CAMERA_PANELS_YAW);
        this.pitch = new UITrackpad(v -> BaseValue.edit(this.angle, value -> {
            ((Angle)value.get()).pitch = v.floatValue();
        }));
        this.pitch.tooltip(UIKeys.CAMERA_PANELS_PITCH);
        this.roll = new UITrackpad(v -> BaseValue.edit(this.angle, value -> {
            ((Angle)value.get()).roll = v.floatValue();
        }));
        this.roll.tooltip(UIKeys.CAMERA_PANELS_ROLL);
        this.fov = new UITrackpad(v -> BaseValue.edit(this.angle, value -> {
            ((Angle)value.get()).fov = v.floatValue();
        }));
        this.fov.tooltip(UIKeys.CAMERA_PANELS_FOV);
        this.column().vertical().stretch().height(20);
        this.add(UIClip.label(UIKeys.CAMERA_PANELS_ANGLE), this.yaw, this.pitch, this.roll, this.fov);
    }

    public UIAngleModule contextMenu() {
        this.context((ContextMenuManager menu) -> UICameraUtils.angleContextMenu(menu, this.editor, this.angle));
        return this;
    }

    public void fill(ValueAngle angle) {
        this.angle = angle;
        this.yaw.setValue(((Angle)angle.get()).yaw);
        this.pitch.setValue(((Angle)angle.get()).pitch);
        this.roll.setValue(((Angle)angle.get()).roll);
        this.fov.setValue(((Angle)angle.get()).fov);
    }
}

