/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.panels;

import mchorse.bbs_mod.forms.forms.BillboardForm;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.forms.editors.forms.UIForm;
import mchorse.bbs_mod.ui.forms.editors.panels.UIFormPanel;
import mchorse.bbs_mod.ui.forms.editors.utils.UICropOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.framework.elements.input.UITexturePicker;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.utils.Direction;
import mchorse.bbs_mod.utils.colors.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class UIBillboardFormPanel
extends UIFormPanel<BillboardForm> {
    public UIButton pick = new UIButton(UIKeys.FORMS_EDITORS_BILLBOARD_PICK_TEXTURE, b -> UITexturePicker.open(this.getContext(), (Link)((BillboardForm)this.form).texture.get(), l -> ((BillboardForm)this.form).texture.set(l)));
    public UIToggle billboard = new UIToggle(UIKeys.FORMS_EDITORS_BILLBOARD_TITLE, false, b -> ((BillboardForm)this.form).billboard.set(b.getValue()));
    public UIToggle linear = new UIToggle(UIKeys.TEXTURES_LINEAR, false, b -> ((BillboardForm)this.form).linear.set(b.getValue()));
    public UIToggle mipmap = new UIToggle(UIKeys.TEXTURES_MIPMAP, false, b -> ((BillboardForm)this.form).mipmap.set(b.getValue()));
    public UIButton openCrop = new UIButton(UIKeys.FORMS_EDITORS_BILLBOARD_EDIT_CROP, b -> UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)new UICropOverlayPanel((Link)((BillboardForm)this.form).texture.get(), (Vector4f)((BillboardForm)this.form).crop.get()), 0.5f, 0.5f));
    public UIToggle resizeCrop = new UIToggle(UIKeys.FORMS_EDITORS_BILLBOARD_RESIZE_CROP, false, b -> ((BillboardForm)this.form).resizeCrop.set(b.getValue()));
    public UIColor color = new UIColor(value -> ((BillboardForm)this.form).color.set(Color.rgba(value))).direction(Direction.LEFT).withAlpha();
    public UITrackpad offsetX = new UITrackpad(value -> ((BillboardForm)this.form).offsetX.set(Float.valueOf(value.floatValue())));
    public UITrackpad offsetY;
    public UITrackpad rotation;
    public UIToggle shading;

    public UIBillboardFormPanel(UIForm editor) {
        super(editor);
        this.offsetX.tooltip(UIKeys.FORMS_EDITORS_BILLBOARD_OFFSET_X);
        this.offsetY = new UITrackpad(value -> ((BillboardForm)this.form).offsetY.set(Float.valueOf(value.floatValue())));
        this.offsetY.tooltip(UIKeys.FORMS_EDITORS_BILLBOARD_OFFSET_Y);
        this.rotation = new UITrackpad(value -> ((BillboardForm)this.form).rotation.set(Float.valueOf(value.floatValue())));
        this.rotation.tooltip(UIKeys.FORMS_EDITORS_BILLBOARD_ROTATION);
        this.shading = new UIToggle(UIKeys.FORMS_EDITORS_BILLBOARD_SHADING, false, b -> ((BillboardForm)this.form).shading.set(b.getValue()));
        this.options.add(this.pick, this.color, this.billboard, this.linear, this.mipmap);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_BILLBOARD_CROP).marginTop(8), this.openCrop, this.resizeCrop);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_BILLBOARD_UV_SHIFT).marginTop(8), UI.row(this.offsetX, this.offsetY), this.rotation, this.shading);
    }

    @Override
    public void startEdit(BillboardForm form) {
        super.startEdit(form);
        this.billboard.setValue((Boolean)form.billboard.get());
        this.linear.setValue((Boolean)form.linear.get());
        this.mipmap.setValue((Boolean)form.mipmap.get());
        this.resizeCrop.setValue((Boolean)form.resizeCrop.get());
        this.color.setColor(((Color)form.color.get()).getARGBColor());
        this.offsetX.setValue(((Float)form.offsetX.get()).floatValue());
        this.offsetY.setValue(((Float)form.offsetY.get()).floatValue());
        this.rotation.setValue(((Float)form.rotation.get()).floatValue());
        this.shading.setValue((Boolean)form.shading.get());
    }
}

