/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.panels;

import java.util.ArrayList;
import mchorse.bbs_mod.forms.forms.StructureForm;
import mchorse.bbs_mod.forms.forms.utils.StructureLightSettings;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.forms.editors.forms.UIForm;
import mchorse.bbs_mod.ui.forms.editors.panels.UIFormPanel;
import mchorse.bbs_mod.ui.forms.editors.utils.UIStructureOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIListOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.utils.colors.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7924;

@Environment(value=EnvType.CLIENT)
public class UIStructureFormPanel
extends UIFormPanel<StructureForm> {
    public UIButton pickStructure = new UIButton(UIKeys.FORMS_EDITORS_STRUCTURE_PICK_STRUCTURE, b -> this.pickStructure());
    public UIButton pickBiome;
    public UITextbox structureFile = new UITextbox(100, s -> ((StructureForm)this.form).structureFile.set(s)).path().border();
    public UIColor color = new UIColor(c -> ((StructureForm)this.form).color.set(Color.rgba(c))).withAlpha();
    public UIToggle toggleLight;
    public UITrackpad lightIntensity;

    public UIStructureFormPanel(UIForm editor) {
        super(editor);
        this.pickBiome = new UIButton(UIKeys.FORMS_EDITORS_STRUCTURE_PICK_BIOME, b -> this.pickBiome());
        this.toggleLight = new UIToggle(UIKeys.FORMS_EDITORS_STRUCTURE_LIGHT, false, t -> this.toggleLight((UIToggle)t));
        this.lightIntensity = new UITrackpad(v -> this.setLightIntensity(v.intValue())).integer().limit(1.0, 15.0);
        this.options.add((IUIElement)this.color);
        this.options.add((IUIElement)this.pickStructure);
        this.options.add((IUIElement)this.pickBiome);
        this.options.add((IUIElement)this.toggleLight);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_STRUCTURE_LIGHT_INTENSITY_LABEL).marginTop(6), this.lightIntensity);
    }

    private void pickStructure() {
        UIStructureOverlayPanel overlay = new UIStructureOverlayPanel(UIKeys.FORMS_EDITORS_STRUCTURE_PICK_STRUCTURE, link -> this.setStructure((Link)link));
        String current = (String)((StructureForm)this.form).structureFile.get();
        if (current == null || current.isEmpty()) {
            overlay.set("");
        } else {
            try {
                overlay.set(Link.assets(current));
            }
            catch (Exception e) {
                overlay.set("");
            }
        }
        UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)overlay, 280, 0.5f);
    }

    private void pickBiome() {
        UIListOverlayPanel overlay = new UIListOverlayPanel(UIKeys.FORMS_EDITORS_STRUCTURE_PICK_BIOME, value -> {
            String id = value == null ? "" : value;
            ((StructureForm)this.form).biomeId.set(id);
        });
        ArrayList<String> ids = new ArrayList<String>();
        try {
            if (class_310.method_1551().field_1687 != null) {
                class_2378 reg = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41236);
                for (class_2960 id : reg.method_10235()) {
                    ids.add(id.toString());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        overlay.addValues(ids);
        overlay.setValue((String)((StructureForm)this.form).biomeId.get());
        UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)overlay, 280, 0.5f);
    }

    private void toggleLight(UIToggle t) {
        StructureLightSettings s = (StructureLightSettings)((StructureForm)this.form).structureLight.get();
        if (s == null) {
            s = new StructureLightSettings(false, 15);
        }
        s.enabled = t.getValue();
        ((StructureForm)this.form).structureLight.set(s);
        ((StructureForm)this.form).emitLight.set(s.enabled);
    }

    private void setLightIntensity(int v) {
        StructureLightSettings s = (StructureLightSettings)((StructureForm)this.form).structureLight.get();
        if (s == null) {
            s = new StructureLightSettings(false, 15);
        }
        s.intensity = Math.max(1, Math.min(15, v));
        ((StructureForm)this.form).structureLight.set(s);
        ((StructureForm)this.form).lightIntensity.set(s.intensity);
    }

    private void setStructure(Link link) {
        String path = link == null ? "" : link.path;
        ((StructureForm)this.form).structureFile.set(path);
        this.structureFile.setText(path);
    }

    @Override
    public void startEdit(StructureForm form) {
        super.startEdit(form);
        this.structureFile.setText((String)form.structureFile.get());
        this.color.setColor(((Color)form.color.get()).getARGBColor());
        StructureLightSettings s = (StructureLightSettings)form.structureLight.get();
        boolean enabled = s != null ? s.enabled : (Boolean)form.emitLight.get();
        int intensity = s != null ? s.intensity : (Integer)form.lightIntensity.get();
        this.toggleLight.setValue(enabled);
        this.lightIntensity.setValue(intensity);
    }
}

