/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.panels.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.input.list.UISearchList;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIStringList;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class UIBlockStateEditor
extends UIElement {
    private static List<String> blockIDs = new ArrayList<String>();
    public UISearchList<String> blockList;
    public UIElement properties;
    private Consumer<class_2680> callback;
    private class_2680 blockState;

    public UIBlockStateEditor(Consumer<class_2680> callback) {
        this.callback = callback;
        this.blockList = new UISearchList<String>(new UIStringList(l -> this.setBlock((String)l.get(0))));
        this.blockList.label((IKey)UIKeys.GENERAL_SEARCH).list.background();
        this.blockList.h(116);
        this.properties = UI.column(new UIElement[0]);
        this.column().vertical().stretch();
        this.add((IUIElement)this.blockList);
        this.add((IUIElement)this.properties);
        this.blockList.list.clear();
        this.blockList.list.add(blockIDs);
    }

    public void setBlockState(class_2680 blockState) {
        this.blockState = blockState;
        this.fillPropertiesEditor(blockState);
        this.blockList.list.setCurrentScroll(class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString());
    }

    private void setBlock(String blockID) {
        class_2960 id = class_2960.method_60654((String)blockID);
        class_2680 blockState = ((class_2248)class_7923.field_41175.method_10223(id)).method_9564();
        this.acceptBlockState(blockState);
        this.fillPropertiesEditor(blockState);
    }

    private void acceptBlockState(class_2680 blockState) {
        this.blockState = blockState;
        if (this.callback != null) {
            this.callback.accept(blockState);
        }
    }

    private void fillPropertiesEditor(class_2680 state) {
        UIBaseMenu.UIRootElement root;
        this.properties.removeAll();
        for (class_2769 p : state.method_28501()) {
            UIButton button = new UIButton(IKey.constant(state.method_11654(p).toString()), b -> this.getContext().replaceContextMenu(menu -> {
                for (Object v : p.method_11898()) {
                    IKey raw = IKey.constant(v.toString());
                    menu.action(Icons.BLOCK, raw, () -> {
                        this.acceptBlockState((class_2680)this.blockState.method_11657(p, (Comparable)v));
                        b.label = raw;
                    });
                }
            }));
            button.tooltip(IKey.constant(p.method_11899()));
            this.properties.add((IUIElement)button);
        }
        if (!this.properties.getChildren().isEmpty()) {
            this.properties.prepend(UI.label(UIKeys.FORMS_EDITORS_BLOCK_PROPERTIES).marginTop(6));
        }
        if ((root = this.getRoot()) != null) {
            root.resize();
        }
    }

    static {
        for (class_5321 key : class_7923.field_41175.method_42021()) {
            blockIDs.add(key.method_29177().toString());
        }
        blockIDs.sort(String::compareToIgnoreCase);
    }
}

