/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.shapes;

import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.shapes.IKeyframeShapeRenderer;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class CircleKeyframeShapeRenderer
implements IKeyframeShapeRenderer {
    @Override
    public IKey getLabel() {
        return UIKeys.KEYFRAMES_SHAPES_CIRCLE;
    }

    @Override
    public Icon getIcon() {
        return Icons.CIRCLE;
    }

    @Override
    public void renderKeyframe(UIContext uiContext, class_287 builder, Matrix4f matrix, int x, int y, int offset, int c) {
        int NUM_SEGMENTS = 32;
        for (int i = 0; i < 32; ++i) {
            float angle1 = (float)Math.toRadians(11.25f * (float)i);
            float angle2 = (float)Math.toRadians(11.25f * (float)(i + 1));
            float cos1 = (float)Math.cos(angle1);
            float sin1 = (float)Math.sin(angle1);
            float cos2 = (float)Math.cos(angle2);
            float sin2 = (float)Math.sin(angle2);
            float innerRadius = (float)offset * 1.25f;
            float innerX1 = (float)x + innerRadius * cos1;
            float innerY1 = (float)y + innerRadius * sin1;
            float innerX2 = (float)x + innerRadius * cos2;
            float innerY2 = (float)y + innerRadius * sin2;
            float outerX1 = x;
            float outerY1 = y;
            float outerX2 = x;
            float outerY2 = y;
            builder.method_22918(matrix, innerX1, innerY1, 0.0f).method_39415(c);
            builder.method_22918(matrix, outerX1, outerY1, 0.0f).method_39415(c);
            builder.method_22918(matrix, outerX2, outerY2, 0.0f).method_39415(c);
            builder.method_22918(matrix, innerX2, innerY2, 0.0f).method_39415(c);
        }
    }

    @Override
    public void renderKeyframeBackground(UIContext uiContext, class_287 builder, Matrix4f matrix, int x, int y, int offset, int c) {
        float centerSize = (float)offset * 0.2f;
        float half = centerSize * 2.0f;
        builder.method_22918(matrix, (float)x - half, (float)y - half, 0.0f).method_39415(c);
        builder.method_22918(matrix, (float)x - half, (float)y + half, 0.0f).method_39415(c);
        builder.method_22918(matrix, (float)x + half, (float)y + half, 0.0f).method_39415(c);
        builder.method_22918(matrix, (float)x + half, (float)y - half, 0.0f).method_39415(c);
    }
}

