/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles.utils;

import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.graphics.line.LineBuilder;
import mchorse.bbs_mod.graphics.line.SolidColorLineRenderer;
import mchorse.bbs_mod.math.Constant;
import mchorse.bbs_mod.math.molang.MolangParser;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.math.molang.expressions.MolangValue;
import mchorse.bbs_mod.particles.ParticleCurve;
import mchorse.bbs_mod.particles.ParticleCurveType;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeSection;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.interps.Lerps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector2d;

@Environment(value=EnvType.CLIENT)
public class UICurve
extends UIElement {
    private UIParticleSchemeSection section;
    private UITrackpad value;
    private Area graph = new Area();
    private ParticleCurve curve;
    private int index;
    private boolean dragging;
    private boolean moving;
    private int lastX;
    private int lastY;
    private Vector2d range = new Vector2d();

    public UICurve(UIParticleSchemeSection section) {
        this.section = section;
        this.value = new UITrackpad(v -> {
            this.curve.nodes.set(this.index, new MolangValue(null, new Constant((double)v)));
            this.section.dirty();
            this.updateRange();
        });
        this.value.relative(this).y(1.0f, -20).w(1.0f);
        this.add((IUIElement)this.value);
        this.context((ContextMenuManager menu) -> {
            menu.action(Icons.ADD, UIKeys.SNOWSTORM_CURVES_CONTEXT_ADD, this::addPoint);
            if (this.index >= 0) {
                menu.action(Icons.REMOVE, UIKeys.SNOWSTORM_CURVES_CONTEXT_REMOVE, this::removePoint);
            }
        });
    }

    private void addPoint() {
        int index = this.index + 1;
        if (index < this.curve.nodes.size()) {
            this.curve.nodes.add(index, MolangParser.ZERO);
            this.setIndex(index);
        } else {
            this.curve.nodes.add(MolangParser.ZERO);
            this.setIndex(this.curve.nodes.size() - 1);
        }
        this.section.dirty();
    }

    private void removePoint() {
        if (this.index < 0) {
            return;
        }
        this.curve.nodes.remove(this.index);
        this.setIndex(this.index - 1);
        this.section.dirty();
    }

    public void fill(ParticleCurve curve) {
        this.curve = curve;
        this.setIndex(-1);
        this.updateRange();
    }

    private void setIndex(int i) {
        this.index = i;
        boolean isValid = i >= 0 && i < this.curve.nodes.size();
        this.value.setVisible(true);
        this.value.setEnabled(isValid);
        if (isValid) {
            this.value.setValue(this.curve.nodes.get(i).get());
        }
    }

    private Vector2d getVector(int index, double min, double max) {
        index = MathUtils.clamp(index, 0, this.curve.nodes.size() - 1);
        MolangExpression expression = this.curve.nodes.get(index);
        double value = expression.get();
        double factor = 1.0 - (value - min) / (max - min);
        int x = this.graph.x + (int)((float)index / (float)(this.curve.nodes.size() - 1) * (float)this.graph.w);
        int y = this.graph.y + (int)((double)this.graph.h * factor);
        return new Vector2d((double)x, (double)y);
    }

    private void updateRange() {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.curve.nodes.size(); ++i) {
            MolangExpression expression = this.curve.nodes.get(i);
            double value = expression.get();
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        this.range.set(min, max);
    }

    @Override
    public void resize() {
        super.resize();
        this.graph.copy(this.area);
        this.graph.x += 10;
        this.graph.y += 10;
        this.graph.w -= 20;
        this.graph.h -= 40;
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (this.area.isInside(context) && context.mouseButton == 0) {
            for (int i = 0; i < this.curve.nodes.size(); ++i) {
                Vector2d point = this.getVector(i, this.range.x, this.range.y);
                double dx = point.x - (double)context.mouseX;
                double dy = point.y - (double)context.mouseY;
                double d = dx * dx + dy * dy;
                if (!(d <= 25.0)) continue;
                this.setIndex(i);
                this.dragging = true;
                this.lastX = context.mouseX;
                this.lastY = context.mouseY;
                return true;
            }
            this.setIndex(-1);
            return true;
        }
        return super.subMouseClicked(context);
    }

    @Override
    public boolean subMouseReleased(UIContext context) {
        if (this.moving) {
            this.updateRange();
        }
        this.dragging = false;
        this.moving = false;
        return super.subMouseReleased(context);
    }

    @Override
    public void render(UIContext context) {
        this.area.render(context.batcher, -2013265920);
        if (this.curve != null) {
            this.handleDragging(context);
            context.batcher.clip(this.area, context);
            this.drawGraph(context);
            context.batcher.unclip(context);
        }
        super.render(context);
    }

    private void handleDragging(UIContext context) {
        int dy;
        int dx;
        int d;
        if (this.dragging && !this.moving && (d = (dx = context.mouseX - this.lastX) * dx + (dy = context.mouseY - this.lastY) * dy) > 9) {
            this.moving = true;
        }
        if (this.moving) {
            double factor = (double)(-(context.mouseY - this.graph.ey())) / (double)this.graph.h;
            double value = this.range.x + factor * (this.range.y - this.range.x);
            this.curve.nodes.set(this.index, new MolangValue(null, new Constant(value)));
            this.value.setValue(value);
            this.section.dirty();
        }
    }

    private void drawGraph(UIContext context) {
        int i;
        Matrix4f matrix = context.batcher.getContext().method_51448().method_23760().method_23761();
        int c = this.curve.nodes.size();
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_29344, class_290.field_1576);
        builder.method_22918(matrix, (float)this.area.x, (float)this.graph.y, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 0.5f);
        builder.method_22918(matrix, (float)this.area.ex(), (float)this.graph.y, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 0.5f);
        builder.method_22918(matrix, (float)this.area.x, (float)this.graph.ey(), 0.0f).method_22915(0.5f, 0.5f, 0.5f, 0.5f);
        builder.method_22918(matrix, (float)this.area.ex(), (float)this.graph.ey(), 0.0f).method_22915(0.5f, 0.5f, 0.5f, 0.5f);
        builder.method_22918(matrix, (float)this.graph.x, (float)this.area.y, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 0.5f);
        builder.method_22918(matrix, (float)this.graph.x, (float)this.area.ey(), 0.0f).method_22915(0.5f, 0.5f, 0.5f, 0.5f);
        builder.method_22918(matrix, (float)this.graph.ex(), (float)this.area.y, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 0.5f);
        builder.method_22918(matrix, (float)this.graph.ex(), (float)this.area.ey(), 0.0f).method_22915(0.5f, 0.5f, 0.5f, 0.5f);
        if (this.curve.type == ParticleCurveType.HERMITE && c >= 4) {
            Vector2d first = this.getVector(1, this.range.x, this.range.y);
            Vector2d last = this.getVector(c - 2, this.range.x, this.range.y);
            builder.method_22918(matrix, (float)first.x, (float)this.graph.y, 0.0f).method_22915(0.25f, 0.25f, 0.25f, 0.5f);
            builder.method_22918(matrix, (float)first.x, (float)this.graph.ey(), 0.0f).method_22915(0.25f, 0.25f, 0.25f, 0.5f);
            builder.method_22918(matrix, (float)last.x, (float)this.graph.y, 0.0f).method_22915(0.25f, 0.25f, 0.25f, 0.5f);
            builder.method_22918(matrix, (float)last.x, (float)this.graph.ey(), 0.0f).method_22915(0.25f, 0.25f, 0.25f, 0.5f);
        }
        class_286.method_43433((class_9801)builder.method_60800());
        Color color = Colors.COLOR;
        LineBuilder line = new LineBuilder(0.75f);
        color.set((Integer)BBSSettings.primaryColor.get(), false);
        for (i = 0; i < c; ++i) {
            boolean last;
            Vector2d v1 = this.getVector(i, this.range.x, this.range.y);
            Vector2d v2 = this.getVector(i + 1, this.range.x, this.range.y);
            boolean bl = last = i == c - 1;
            if (this.curve.type == ParticleCurveType.LINEAR) {
                line.add((float)v1.x, (float)v1.y);
                if (!last) continue;
                line.add((float)v2.x, (float)v2.y);
                continue;
            }
            Vector2d v0 = this.getVector(i - 1, this.range.x, this.range.y);
            Vector2d v3 = this.getVector(i + 2, this.range.x, this.range.y);
            double d = 5.0;
            int j = 0;
            while ((double)j < 5.0) {
                int x1 = (int)Lerps.lerp(v1.x, v2.x, (double)j / 5.0);
                int vy1 = (int)Lerps.cubicHermite(v0.y, v1.y, v2.y, v3.y, (double)j / 5.0);
                line.add(x1, vy1);
                if (last) {
                    int x2 = (int)Lerps.lerp(v1.x, v2.x, (double)(j + 1) / 5.0);
                    int vy2 = (int)Lerps.cubicHermite(v0.y, v1.y, v2.y, v3.y, (double)(j + 1) / 5.0);
                    line.add(x2, vy2);
                }
                ++j;
            }
        }
        line.render(context.batcher, SolidColorLineRenderer.get(color.r, color.g, color.b, 1.0f));
        for (i = 0; i < c; ++i) {
            Vector2d vector = this.getVector(i, this.range.x, this.range.y);
            int x = (int)vector.x;
            int y = (int)vector.y;
            context.batcher.box(x - 3, y - 3, x + 3, y + 3, this.index == i ? Colors.setA(35071, 1.0f) : -1);
            context.batcher.box(x - 2, y - 2, x + 2, y + 2, -16777216);
        }
    }
}

