/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils;

import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.ScrollDirection;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.interps.Lerps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Scale {
    protected double shift = 0.0;
    protected double zoom = 1.0;
    protected int mult = 1;
    public boolean inverse;
    public Area area;
    public ScrollDirection direction = ScrollDirection.HORIZONTAL;
    public float anchor;
    protected boolean lockViewport;
    protected double lockMin;
    protected double lockMax;

    public static float getAnchorX(UIContext context, Area area) {
        return (float)(context.mouseX - area.x) / (float)area.w;
    }

    public static float getAnchorY(UIContext context, Area area) {
        return (float)(context.mouseY - area.y) / (float)area.h;
    }

    public Scale(Area area, ScrollDirection direction) {
        this(area);
        this.direction = direction;
    }

    public Scale(Area area) {
        this.area = area;
    }

    public Scale inverse() {
        this.inverse = true;
        return this;
    }

    public void copy(Scale scale) {
        this.shift = scale.shift;
        this.zoom = scale.zoom;
        this.mult = scale.mult;
        this.anchor = scale.anchor;
    }

    public void set(double shift, double zoom) {
        this.setShift(shift);
        this.setZoom(zoom);
    }

    public void anchor(float anchor) {
        this.anchor = anchor;
    }

    public void lock(double min, double max) {
        this.lockViewport = true;
        this.lockMin = Math.min(min, max);
        this.lockMax = Math.max(min, max);
    }

    public void unlock() {
        this.lockViewport = false;
    }

    public double getLockMin() {
        return this.lockMin;
    }

    public double getLockMax() {
        return this.lockMax;
    }

    public void calculateMultiplier() {
        this.mult = this.recalcMultiplier(this.getZoom());
    }

    protected int recalcMultiplier(double zoom) {
        int factor = (int)(60.0 / zoom);
        if (factor > 10000) {
            factor = 10000;
        } else if (factor > 5000) {
            factor = 5000;
        } else if (factor > 2500) {
            factor = 2500;
        } else if (factor > 1000) {
            factor = 1000;
        } else if (factor > 500) {
            factor = 500;
        } else if (factor > 250) {
            factor = 250;
        } else if (factor > 100) {
            factor = 100;
        } else if (factor > 50) {
            factor = 50;
        } else if (factor > 25) {
            factor = 25;
        } else if (factor > 10) {
            factor = 10;
        } else if (factor > 5) {
            factor = 5;
        }
        return factor <= 0 ? 1 : factor;
    }

    public void setShift(double shift) {
        if (this.lockViewport) {
            double distance = this.getMaxValue() - this.getMinValue();
            this.shift = shift;
            double min = this.getMinValue();
            double max = this.getMaxValue();
            if (min < this.lockMin) {
                this.shift(this.lockMin, this.lockMin + distance);
            } else if (max > this.lockMax) {
                this.shift(this.lockMax - distance, this.lockMax);
            }
            min = this.getMinValue();
            max = this.getMaxValue();
            if (min < this.lockMin || max > this.lockMax) {
                double lockMin = Math.max(this.lockMin, min);
                double lockMax = Math.min(this.lockMax, max);
                this.view(lockMin, lockMax);
            }
        } else {
            this.shift = shift;
        }
    }

    public double getShift() {
        return this.shift;
    }

    public void setZoom(double zoom) {
        if (this.lockViewport) {
            this.zoom = zoom;
            double min = this.getMinValue();
            double max = this.getMaxValue();
            if (min < this.lockMin || max > this.lockMax) {
                this.view(Math.max(min, this.lockMin), Math.min(max, this.lockMax));
            }
        } else {
            this.zoom = zoom;
        }
        this.calculateMultiplier();
    }

    public double getZoom() {
        return this.zoom == 0.0 ? 1.0 : this.zoom;
    }

    public int getMult() {
        return this.mult;
    }

    public double to(double value) {
        double factor = (this.inverse ? -value + this.shift : value - this.shift) * this.getZoom();
        if (this.area != null) {
            factor += (double)this.direction.getPosition(this.area, this.anchor);
        }
        return factor;
    }

    public double from(double mouse) {
        if (this.area != null) {
            mouse -= (double)this.direction.getPosition(this.area, this.anchor);
        }
        return this.inverse ? -(mouse / this.getZoom() - this.shift) : mouse / this.getZoom() + this.shift;
    }

    public double getMinValue() {
        this.assertArea();
        return this.from(this.direction.getPosition(this.area, this.inverse ? 1.0f : 0.0f));
    }

    public double getMaxValue() {
        this.assertArea();
        return this.from(this.direction.getPosition(this.area, this.inverse ? 0.0f : 1.0f));
    }

    public boolean isInView(double value) {
        return value >= this.getMinValue() && value <= this.getMaxValue();
    }

    public void view(double min, double max) {
        this.assertArea();
        this.view(min, max, this.direction.getSide(this.area));
    }

    public void view(double min, double max, double length) {
        this.viewOffset(min, max, length, 0.0);
    }

    public void viewOffset(double min, double max, double offset) {
        this.assertArea();
        this.viewOffset(min, max, this.direction.getSide(this.area), offset);
    }

    public void viewOffset(double min, double max, double length, double offset) {
        if (length <= 0.0) {
            return;
        }
        this.zoom = 1.0 / ((max - min) / length);
        if (offset != 0.0) {
            min -= offset / this.getZoom();
            max += offset / this.getZoom();
        }
        if (this.lockViewport && (min < this.lockMin || max > this.lockMax)) {
            min = Math.max(min, this.lockMin);
            max = Math.min(max, this.lockMax);
        }
        this.zoom = 1.0 / ((max - min) / length);
        this.shift(min, max);
        this.calculateMultiplier();
    }

    public void shift(double min, double max) {
        this.shift = Lerps.lerp(min, max, this.inverse ? (double)(1.0f - this.anchor) : (double)this.anchor);
    }

    public void shiftIntoMiddle(double x) {
        if (!this.isInView(x)) {
            this.setShift(x - (this.getMaxValue() - this.getMinValue()) / 2.0);
        }
    }

    public void shiftInto(double value) {
        this.shiftInto(value, 0.0);
    }

    public void shiftInto(double value, double offset) {
        double min = this.getMinValue();
        double max = this.getMaxValue();
        double distance = max - min;
        if (value < min) {
            this.shift(value, value + distance);
        } else if (value > max) {
            this.shift((value -= offset) - distance, value);
        }
    }

    public void zoom(double amount, double min, double max) {
        this.setZoom(MathUtils.clamp(this.getZoom() + amount, min, max));
    }

    public void zoomAnchor(float newAnchor, double amount) {
        this.zoomAnchor(newAnchor, amount, 0.01, 1000.0);
    }

    public void zoomAnchor(float newAnchor, double amount, double min, double max) {
        if (this.area != null) {
            if (this.inverse) {
                shift = this.direction.getPosition(this.area, this.anchor) - this.direction.getPosition(this.area, newAnchor);
                this.shift += shift / this.getZoom();
            } else {
                shift = this.direction.getPosition(this.area, this.anchor) - this.direction.getPosition(this.area, newAnchor);
                this.shift -= shift / this.getZoom();
            }
        }
        this.anchor = newAnchor;
        this.zoom(amount, min, max);
        double diff = this.from(this.direction.getPosition(this.area, newAnchor)) - this.from(this.direction.getPosition(this.area, 0.0f));
        this.shift -= diff;
        this.anchor = 0.0f;
    }

    public double getZoomFactor() {
        return this.getZoomFactor(this.getZoom());
    }

    public double getZoomFactor(double zoom) {
        double factor = 25.0;
        if (zoom < 0.2) {
            factor = 0.005;
        } else if (zoom < 1.0) {
            factor = 0.025;
        } else if (zoom < 2.0) {
            factor = 0.1;
        } else if (zoom < 15.0) {
            factor = 0.5;
        } else if (zoom <= 50.0) {
            factor = 2.5;
        } else if (zoom <= 100.0) {
            factor = 5.0;
        }
        return factor;
    }

    protected void assertArea() {
        if (this.area == null) {
            throw new IllegalStateException("This operation isn't possible without area present!");
        }
    }
}

