/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import mchorse.bbs_mod.utils.joml.Vectors;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class MatrixStackUtils {
    private static Matrix3f normal = new Matrix3f();
    private static Matrix4f oldProjection = new Matrix4f();
    private static Matrix4f oldMV = new Matrix4f();
    private static Matrix3f oldInverse = new Matrix3f();

    public static void scaleStack(class_4587 stack, float x, float y, float z) {
        stack.method_23760().method_23761().scale(x, y, z);
        stack.method_23760().method_23762().scale(x < 0.0f ? -1.0f : 1.0f, y < 0.0f ? -1.0f : 1.0f, z < 0.0f ? -1.0f : 1.0f);
    }

    public static void cacheMatrices() {
        oldProjection.set((Matrix4fc)RenderSystem.getProjectionMatrix());
        oldMV.set((Matrix4fc)RenderSystem.getModelViewMatrix());
        oldInverse.set((Matrix3fc)new Matrix3f((Matrix4fc)RenderSystem.getModelViewMatrix()));
        Matrix4fStack mvStack = RenderSystem.getModelViewStack();
        mvStack.identity();
        RenderSystem.applyModelViewMatrix();
    }

    public static void restoreMatrices() {
        RenderSystem.setProjectionMatrix((Matrix4f)oldProjection, (class_8251)class_8251.field_43361);
        Matrix4fStack mvStack = RenderSystem.getModelViewStack();
        mvStack.set((Matrix4fc)oldMV);
        RenderSystem.applyModelViewMatrix();
    }

    public static void applyTransform(class_4587 stack, Transform transform) {
        stack.method_46416(transform.translate.x, transform.translate.y, transform.translate.z);
        if (transform.pivot.x != 0.0f || transform.pivot.y != 0.0f || transform.pivot.z != 0.0f) {
            stack.method_46416(transform.pivot.x, transform.pivot.y, transform.pivot.z);
        }
        stack.method_22907(class_7833.field_40718.rotation(transform.rotate.z));
        stack.method_22907(class_7833.field_40716.rotation(transform.rotate.y));
        stack.method_22907(class_7833.field_40714.rotation(transform.rotate.x));
        stack.method_22907(class_7833.field_40718.rotation(transform.rotate2.z));
        stack.method_22907(class_7833.field_40716.rotation(transform.rotate2.y));
        stack.method_22907(class_7833.field_40714.rotation(transform.rotate2.x));
        MatrixStackUtils.scaleStack(stack, transform.scale.x, transform.scale.y, transform.scale.z);
        if (transform.pivot.x != 0.0f || transform.pivot.y != 0.0f || transform.pivot.z != 0.0f) {
            stack.method_46416(-transform.pivot.x, -transform.pivot.y, -transform.pivot.z);
        }
    }

    public static void multiply(class_4587 stack, Matrix4f matrix) {
        normal.set((Matrix4fc)matrix);
        normal.getScale(Vectors.TEMP_3F);
        Vectors.TEMP_3F.x = Vectors.TEMP_3F.x == 0.0f ? 0.0f : 1.0f / Vectors.TEMP_3F.x;
        Vectors.TEMP_3F.y = Vectors.TEMP_3F.y == 0.0f ? 0.0f : 1.0f / Vectors.TEMP_3F.y;
        Vectors.TEMP_3F.z = Vectors.TEMP_3F.z == 0.0f ? 0.0f : 1.0f / Vectors.TEMP_3F.z;
        normal.scale((Vector3fc)Vectors.TEMP_3F);
        stack.method_23760().method_23761().mul((Matrix4fc)matrix);
        stack.method_23760().method_23762().mul((Matrix3fc)normal);
    }

    public static void scaleBack(class_4587 matrices) {
        Matrix4f position = matrices.method_23760().method_23761();
        float scaleX = (float)Math.sqrt(position.m00() * position.m00() + position.m10() * position.m10() + position.m20() * position.m20());
        float scaleY = (float)Math.sqrt(position.m01() * position.m01() + position.m11() * position.m11() + position.m21() * position.m21());
        float scaleZ = (float)Math.sqrt(position.m02() * position.m02() + position.m12() * position.m12() + position.m22() * position.m22());
        float max = Math.max(scaleX, Math.max(scaleY, scaleZ));
        position.m00(position.m00() / max);
        position.m10(position.m10() / max);
        position.m20(position.m20() / max);
        position.m01(position.m01() / max);
        position.m11(position.m11() / max);
        position.m21(position.m21() / max);
        position.m02(position.m02() / max);
        position.m12(position.m12() / max);
        position.m22(position.m22() / max);
    }

    public static Matrix4f stripScale(Matrix4f matrix) {
        Matrix4f m = new Matrix4f((Matrix4fc)matrix);
        float sx = (float)Math.sqrt(m.m00() * m.m00() + m.m01() * m.m01() + m.m02() * m.m02());
        float sy = (float)Math.sqrt(m.m10() * m.m10() + m.m11() * m.m11() + m.m12() * m.m12());
        float sz = (float)Math.sqrt(m.m20() * m.m20() + m.m21() * m.m21() + m.m22() * m.m22());
        if (sx != 0.0f) {
            m.m00(m.m00() / sx);
            m.m01(m.m01() / sx);
            m.m02(m.m02() / sx);
        }
        if (sy != 0.0f) {
            m.m10(m.m10() / sy);
            m.m11(m.m11() / sy);
            m.m12(m.m12() / sy);
        }
        if (sz != 0.0f) {
            m.m20(m.m20() / sz);
            m.m21(m.m21() / sz);
            m.m22(m.m22() / sz);
        }
        return m;
    }
}

