/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import mchorse.bbs_mod.audio.BinaryReader;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.resources.Pixels;
import org.joml.Vector2i;

public class PNGEncoder {
    private static final int[] HEADER = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    private ByteArrayOutputStream bytes = new ByteArrayOutputStream();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector2i readSize(File file) {
        try (FileInputStream stream = new FileInputStream(file);){
            byte[] header = new byte[HEADER.length];
            stream.read(header);
            for (int i = 0; i < HEADER.length; ++i) {
                if (header[i] == (byte)HEADER[i]) continue;
                Vector2i vector2i = null;
                return vector2i;
            }
            int size = PNGEncoder.readInt(stream);
            if (size != 13) {
                Vector2i vector2i = null;
                return vector2i;
            }
            int a = stream.read();
            int b = stream.read();
            int c = stream.read();
            int d = stream.read();
            String chunkName = new String(new char[]{(char)a, (char)b, (char)c, (char)d});
            if (!chunkName.equals("IHDR")) {
                Vector2i vector2i = null;
                return vector2i;
            }
            Vector2i vector2i = new Vector2i(PNGEncoder.readInt(stream), PNGEncoder.readInt(stream));
            return vector2i;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int readInt(InputStream stream) throws IOException {
        byte b1 = (byte)stream.read();
        byte b2 = (byte)stream.read();
        byte b3 = (byte)stream.read();
        byte b4 = (byte)stream.read();
        return BinaryReader.b2i(b4, b3, b2, b1);
    }

    public static void writeToFile(Pixels pixels, File file) throws IOException {
        PNGEncoder encoder = new PNGEncoder();
        byte[] bytes = encoder.encode(pixels);
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(bytes);
        stream.close();
    }

    public byte[] encode(Pixels pixels) throws IOException {
        this.writeSignature();
        this.writeIHDRChunk(pixels);
        this.writeIDATChunk(pixels);
        this.writeIENDChunk();
        return this.bytes.toByteArray();
    }

    private void writeSignature() {
        for (int i : HEADER) {
            this.bytes.write(i);
        }
    }

    private void writeIHDRChunk(Pixels pixels) throws IOException {
        ByteArrayOutputStream IHDR = new ByteArrayOutputStream();
        this.writeInt(this.bytes, 13);
        this.writeString(IHDR, "IHDR");
        this.writeInt(IHDR, pixels.width);
        this.writeInt(IHDR, pixels.height);
        IHDR.write(8);
        IHDR.write(6);
        IHDR.write(0);
        IHDR.write(0);
        IHDR.write(0);
        this.writeChunk(IHDR);
    }

    private void writeIDATChunk(Pixels pixels) throws IOException {
        ByteArrayOutputStream IDAT = new ByteArrayOutputStream();
        ByteArrayOutputStream scanlines = new ByteArrayOutputStream();
        for (int y = 0; y < pixels.height; ++y) {
            scanlines.write(0);
            for (int x = 0; x < pixels.width; ++x) {
                Color color = pixels.getColor(x, y);
                scanlines.write((int)(color.r * 255.0f));
                scanlines.write((int)(color.g * 255.0f));
                scanlines.write((int)(color.b * 255.0f));
                scanlines.write((int)(color.a * 255.0f));
            }
        }
        Deflater deflater = new Deflater(8);
        ByteArrayOutputStream finalOutput = new ByteArrayOutputStream();
        DeflaterOutputStream stream = new DeflaterOutputStream((OutputStream)finalOutput, deflater);
        byte[] original = scanlines.toByteArray();
        stream.write(original);
        stream.finish();
        stream.flush();
        byte[] zipped = finalOutput.toByteArray();
        this.writeInt(this.bytes, zipped.length);
        this.writeString(IDAT, "IDAT");
        IDAT.write(zipped);
        this.writeChunk(IDAT);
    }

    private void writeIENDChunk() throws IOException {
        ByteArrayOutputStream IEND = new ByteArrayOutputStream();
        this.writeInt(this.bytes, 0);
        this.writeString(IEND, "IEND");
        this.writeChunk(IEND);
    }

    private void writeString(ByteArrayOutputStream stream, String string) {
        for (int i = 0; i < string.length(); ++i) {
            stream.write(string.charAt(i));
        }
    }

    private void writeInt(ByteArrayOutputStream stream, int integer) {
        byte b1 = (byte)(integer >> 24 & 0xFF);
        byte b2 = (byte)(integer >> 16 & 0xFF);
        byte b3 = (byte)(integer >> 8 & 0xFF);
        byte b4 = (byte)(integer >> 0 & 0xFF);
        stream.write(b1);
        stream.write(b2);
        stream.write(b3);
        stream.write(b4);
    }

    private void writeChunk(ByteArrayOutputStream stream) throws IOException {
        byte[] bytes = stream.toByteArray();
        this.bytes.write(bytes);
        this.writeCRC(bytes);
    }

    private void writeCRC(byte[] bytes) {
        byte[] byArray;
        CRC32 crc32 = new CRC32();
        if (bytes.length == 0) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        } else {
            byArray = bytes;
        }
        crc32.update(byArray);
        long crc = crc32.getValue();
        int b1 = (int)(crc >> 24 & 0xFFL);
        int b2 = (int)(crc >> 16 & 0xFFL);
        int b3 = (int)(crc >> 8 & 0xFFL);
        int b4 = (int)(crc >> 0 & 0xFFL);
        this.bytes.write(b1);
        this.bytes.write(b2);
        this.bytes.write(b3);
        this.bytes.write(b4);
    }
}

