/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.interps.easings;

import mchorse.bbs_mod.utils.interps.easings.IEasing;

public class Easings {
    public static final IEasing CONST = (args, x) -> 0.0;
    public static final IEasing LINEAR = (args, x) -> x;
    public static final IEasing QUADRATIC = (args, x) -> x * x;
    public static final IEasing CUBIC = (args, x) -> x * x * x;
    public static final IEasing QUARTIC = (args, x) -> x * x * x * x;
    public static final IEasing QUINTIC = (args, x) -> x * x * x * x * x;
    public static final IEasing EXP = (args, x) -> (Math.pow(2.0, 10.0 * (x - 1.0)) - 0.001) / 0.999;
    public static final IEasing BACK = (args, x) -> {
        double c1 = 1.70158 + args.v1;
        double c3 = c1 + 1.0;
        return c3 * x * x * x - c1 * x * x;
    };
    public static final IEasing ELASTIC = (args, x) -> Easings.elasticIn((x + 0.025) * 0.975, args.v1);
    public static final IEasing BOUNCE = (args, x) -> 1.0 - Easings.bounceIn(1.0 - x, 4.5 + args.v1, 5.0 + args.v2);
    public static final IEasing SINE = (args, x) -> 1.0 - Math.sin((1.0 - x) * Math.PI / 2.0);
    public static final IEasing CIRCLE = (args, x) -> 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0));

    public static double elasticIn(double x, double amp) {
        double c4 = 2.0943951023931953;
        return -Math.pow(2.0, (amp += 10.0) * x - amp) * Math.sin((x * 10.0 - 10.75) * 2.0943951023931953);
    }

    public static double bounceIn(double x, double n, double lambda) {
        return 1.0 - Math.abs(Math.cos(n * Math.PI * x) * Math.exp(-lambda * x));
    }

    public static IEasing out(IEasing easing) {
        return (args, x) -> 1.0 - easing.calculate(args, 1.0 - x);
    }

    public static IEasing inOut(IEasing easing) {
        return (args, x) -> {
            if (x < 0.5) {
                return easing.calculate(args, x * 2.0) / 2.0;
            }
            double newX = (x - 0.5) * 2.0;
            double newY = 1.0 - easing.calculate(args, 1.0 - newX);
            return newY / 2.0 + 0.5;
        };
    }
}

