/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.vox;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import mchorse.bbs_mod.vox.VoxReader;
import mchorse.bbs_mod.vox.data.Vox;
import mchorse.bbs_mod.vox.data.VoxBaseNode;
import mchorse.bbs_mod.vox.data.VoxGroup;
import mchorse.bbs_mod.vox.data.VoxLayer;
import mchorse.bbs_mod.vox.data.VoxShape;
import mchorse.bbs_mod.vox.data.VoxTransform;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VoxDocument {
    public int[] palette = VoxReader.DEFAULT_PALETTE;
    public List<Vox> chunks = new ArrayList<Vox>();
    public List<VoxBaseNode> nodes = new ArrayList<VoxBaseNode>();
    public List<VoxLayer> layers = new ArrayList<VoxLayer>();
    private int index;

    public List<LimbNode> generate() {
        ArrayList<LimbNode> nodes = new ArrayList<LimbNode>();
        Stack<Matrix3f> matStack = new Stack<Matrix3f>();
        Stack<Vector3f> vecStack = new Stack<Vector3f>();
        this.index = 0;
        if (this.nodes.size() == 0) {
            Matrix3f identity = new Matrix3f();
            for (Vox chunk : this.chunks) {
                Vector3f position = new Vector3f(0.0f, 0.0f, (float)((chunk.d - 1) / 2));
                nodes.add(new LimbNode(chunk, identity, position, (String)(this.index == 0 ? "vox" : "vox_" + this.index)));
                ++this.index;
            }
        } else {
            this.generateNodes((VoxTransform)this.nodes.get(0), nodes, matStack, vecStack);
        }
        return nodes;
    }

    private void generateNodes(VoxTransform transform, List<LimbNode> nodes, Stack<Matrix3f> matStack, Stack<Vector3f> vecStack) {
        Matrix3f mat;
        Vector3f parentVec;
        Matrix3f parentMat;
        boolean hidden;
        VoxBaseNode child = this.nodes.get(transform.childId);
        String name = "vox_" + this.index;
        boolean bl = hidden = transform.attrs.containsKey("_hidden") && ((String)transform.attrs.get("_hidden")).equals("1");
        if (!hidden && transform.layerId < this.layers.size() && transform.layerId >= 0) {
            hidden = this.layers.get(transform.layerId).isHidden();
        }
        if (transform.attrs.containsKey("_name")) {
            name = (String)transform.attrs.get("_name") + "_" + this.index;
        }
        Matrix4f trans = transform.transforms.get(0);
        if (matStack.isEmpty()) {
            parentMat = new Matrix3f((Matrix4fc)trans);
            parentVec = new Vector3f((Vector3fc)trans.getTranslation(new Vector3f()));
        } else {
            parentMat = new Matrix3f((Matrix3fc)matStack.peek());
            parentVec = new Vector3f((Vector3fc)vecStack.peek());
            mat = new Matrix3f((Matrix4fc)trans);
            parentMat.mul((Matrix3fc)mat);
            parentVec.add((Vector3fc)new Vector3f((Vector3fc)trans.getTranslation(new Vector3f())));
        }
        matStack.push(parentMat);
        vecStack.push(parentVec);
        if (child instanceof VoxGroup) {
            VoxGroup group = (VoxGroup)child;
            for (int id : group.ids) {
                ++this.index;
                this.generateNodes((VoxTransform)this.nodes.get(id), nodes, matStack, vecStack);
            }
        } else if (child instanceof VoxShape) {
            mat = matStack.pop();
            Vector3f vec = vecStack.pop();
            if (!hidden) {
                Vox chunk = this.chunks.get(((VoxShape)child).modelAttrs.get((int)0).id);
                nodes.add(new LimbNode(chunk, mat, vec, name));
            }
        }
    }

    public static class LimbNode {
        public Vox chunk;
        public Matrix3f rotation;
        public Vector3f translation;
        public String name;

        public LimbNode(Vox chunk, Matrix3f rotation, Vector3f translation, String name) {
            this.chunk = chunk;
            this.rotation = rotation;
            this.translation = translation;
            this.name = name;
        }
    }
}

