/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.converters;

import mchorse.bbs_mod.camera.clips.converters.IClipConverter;
import mchorse.bbs_mod.camera.clips.overwrite.KeyframeClip;
import mchorse.bbs_mod.camera.clips.overwrite.PathClip;
import mchorse.bbs_mod.camera.data.Position;

public class PathToKeyframeConverter
implements IClipConverter<PathClip, KeyframeClip> {
    @Override
    public KeyframeClip convert(PathClip path) {
        int c = path.size();
        long duration = ((Integer)path.duration.get()).intValue();
        KeyframeClip keyframe = new KeyframeClip();
        keyframe.copy(path);
        for (int i = 0; i < path.size(); ++i) {
            Position point = path.points.get(i);
            long x = (int)((float)i / ((float)c - 1.0f) * (float)duration);
            int index = keyframe.x.insert(x, point.point.x);
            keyframe.y.insert(x, point.point.y);
            keyframe.z.insert(x, point.point.z);
            keyframe.yaw.insert(x, Double.valueOf(point.angle.yaw));
            keyframe.pitch.insert(x, Double.valueOf(point.angle.pitch));
            keyframe.roll.insert(x, Double.valueOf(point.angle.roll));
            keyframe.fov.insert(x, Double.valueOf(point.angle.fov));
            keyframe.x.get(index).getInterpolation().copy(path.interpolationPoint);
            keyframe.y.get(index).getInterpolation().copy(path.interpolationPoint);
            keyframe.z.get(index).getInterpolation().copy(path.interpolationPoint);
            keyframe.yaw.get(index).getInterpolation().copy(path.interpolationAngle);
            keyframe.pitch.get(index).getInterpolation().copy(path.interpolationAngle);
            keyframe.roll.get(index).getInterpolation().copy(path.interpolationAngle);
            keyframe.fov.get(index).getInterpolation().copy(path.interpolationAngle);
        }
        return keyframe;
    }
}

