/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.modifiers;

import java.util.List;
import mchorse.bbs_mod.camera.clips.modifiers.EntityClip;
import mchorse.bbs_mod.camera.data.Angle;
import mchorse.bbs_mod.camera.data.Point;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipContext;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.joml.Matrices;
import org.joml.Vector3f;

public class OrbitClip
extends EntityClip {
    public final ValueBoolean copy = new ValueBoolean("copy");
    public final ValueFloat distance = new ValueFloat("distance", Float.valueOf(0.0f));
    public final ValueFloat yaw = new ValueFloat("yaw", Float.valueOf(0.0f));
    public final ValueFloat pitch = new ValueFloat("pitch", Float.valueOf(0.0f));
    public final ValueBoolean absolute = new ValueBoolean("absolute", false);

    public OrbitClip() {
        this.add(this.copy);
        this.add(this.distance);
        this.add(this.yaw);
        this.add(this.pitch);
        this.add(this.absolute);
    }

    @Override
    public void applyClip(ClipContext context, Position position) {
        List<IEntity> entities = this.getEntities(context);
        if (entities.isEmpty()) {
            return;
        }
        if (!context.applyUnderneath((Integer)this.tick.get(), 0.0f, this.position)) {
            this.position.copy(position);
        }
        float yaw = ((Float)this.yaw.get()).floatValue() + (position.angle.yaw - this.position.angle.yaw);
        float pitch = ((Float)this.pitch.get()).floatValue() + (position.angle.pitch - this.position.angle.pitch);
        float distance = ((Float)this.distance.get()).floatValue() + (float)(position.point.z - this.position.point.z);
        if (((Boolean)this.absolute.get()).booleanValue()) {
            yaw = position.angle.yaw;
            pitch = position.angle.pitch;
            distance = (float)position.point.z;
        }
        IEntity entity = entities.get(0);
        Vector3f vector = Matrices.rotation(MathUtils.toRad(pitch), MathUtils.toRad(-yaw));
        if (((Boolean)this.copy.get()).booleanValue()) {
            float entityYaw = Lerps.lerp(entity.getPrevHeadYaw(), entity.getHeadYaw(), context.transition);
            float entityPitch = -Lerps.lerp(entity.getPrevPitch(), entity.getPitch(), context.transition);
            Matrices.rotate(vector, MathUtils.toRad(-entityPitch), MathUtils.toRad(-entityYaw));
        }
        Point offset = (Point)this.offset.get();
        double x = Lerps.lerp(entity.getPrevX(), entity.getX(), (double)context.transition) + offset.x;
        double y = Lerps.lerp(entity.getPrevY(), entity.getY(), (double)context.transition) + offset.y;
        double z = Lerps.lerp(entity.getPrevZ(), entity.getZ(), (double)context.transition) + offset.z;
        vector.mul(distance);
        double fX = x + (double)vector.x;
        double fY = y + (double)vector.y;
        double fZ = z + (double)vector.z;
        Angle angle = Angle.angle(x - fX, y - fY, z - fZ);
        position.point.set(fX, fY, fZ);
        position.angle.set(angle.yaw, angle.pitch);
    }

    @Override
    public Clip create() {
        return new OrbitClip();
    }
}

