/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic;

import mchorse.bbs_mod.cubic.data.animation.Animation;
import mchorse.bbs_mod.cubic.data.animation.AnimationPart;
import mchorse.bbs_mod.cubic.data.model.Model;
import mchorse.bbs_mod.cubic.data.model.ModelGroup;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.keyframes.BezierUtils;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.KeyframeSegment;
import mchorse.bbs_mod.utils.pose.Transform;
import org.joml.Vector3d;
import org.joml.Vector3fc;

public class CubicModelAnimator {
    private static Vector3d p = new Vector3d();
    private static Vector3d s = new Vector3d();
    private static Vector3d r = new Vector3d();

    public static Vector3d interpolateList(Vector3d output, KeyframeChannel<MolangExpression> x, KeyframeChannel<MolangExpression> y, KeyframeChannel<MolangExpression> z, float frame, double defaultValue) {
        output.x = CubicModelAnimator.interpolateSegment(x.findSegment(frame), defaultValue);
        output.y = CubicModelAnimator.interpolateSegment(y.findSegment(frame), defaultValue);
        output.z = CubicModelAnimator.interpolateSegment(z.findSegment(frame), defaultValue);
        return output;
    }

    private static double interpolateSegment(KeyframeSegment<MolangExpression> segment, double defaultValue) {
        if (segment == null) {
            return defaultValue;
        }
        double start = ((MolangExpression)segment.a.getValue()).get();
        double destination = ((MolangExpression)segment.b.getValue()).get();
        if (segment.b.getInterpolation().getInterp() == Interpolations.BEZIER) {
            return BezierUtils.get(start, destination, segment.a.getTick(), segment.b.getTick(), segment.a.rx, segment.a.ry, segment.b.lx, segment.b.ly, segment.x);
        }
        double pre = ((MolangExpression)segment.preA.getValue()).get();
        double post = ((MolangExpression)segment.postB.getValue()).get();
        return segment.b.getInterpolation().interpolate(IInterp.context.set(pre, start, destination, post, segment.x));
    }

    public static void animate(Model model, Animation animation, float frame, float blend, boolean skipInitial) {
        for (ModelGroup group : model.topGroups) {
            CubicModelAnimator.animateGroup(group, animation, frame, blend, skipInitial);
        }
    }

    private static void animateGroup(ModelGroup group, Animation animation, float frame, float blend, boolean skipInitial) {
        boolean applied = false;
        AnimationPart part = animation.parts.get(group.id);
        if (part != null) {
            CubicModelAnimator.applyGroupAnimation(group, part, frame, blend);
            applied = true;
        }
        if (!applied && !skipInitial) {
            Transform initial = group.initial;
            Transform current = group.current;
            current.translate.lerp((Vector3fc)initial.translate, blend);
            current.scale.lerp((Vector3fc)initial.scale, blend);
            current.rotate.x = (float)Lerps.lerpYaw(current.rotate.x, initial.rotate.x, blend);
            current.rotate.y = (float)Lerps.lerpYaw(current.rotate.y, initial.rotate.y, blend);
            current.rotate.z = (float)Lerps.lerpYaw(current.rotate.z, initial.rotate.z, blend);
        }
        for (ModelGroup childGroup : group.children) {
            CubicModelAnimator.animateGroup(childGroup, animation, frame, blend, skipInitial);
        }
    }

    private static void applyGroupAnimation(ModelGroup group, AnimationPart animation, float frame, float blend) {
        Vector3d position = CubicModelAnimator.interpolateList(p, animation.x, animation.y, animation.z, frame, 0.0);
        Vector3d scale = CubicModelAnimator.interpolateList(s, animation.sx, animation.sy, animation.sz, frame, 1.0);
        Vector3d rotation = CubicModelAnimator.interpolateList(r, animation.rx, animation.ry, animation.rz, frame, 0.0);
        scale.sub(1.0, 1.0, 1.0);
        rotation.x *= -1.0;
        rotation.y *= -1.0;
        Transform initial = group.initial;
        Transform current = group.current;
        current.translate.x = Lerps.lerp(current.translate.x, (float)position.x + initial.translate.x, blend);
        current.translate.y = Lerps.lerp(current.translate.y, (float)position.y + initial.translate.y, blend);
        current.translate.z = Lerps.lerp(current.translate.z, (float)position.z + initial.translate.z, blend);
        current.scale.x = Lerps.lerp(current.scale.x, (float)scale.x + initial.scale.x, blend);
        current.scale.y = Lerps.lerp(current.scale.y, (float)scale.y + initial.scale.y, blend);
        current.scale.z = Lerps.lerp(current.scale.z, (float)scale.z + initial.scale.z, blend);
        current.rotate.x = (float)Lerps.lerpYaw(current.rotate.x, (float)rotation.x + initial.rotate.x, blend);
        current.rotate.y = (float)Lerps.lerpYaw(current.rotate.y, (float)rotation.y + initial.rotate.y, blend);
        current.rotate.z = (float)Lerps.lerpYaw(current.rotate.z, (float)rotation.z + initial.rotate.z, blend);
    }

    public static void postAnimate(Model model, Animation animation, float tick) {
        for (ModelGroup group : model.topGroups) {
            CubicModelAnimator.animateGroupPost(group, animation, tick);
        }
    }

    private static void animateGroupPost(ModelGroup group, Animation animation, float frame) {
        AnimationPart part = animation.parts.get(group.id);
        if (part != null) {
            CubicModelAnimator.applyGroupAnimationPost(group, part, frame);
        }
        for (ModelGroup childGroup : group.children) {
            CubicModelAnimator.animateGroupPost(childGroup, animation, frame);
        }
    }

    private static void applyGroupAnimationPost(ModelGroup group, AnimationPart animation, float frame) {
        Vector3d position = CubicModelAnimator.interpolateList(p, animation.x, animation.y, animation.z, frame, 0.0);
        Vector3d scale = CubicModelAnimator.interpolateList(s, animation.sx, animation.sy, animation.sz, frame, 1.0);
        Vector3d rotation = CubicModelAnimator.interpolateList(r, animation.rx, animation.ry, animation.rz, frame, 0.0);
        scale.sub(1.0, 1.0, 1.0);
        rotation.x *= -1.0;
        rotation.y *= -1.0;
        Transform current = group.current;
        current.translate.x += (float)position.x;
        current.translate.y += (float)position.y;
        current.translate.z += (float)position.z;
        current.scale.x += (float)scale.x;
        current.scale.y += (float)scale.y;
        current.scale.z += (float)scale.z;
        current.rotate.x += (float)rotation.x;
        current.rotate.y += (float)rotation.y;
        current.rotate.z += (float)rotation.z;
    }
}

