/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.data.model;

import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.cubic.data.model.ModelData;
import mchorse.bbs_mod.data.DataStorageUtils;
import mchorse.bbs_mod.data.IMapSerializable;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelMesh
implements IMapSerializable {
    public Vector3f origin = new Vector3f();
    public Vector3f rotate = new Vector3f();
    public ModelData baseData = new ModelData();
    public Map<String, ModelData> data = new HashMap<String, ModelData>();

    @Override
    public void fromData(MapType data) {
        this.baseData.clear();
        this.data.clear();
        this.origin.set((Vector3fc)DataStorageUtils.vector3fFromData(data.getList("origin"), this.origin));
        this.rotate.set((Vector3fc)DataStorageUtils.vector3fFromData(data.getList("rotate"), this.rotate));
        ListType vertices = data.getList("vertices");
        ListType uvs = data.getList("uvs");
        Vector3f a = new Vector3f();
        Vector3f b = new Vector3f();
        if (vertices.size() / 3 == uvs.size() / 2) {
            int i;
            int c = vertices.size() / 3;
            for (i = 0; i < c; ++i) {
                int indexV = i * 3;
                int indexU = i * 2;
                this.baseData.vertices.add(new Vector3f(vertices.getFloat(indexV), vertices.getFloat(indexV + 1), vertices.getFloat(indexV + 2)).add((Vector3fc)this.origin));
                this.baseData.uvs.add(new Vector2f(uvs.getFloat(indexU), uvs.getFloat(indexU + 1)));
            }
            c = this.baseData.vertices.size() / 3;
            for (i = 0; i < c; ++i) {
                Vector3f p1 = this.baseData.vertices.get(i * 3);
                Vector3f p2 = this.baseData.vertices.get(i * 3 + 1);
                Vector3f p3 = this.baseData.vertices.get(i * 3 + 2);
                Vector3f normal = new Vector3f();
                a.set((Vector3fc)p2).sub((Vector3fc)p1);
                b.set((Vector3fc)p3).sub((Vector3fc)p1);
                a.cross((Vector3fc)b, normal);
                normal.normalize();
                this.baseData.normals.add(normal);
                this.baseData.normals.add(normal);
                this.baseData.normals.add(normal);
            }
        }
    }

    @Override
    public void toData(MapType data) {
        ListType vertices = new ListType();
        ListType uvs = new ListType();
        for (Vector3f vector3f : this.baseData.vertices) {
            vertices.addFloat(vector3f.x);
            vertices.addFloat(vector3f.y);
            vertices.addFloat(vector3f.z);
        }
        for (Vector2f vector2f : this.baseData.uvs) {
            uvs.addFloat(vector2f.x);
            uvs.addFloat(vector2f.y);
        }
        data.put("origin", DataStorageUtils.vector3fToData(this.origin));
        data.put("rotate", DataStorageUtils.vector3fToData(this.rotate));
        data.put("vertices", vertices);
        data.put("uvs", uvs);
    }
}

