/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.StringReader;
import mchorse.bbs_mod.forms.ITickable;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.VanillaParticleForm;
import mchorse.bbs_mod.forms.forms.utils.ParticleSettings;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.joml.Matrices;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_7923;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class VanillaParticleFormRenderer
extends FormRenderer<VanillaParticleForm>
implements ITickable {
    public static final Link PARTICLE_PREVIEW = new Link("minecraft", "textures/particle/flame.png");
    private Vector3d pos = new Vector3d();
    private Vector3f vel = new Vector3f();
    private Matrix3f rot = new Matrix3f();
    private int tick;

    public VanillaParticleFormRenderer(VanillaParticleForm form) {
        super(form);
    }

    @Override
    protected void renderInUI(UIContext context, int x1, int y1, int x2, int y2) {
        Texture texture = context.render.getTextures().getTexture(PARTICLE_PREVIEW);
        float min = Math.min(texture.width, texture.height);
        int ow = x2 - x1 - 4;
        int oh = y2 - y1 - 4;
        int w = (int)((float)texture.width / min * (float)ow);
        int h = (int)((float)texture.height / min * (float)ow);
        int x = x1 + (ow - w) / 2 + 2;
        int y = y1 + (oh - h) / 2 + 2;
        context.batcher.fullTexturedBox(texture, x, y, w, h);
    }

    @Override
    protected void render3D(FormRenderingContext context) {
        super.render3D(context);
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Matrix4f matrix = new Matrix4f((Matrix3fc)RenderSystem.getInverseViewRotationMatrix());
        matrix.mul((Matrix4fc)context.stack.method_23760().method_23761());
        Vector3d translation = new Vector3d((Vector3fc)matrix.getTranslation(Vectors.TEMP_3F));
        translation.add(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
        context.stack.method_22903();
        context.stack.method_34426();
        context.stack.method_34425(new Matrix4f((Matrix3fc)RenderSystem.getInverseViewRotationMatrix()).invert());
        this.pos.set((Vector3dc)translation);
        this.vel.set(0.0f, 0.0f, 1.0f);
        this.rot.set((Matrix4fc)matrix).transform(this.vel);
        context.stack.method_22909();
    }

    @Override
    public void tick(IEntity entity) {
        class_1937 world = entity.getWorld();
        boolean paused = (Boolean)((VanillaParticleForm)this.form).paused.get();
        Vector3f temp3f = new Vector3f();
        if (world != null && !paused) {
            float velocity = ((Float)((VanillaParticleForm)this.form).velocity.get()).floatValue();
            int count = (Integer)((VanillaParticleForm)this.form).count.get();
            int frequency = (Integer)((VanillaParticleForm)this.form).frequency.get();
            if (this.tick <= 0) {
                Matrix3f m = Matrices.TEMP_3F;
                Vector3f v = Vectors.TEMP_3F;
                ParticleSettings settings = (ParticleSettings)((VanillaParticleForm)this.form).settings.get();
                class_2396 type = (class_2396)class_7923.field_41180.method_10223(settings.particle);
                class_2400 effect = class_2398.field_11240;
                try {
                    if (type != null) {
                        effect = type.method_10298().method_10296(type, new StringReader(" " + settings.arguments));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = 0; i < count; ++i) {
                    float velocityX = this.vel.x * velocity;
                    float velocityY = this.vel.y * velocity;
                    float velocityZ = this.vel.z * velocity;
                    float sh = MathUtils.toRad(((Float)((VanillaParticleForm)this.form).scatteringYaw.get()).floatValue()) * (float)(Math.random() - 0.5);
                    float sv = MathUtils.toRad(((Float)((VanillaParticleForm)this.form).scatteringPitch.get()).floatValue()) * (float)(Math.random() - 0.5);
                    m.identity().rotateY(sh).rotateX(sv).transform(v.set(velocityX, velocityY, velocityZ));
                    temp3f.set((Math.random() * 2.0 - 1.0) * (double)((Float)((VanillaParticleForm)this.form).offsetX.get()).floatValue(), (Math.random() * 2.0 - 1.0) * (double)((Float)((VanillaParticleForm)this.form).offsetY.get()).floatValue(), (Math.random() * 2.0 - 1.0) * (double)((Float)((VanillaParticleForm)this.form).offsetZ.get()).floatValue());
                    if (((Boolean)((VanillaParticleForm)this.form).local.get()).booleanValue()) {
                        this.rot.transform(temp3f);
                    }
                    double x = this.pos.x + (double)temp3f.x;
                    double y = this.pos.y + (double)temp3f.y;
                    double z = this.pos.z + (double)temp3f.z;
                    world.method_8466((class_2394)effect, true, x, y, z, (double)v.x, (double)v.y, (double)v.z);
                }
                this.tick = frequency;
            }
            --this.tick;
        }
    }
}

