/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.mixin.client;

import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.camera.controller.CameraController;
import mchorse.bbs_mod.camera.controller.ICameraController;
import mchorse.bbs_mod.camera.controller.PlayCameraController;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.items.GunZoom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_757.class})
public class GameRendererMixin {
    @Inject(method={"renderWorld"}, at={@At(value="HEAD")})
    public void onRenderWorld(float tickDelta, long limitTime, class_4587 matrices, CallbackInfo info) {
        CameraController controller = BBSModClient.getCameraController();
        controller.setup(controller.camera, tickDelta);
    }

    @Inject(method={"bobView"}, at={@At(value="HEAD")}, cancellable=true)
    public void onBob(CallbackInfo ci) {
        if (BBSModClient.getCameraController().getCurrent() != null) {
            ci.cancel();
        }
    }

    @Inject(method={"getFov"}, at={@At(value="RETURN")}, cancellable=true)
    public void onGetFov(CallbackInfoReturnable<Double> info) {
        GunZoom gunZoom = BBSModClient.getGunZoom();
        if (gunZoom != null) {
            info.setReturnValue((Object)gunZoom.getFOV(((Double)info.getReturnValue()).floatValue()));
            return;
        }
        CameraController controller = BBSModClient.getCameraController();
        if (controller.getCurrent() != null && !BBSRendering.isIrisShadowPass()) {
            info.setReturnValue((Object)controller.getFOV());
        }
    }

    @Inject(method={"tiltViewWhenHurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void onTiltViewWhenHurt(class_4587 matrices, float tickDelta, CallbackInfo info) {
        CameraController controller = BBSModClient.getCameraController();
        if (controller.getCurrent() != null && !BBSRendering.isIrisShadowPass()) {
            matrices.method_22907(class_7833.field_40718.rotationDegrees(controller.getRoll()));
            info.cancel();
        }
    }

    @Inject(method={"renderHand"}, at={@At(value="HEAD")}, cancellable=true)
    public void onRenderHand(CallbackInfo info) {
        ICameraController current = BBSModClient.getCameraController().getCurrent();
        if (current instanceof PlayCameraController) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderWorld"})
    private void onWorldRenderBegin(CallbackInfo callbackInfo) {
        BBSRendering.onWorldRenderBegin();
    }

    @Inject(at={@At(value="RETURN")}, method={"renderWorld"})
    private void onWorldRenderEnd(CallbackInfo callbackInfo) {
        BBSRendering.onWorldRenderEnd();
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/option/GameOptions;hudHidden:Z", opcode=180, ordinal=0)})
    private void onBeforeHudRendering(float tickDelta, long startTime, boolean tick, CallbackInfo info) {
        ICameraController current = BBSModClient.getCameraController().getCurrent();
        if (class_310.method_1551().field_1690.field_1842 && current == null) {
            BBSRendering.onRenderBeforeScreen();
        }
    }
}

