/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.dashboard;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.OrbitCamera;
import mchorse.bbs_mod.camera.controller.OrbitCameraController;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.events.register.RegisterDashboardPanelsEvent;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.settings.ui.UISettingsOverlayPanel;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.UIDebugPanel;
import mchorse.bbs_mod.ui.dashboard.panels.IFlightSupported;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanel;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanels;
import mchorse.bbs_mod.ui.dashboard.textures.UITextureManagerPanel;
import mchorse.bbs_mod.ui.dashboard.utils.UIGraphPanel;
import mchorse.bbs_mod.ui.dashboard.utils.UIOrbitCamera;
import mchorse.bbs_mod.ui.dashboard.utils.UIOrbitCameraKeys;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIRenderingContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIMessageOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.model_blocks.UIModelBlockPanel;
import mchorse.bbs_mod.ui.morphing.UIMorphingPanel;
import mchorse.bbs_mod.ui.particles.UIParticleSchemePanel;
import mchorse.bbs_mod.ui.selectors.UISelectorsOverlayPanel;
import mchorse.bbs_mod.ui.supporters.UISupportersPanel;
import mchorse.bbs_mod.ui.utility.UIUtilityOverlayPanel;
import mchorse.bbs_mod.ui.utility.audio.UIAudioEditorPanel;
import mchorse.bbs_mod.ui.utils.UIChalkboard;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.Direction;
import mchorse.bbs_mod.utils.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5498;

@Environment(value=EnvType.CLIENT)
public class UIDashboard
extends UIBaseMenu {
    private UIDashboardPanels panels;
    public UIIcon settings;
    public UIIcon selectors;
    public final UIOrbitCamera orbitUI = new UIOrbitCamera();
    public final UIOrbitCameraKeys orbitKeysUI = new UIOrbitCameraKeys(this);
    public final OrbitCamera orbit;
    public final OrbitCameraController camera;
    private UISettingsOverlayPanel settingsPanel;
    private class_5498 lastPerspective;
    private UIChalkboard chalkboard;

    public UIDashboard() {
        this.orbit = this.orbitUI.orbit;
        this.camera = new OrbitCameraController(this.orbit, 5);
        this.lastPerspective = class_5498.field_26664;
        this.orbitUI.setControl(true);
        this.panels = new UIDashboardPanels();
        this.panels.getEvents().register(UIDashboardPanels.PanelEvent.class, e -> {
            this.orbitUI.setControl(this.panels.isFlightSupported());
            UIDashboardPanel patt3495$temp = this.panels.panel;
            if (patt3495$temp instanceof IFlightSupported) {
                IFlightSupported panel = (IFlightSupported)((Object)patt3495$temp);
                this.orbit.setFovRoll(panel.supportsRollFOVControl());
            }
            this.copyCurrentEntityCamera();
        });
        this.panels.full(this.viewport);
        this.registerPanels();
        BBSMod.events.post(new RegisterDashboardPanelsEvent(this));
        this.main.add((IUIElement)this.panels);
        this.settingsPanel = new UISettingsOverlayPanel();
        this.settings = new UIIcon(Icons.SETTINGS, b -> UIOverlay.addOverlayRight(this.context, this.settingsPanel, 240));
        this.settings.tooltip(UIKeys.CONFIG_TITLE, Direction.TOP);
        this.selectors = new UIIcon(Icons.PROPERTIES, b -> UIOverlay.addOverlayRight(this.context, new UISelectorsOverlayPanel(), 240));
        this.selectors.tooltip(UIKeys.SELECTORS_TITLE, Direction.TOP);
        this.chalkboard = new UIChalkboard();
        this.chalkboard.full(this.getRoot());
        this.panels.pinned.add(this.settings, this.selectors);
        this.getRoot().prepend(this.orbitUI);
        this.getRoot().add((IUIElement)this.orbitKeysUI);
        this.getRoot().add((IUIElement)this.chalkboard);
        IKey category = UIKeys.DASHBOARD_CATEGORY;
        this.main.keys().register(Keys.CYCLE_PANELS, this::cyclePanels).category(category);
        this.overlay.keys().register(Keys.TOGGLE_VISIBILITY, () -> {
            if (this.panels.panel.canToggleVisibility()) {
                this.main.toggleVisible();
            }
        }).category(category);
        this.overlay.keys().register(Keys.OPEN_UTILITY_PANEL, () -> {
            if (UIOverlay.has(this.context)) {
                return;
            }
            UIOverlay.addOverlay(this.context, (UIOverlayPanel)new UIUtilityOverlayPanel(UIKeys.UTILITY_TITLE, null), 240, 160);
        });
        this.showAnnoyingPopups();
    }

    private void showAnnoyingPopups() {
        if (BBSRendering.isOptifinePresent()) {
            UIOverlay.addOverlay(this.context, new UIMessageOverlayPanel(UIKeys.DASHBOARD_OPTIFINE_EW_TITLE, UIKeys.DASHBOARD_OPTIFINE_EW_DESCRIPTION));
        }
    }

    public void copyCurrentEntityCamera() {
        class_1297 cameraEntity = class_310.method_1551().method_1560();
        class_243 eyePos = cameraEntity.method_33571();
        Camera camera = new Camera();
        camera.position.set(eyePos.method_10216(), eyePos.method_10214(), eyePos.method_10215());
        camera.rotation.set(MathUtils.toRad(cameraEntity.method_36455()), MathUtils.toRad(cameraEntity.method_5791() - 180.0f), 0.0f);
        camera.fov = MathUtils.toRad(((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).floatValue());
        this.orbit.setup(camera);
        this.camera.setup(BBSModClient.getCameraController().camera, 0.0f);
    }

    private void cyclePanels() {
        List<UIDashboardPanel> panels = this.panels.panels;
        int direction = Window.isShiftPressed() ? -1 : 1;
        int index = panels.indexOf(this.panels.panel);
        int newIndex = MathUtils.cycler(index + direction, panels);
        this.setPanel(panels.get(newIndex));
        UIUtils.playClick();
    }

    public UIDashboardPanels getPanels() {
        return this.panels;
    }

    @Override
    public boolean canPause() {
        return this.panels.panel != null && this.panels.panel.canPause();
    }

    @Override
    public boolean canRefresh() {
        return this.panels.panel != null && this.panels.panel.canRefresh();
    }

    @Override
    public void onOpen(UIBaseMenu oldMenu) {
        super.onOpen(oldMenu);
        this.lastPerspective = class_310.method_1551().field_1690.method_31044();
        class_310.method_1551().field_1690.method_31043(class_5498.field_26664);
        if (oldMenu != this) {
            this.panels.open();
            this.setPanel(this.panels.panel);
        }
        BBSModClient.getCameraController().add(this.camera);
    }

    @Override
    public void onClose(UIBaseMenu nextMenu) {
        super.onClose(nextMenu);
        if (nextMenu != this) {
            this.panels.close();
        }
        this.orbit.reset();
        BBSModClient.getCameraController().remove(this.camera);
        class_310.method_1551().field_1690.method_31043(this.lastPerspective);
    }

    @Override
    protected void closeMenu() {
        super.closeMenu();
        if (!this.main.isVisible()) {
            this.main.setVisible(true);
        }
    }

    protected void registerPanels() {
        this.panels.registerPanel(new UISupportersPanel(this), UIKeys.SUPPORTERS_TITLE, Icons.USER);
        this.panels.registerPanel(new UIMorphingPanel(this), UIKeys.MORPHING_TITLE, Icons.MORPH);
        this.panels.registerPanel(new UIFilmPanel(this), UIKeys.FILM_TITLE, Icons.FILM);
        this.panels.registerPanel(new UIModelBlockPanel(this), UIKeys.MODEL_BLOCKS_TITLE, Icons.BLOCK);
        this.panels.registerPanel(new UIParticleSchemePanel(this), UIKeys.PANELS_PARTICLES, Icons.PARTICLE).marginLeft(10);
        this.panels.registerPanel(new UITextureManagerPanel(this), UIKeys.TEXTURES_TOOLTIP, Icons.MATERIAL);
        this.panels.registerPanel(new UIAudioEditorPanel(this), UIKeys.AUDIO_TITLE, Icons.SOUND);
        this.panels.registerPanel(new UIGraphPanel(this), UIKeys.GRAPH_TOOLTIP, Icons.GRAPH);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.panels.registerPanel(new UIDebugPanel(this), IKey.raw("Sandbox"), Icons.CODE);
        }
        this.setPanel(this.getPanel(UISupportersPanel.class));
    }

    public <T> T getPanel(Class<T> clazz) {
        return this.panels.getPanel(clazz);
    }

    public void setPanel(UIDashboardPanel panel) {
        this.panels.setPanel(panel);
    }

    @Override
    public void update() {
        super.update();
        if (this.panels.panel != null) {
            this.panels.panel.update();
        }
    }

    @Override
    protected void preRenderMenu(UIRenderingContext context) {
        if (!this.main.isVisible()) {
            if (this.panels.panel != null) {
                this.panels.panel.renderPanelBackground(this.context);
            }
            return;
        }
        if (this.panels.panel != null && this.panels.panel.needsBackground()) {
            this.background(context);
        } else {
            context.batcher.gradientVBox(0.0f, 0.0f, this.width, this.height / 8, 0x44000000, 0);
            context.batcher.gradientVBox(0.0f, this.height - this.height / 8, this.width, this.height, 0, 0x44000000);
        }
    }

    private void background(UIRenderingContext context) {
        Link background = (Link)BBSSettings.backgroundImage.get();
        int color = (Integer)BBSSettings.backgroundColor.get();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (background == null) {
            context.batcher.box(0.0f, 0.0f, this.width, this.height, color);
        } else {
            context.batcher.texturedBox(context.getTextures().getTexture(background), color, 0.0f, 0.0f, (float)this.width, (float)this.height, 0.0f, 0.0f, (float)this.width, (float)this.height, this.width, this.height);
        }
    }

    @Override
    public void startRenderFrame(float tickDelta) {
        super.startRenderFrame(tickDelta);
        if (this.panels.panel != null) {
            this.panels.panel.startRenderFrame(tickDelta);
        }
    }

    @Override
    public void renderInWorld(WorldRenderContext context) {
        super.renderInWorld(context);
        if (this.panels.panel != null) {
            this.panels.panel.renderInWorld(context);
        }
    }
}

