/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips;

import java.io.File;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.audio.SoundBuffer;
import mchorse.bbs_mod.camera.clips.misc.AudioClip;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.clips.UIClip;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UISoundOverlayPanel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIAudioClip
extends UIClip<AudioClip> {
    public UIButton pickAudio;
    public UIIcon openFolder;
    public UIIcon extendDuration;
    public UITrackpad offset;

    public UIAudioClip(AudioClip clip, IUIClipsDelegate editor) {
        super(clip, editor);
    }

    @Override
    protected void registerUI() {
        super.registerUI();
        this.pickAudio = new UIButton(UIKeys.CAMERA_PANELS_AUDIO_PICK_AUDIO, b -> {
            UISoundOverlayPanel panel = new UISoundOverlayPanel(l -> ((AudioClip)this.clip).audio.set(l), this.getContext());
            UIOverlay.addOverlay(this.getContext(), panel.set((Link)((AudioClip)this.clip).audio.get()));
        });
        this.openFolder = new UIIcon(Icons.FOLDER, b -> {
            File audioFile;
            Link link = (Link)((AudioClip)this.clip).audio.get();
            File file = BBSMod.getAudioFolder();
            if (link != null && (audioFile = BBSMod.getProvider().getFile(link)).exists()) {
                file = audioFile.getParentFile();
            }
            UIUtils.openFolder(file);
        });
        this.extendDuration = new UIIcon(Icons.RIGHTLOAD, b -> {
            SoundBuffer buffer;
            Link link = (Link)((AudioClip)this.clip).audio.get();
            if (link != null && (buffer = BBSModClient.getSounds().get(link, true)) != null) {
                ((AudioClip)this.clip).duration.set((int)(buffer.getDuration() * 20.0f - (float)((Integer)((AudioClip)this.clip).offset.get()).intValue()));
                this.fillData();
            }
        });
        this.extendDuration.tooltip(UIKeys.CAMERA_PANELS_AUDIO_EXTEND_DURATION);
        this.offset = new UITrackpad(v -> ((AudioClip)this.clip).offset.set(v.intValue()));
        this.offset.integer();
    }

    @Override
    protected void registerPanels() {
        super.registerPanels();
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.C_CLIP.get("bbs:audio")), UI.row(this.pickAudio, this.extendDuration, this.openFolder)).marginTop(12));
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.CAMERA_PANELS_AUDIO_OFFSET).marginTop(6), this.offset).marginTop(12));
    }

    @Override
    public void fillData() {
        super.fillData();
        this.offset.setValue(((Integer)((AudioClip)this.clip).offset.get()).intValue());
    }
}

