/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.replays.overlays;

import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.camera.data.Point;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.replays.UIReplayList;
import mchorse.bbs_mod.ui.forms.UINestedEdit;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIAnchorKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.UIDataUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIReplaysOverlayPanel
extends UIOverlayPanel {
    public UIReplayList replays;
    public UIElement properties;
    public UINestedEdit pickEdit;
    public UIToggle enabled;
    public UITextbox label;
    public UITextbox nameTag;
    public UIToggle shadow;
    public UITrackpad shadowSize;
    public UITrackpad looping;
    public UIToggle actor;
    public UIToggle fp;
    public UIToggle relative;
    public UITrackpad relativeOffsetX;
    public UITrackpad relativeOffsetY;
    public UITrackpad relativeOffsetZ;
    public UIToggle axesPreview;
    public UIButton pickAxesPreviewBone;
    private Consumer<Replay> callback;
    private UIFilmPanel filmPanel;

    public UIReplaysOverlayPanel(UIFilmPanel filmPanel, Consumer<Replay> callback) {
        super(UIKeys.FILM_REPLAY_TITLE);
        this.callback = callback;
        this.filmPanel = filmPanel;
        this.replays = new UIReplayList(l -> this.callback.accept(l.isEmpty() ? null : (Replay)l.get(0)), this, filmPanel);
        this.pickEdit = new UINestedEdit(editing -> this.replays.openFormEditor(((Replay)this.replays.getCurrent().get((int)0)).form, (boolean)editing, this.pickEdit::setForm));
        this.pickEdit.keybinds();
        this.pickEdit.pick.tooltip(UIKeys.SCENE_REPLAYS_CONTEXT_PICK_FORM);
        this.pickEdit.edit.tooltip(UIKeys.SCENE_REPLAYS_CONTEXT_EDIT_FORM);
        this.enabled = new UIToggle(UIKeys.CAMERA_PANELS_ENABLED, b -> {
            this.edit(replay -> replay.enabled.set(b.getValue()));
            filmPanel.getController().createEntities();
        });
        this.label = new UITextbox(1000, s -> this.edit(replay -> replay.label.set(s)));
        this.label.textbox.setPlaceholder(UIKeys.FILM_REPLAY_LABEL);
        this.nameTag = new UITextbox(1000, s -> this.edit(replay -> replay.nameTag.set(s)));
        this.nameTag.textbox.setPlaceholder(UIKeys.FILM_REPLAY_NAME_TAG);
        this.shadow = new UIToggle(UIKeys.FILM_REPLAY_SHADOW, b -> this.edit(replay -> replay.shadow.set(b.getValue())));
        this.shadowSize = new UITrackpad(v -> this.edit(replay -> replay.shadowSize.set(Float.valueOf(v.floatValue()))));
        this.shadowSize.tooltip(UIKeys.FILM_REPLAY_SHADOW_SIZE);
        this.looping = new UITrackpad(v -> this.edit(replay -> replay.looping.set(v.intValue())));
        this.looping.limit(0.0).integer().tooltip(UIKeys.FILM_REPLAY_LOOPING_TOOLTIP);
        this.actor = new UIToggle(UIKeys.FILM_REPLAY_ACTOR, b -> this.edit(replay -> replay.actor.set(b.getValue())));
        this.actor.tooltip(UIKeys.FILM_REPLAY_ACTOR_TOOLTIP);
        this.fp = new UIToggle(UIKeys.FILM_REPLAY_FP, b -> {
            for (Replay replay : this.replays.getList()) {
                if (!((Boolean)replay.fp.get()).booleanValue()) continue;
                replay.fp.set(false);
            }
            ((Replay)this.replays.getCurrentFirst()).fp.set(b.getValue());
        });
        this.relative = new UIToggle(UIKeys.CAMERA_PANELS_RELATIVE, b -> this.edit(replay -> replay.relative.set(b.getValue())));
        this.relative.tooltip(UIKeys.FILM_REPLAY_RELATIVE_TOOLTIP);
        this.relativeOffsetX = new UITrackpad(v -> this.edit(replay -> BaseValue.edit(replay.relativeOffset, value -> {
            ((Point)value.get()).x = v;
        })));
        this.relativeOffsetY = new UITrackpad(v -> this.edit(replay -> BaseValue.edit(replay.relativeOffset, value -> {
            ((Point)value.get()).y = v;
        })));
        this.relativeOffsetZ = new UITrackpad(v -> this.edit(replay -> BaseValue.edit(replay.relativeOffset, value -> {
            ((Point)value.get()).z = v;
        })));
        this.axesPreview = new UIToggle(UIKeys.FILM_REPLAY_AXES_PREVIEW, b -> this.edit(replay -> replay.axesPreview.set(b.getValue())));
        this.pickAxesPreviewBone = new UIButton(UIKeys.FILM_REPLAY_PICK_AXES_PREVIEW, b -> {
            Replay replay = filmPanel.replayEditor.getReplay();
            UIAnchorKeyframeFactory.displayAttachments(filmPanel, ((Film)filmPanel.getData()).replays.getList().indexOf(replay), (String)replay.axesPreviewBone.get(), s -> this.edit(r -> r.axesPreviewBone.set(s)));
        });
        this.properties = UI.scrollView(5, 6, UI.label(UIKeys.FILM_REPLAY_REPLAY), this.pickEdit, this.enabled, this.label, this.nameTag, this.shadow, this.shadowSize, UI.label(UIKeys.FILM_REPLAY_LOOPING), this.looping, this.actor, this.fp, this.relative, UI.row(this.relativeOffsetX, this.relativeOffsetY, this.relativeOffsetZ), this.axesPreview, this.pickAxesPreviewBone);
        this.properties.relative(this.replays).x(1.0f).wTo(this.icons.area).h(1.0f);
        this.replays.relative(this.content).w(0.5f).h(1.0f);
        this.content.add(this.replays, this.properties);
    }

    private void edit(Consumer<Replay> consumer) {
        if (consumer != null) {
            List current = this.replays.getCurrent();
            for (Replay replay : current) {
                consumer.accept(replay);
            }
        }
    }

    public void setReplay(Replay replay) {
        this.properties.setVisible(replay != null);
        if (replay != null) {
            this.pickEdit.setForm((Form)replay.form.get());
            this.enabled.setValue((Boolean)replay.enabled.get());
            this.label.setText((String)replay.label.get());
            this.nameTag.setText((String)replay.nameTag.get());
            this.shadow.setValue((Boolean)replay.shadow.get());
            this.shadowSize.setValue(((Float)replay.shadowSize.get()).floatValue());
            this.looping.setValue(((Integer)replay.looping.get()).intValue());
            this.actor.setValue((Boolean)replay.actor.get());
            this.fp.setValue((Boolean)replay.fp.get());
            this.relative.setValue((Boolean)replay.relative.get());
            this.relativeOffsetX.setValue(((Point)replay.relativeOffset.get()).x);
            this.relativeOffsetY.setValue(((Point)replay.relativeOffset.get()).y);
            this.relativeOffsetZ.setValue(((Point)replay.relativeOffset.get()).z);
            this.axesPreview.setValue((Boolean)replay.axesPreview.get());
        }
    }

    @Override
    protected void renderBackground(UIContext context) {
        super.renderBackground(context);
        this.content.area.render(context.batcher, -16777216);
        if (this.replays.getList().size() < 3) {
            UIDataUtils.renderRightClickHere(context, this.replays.area);
        }
    }
}

