/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.utils.undo;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.film.utils.undo.ValueChangeUndo;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIList;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.undo.CompoundUndo;
import mchorse.bbs_mod.utils.undo.IUndo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIUndoList<T>
extends UIList<IUndo<T>> {
    public UIUndoList(Consumer<List<IUndo<T>>> callback) {
        super(callback);
        this.background();
        this.tooltip(IKey.EMPTY);
    }

    @Override
    protected String elementToString(UIContext context, int i, IUndo<T> element) {
        if (element instanceof ValueChangeUndo) {
            ValueChangeUndo undo = (ValueChangeUndo)element;
            return undo.name.toString();
        }
        if (element instanceof CompoundUndo) {
            CompoundUndo compoundUndo = (CompoundUndo)element;
            ArrayList<String> keys = new ArrayList<String>();
            for (IUndo undo : compoundUndo.getUndos()) {
                if (!(undo instanceof ValueChangeUndo)) continue;
                ValueChangeUndo valueUndo = (ValueChangeUndo)undo;
                keys.add(valueUndo.name.toString());
            }
            String prefix = StringUtils.findCommonPrefix(keys);
            if (prefix.endsWith(".")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            return prefix + " (" + compoundUndo.getUndos().size() + ")";
        }
        return super.elementToString(context, i, element);
    }

    @Override
    public void renderTooltip(UIContext context, Area area) {
        int index = this.getHoveredIndex(context);
        IUndo safe = (IUndo)CollectionUtils.getSafe(this.getList(), index);
        if (safe != null) {
            String label = this.elementToString(context, index, safe);
            context.batcher.textCard(label, context.mouseX + 5, context.mouseY + 5);
        }
    }
}

