/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.categories;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.data.DataStringifier;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormCategories;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.categories.FormCategory;
import mchorse.bbs_mod.forms.categories.UserFormCategory;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.forms.StructureForm;
import mchorse.bbs_mod.forms.sections.UserFormSection;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.network.ClientNetwork;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.forms.UIFormList;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIPromptOverlayPanel;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_640;

@Environment(value=EnvType.CLIENT)
public class UIFormCategory
extends UIElement {
    public static final int HEADER_HEIGHT = 20;
    public static final int CELL_WIDTH = 60;
    public static final int CELL_HEIGHT = 80;
    public UIFormList list;
    public FormCategory category;
    public Form selected;
    private int last;
    private String search = "";
    private List<Form> searched = new ArrayList<Form>();

    public UIFormCategory(FormCategory category, UIFormList list) {
        this.category = category;
        this.list = list;
        this.context((ContextMenuManager menu) -> {
            FormCategories formCategories = BBSModClient.getFormCategories();
            UserFormSection userForms = formCategories.getUserForms();
            menu.action(Icons.EDIT, UIKeys.GENERAL_EDIT, () -> this.list.palette.toggleEditor());
            if (this.selected instanceof ModelForm) {
                menu.action(Icons.FOLDER, UIKeys.FORMS_CATEGORIES_CONTEXT_OPEN_MODEL_FOLDER, () -> {
                    ModelForm form = (ModelForm)this.selected;
                    UIUtils.openFolder(BBSMod.getAssetsPath("models/" + (String)form.model.get() + "/"));
                });
            }
            if (this.selected instanceof StructureForm) {
                StructureForm s = (StructureForm)this.selected;
                String relPath = (String)s.structureFile.get();
                if (relPath != null && !relPath.isEmpty()) {
                    try {
                        Link link = Link.assets(relPath);
                        File src = BBSMod.getProvider().getFile(link);
                        File world = BBSMod.getWorldFolder();
                        if (src != null && world != null) {
                            boolean isWorldStructure;
                            String base1 = new File(world, "generated/minecraft/structures").getAbsolutePath();
                            String base2 = new File(world, "generated/structures").getAbsolutePath();
                            String abs = src.getAbsolutePath();
                            boolean bl = isWorldStructure = abs.startsWith(base1) || abs.startsWith(base2);
                            if (isWorldStructure) {
                                menu.action(Icons.DOWNLOAD, IKey.raw("Guardar estructura"), () -> {
                                    try {
                                        String sub;
                                        File dst;
                                        File parent;
                                        File assetsStructures = new File(BBSMod.getAssetsFolder(), "structures");
                                        if (!assetsStructures.exists()) {
                                            assetsStructures.mkdirs();
                                        }
                                        if ((parent = (dst = new File(assetsStructures, sub = relPath.startsWith("structures/") ? relPath.substring("structures/".length()) : relPath)).getParentFile()) != null && !parent.exists()) {
                                            parent.mkdirs();
                                        }
                                        Files.copy(src.toPath(), dst.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                        System.out.println("[BBS] Estructura guardada: " + src.getAbsolutePath() + " -> " + dst.getAbsolutePath());
                                        BBSModClient.getFormCategories().markDirty();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                });
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            menu.action(Icons.ADD, UIKeys.FORMS_CATEGORIES_CONTEXT_ADD_CATEGORY, () -> UIOverlay.addOverlay(this.getContext(), new UIPromptOverlayPanel(UIKeys.FORMS_CATEGORIES_ADD_CATEGORY_TITLE, UIKeys.FORMS_CATEGORIES_ADD_CATEGORY_DESCRIPTION, str -> {
                userForms.addUserCategory(new UserFormCategory(IKey.constant(str), formCategories.visibility.get(UUID.randomUUID().toString()), userForms));
                list.setupForms(formCategories);
            })));
            if (this.selected != null) {
                menu.action(Icons.COPY, UIKeys.FORMS_CATEGORIES_CONTEXT_COPY_FORM, () -> Window.setClipboard(FormUtils.toData(this.selected)));
                menu.action(Icons.COPY, UIKeys.FORMS_CATEGORIES_CONTEXT_COPY_TO_CATEGORY, () -> this.getContext().replaceContextMenu(m -> {
                    for (UserFormCategory formCategory : userForms.categories) {
                        if (formCategory == this.category) continue;
                        m.action(Icons.ADD, UIKeys.FORMS_CATEGORIES_CONTEXT_COPY_TO.format(formCategory.getProcessedTitle()), () -> formCategory.addForm(FormUtils.copy(this.selected)));
                    }
                }));
                menu.action(Icons.COPY, UIKeys.FORMS_CATEGORIES_CONTEXT_COPY_COMMAND, () -> {
                    MapType data = FormUtils.toData(this.selected);
                    DataStringifier stringifier = new DataStringifier();
                    String name = class_310.method_1551().field_1724.method_7334().getName();
                    stringifier.jsonLike();
                    stringifier.indent = "";
                    Window.setClipboard("/bbs morph " + name + " " + stringifier.toString(data));
                });
                Collection playerList = class_310.method_1551().method_1562().method_2880();
                if (playerList.size() > 1) {
                    menu.action(Icons.ARROW_RIGHT, UIKeys.FORMS_CATEGORIES_CONTEXT_SHARE_FORM, () -> this.getContext().replaceContextMenu(newMenu -> {
                        for (class_640 entry : playerList) {
                            if (entry.method_2966().getId().equals(class_310.method_1551().field_1724.method_7334().getId())) continue;
                            newMenu.action(Icons.ARROW_RIGHT, IKey.constant(entry.method_2966().getName()), () -> ClientNetwork.sendSharedForm(this.selected, entry.method_2966().getId()));
                        }
                    }));
                }
            }
        });
        this.h(20);
    }

    public void search(String search) {
        this.search = search.toLowerCase();
        this.searched.clear();
        if (search.isEmpty()) {
            return;
        }
        for (Form form : this.category.getForms()) {
            if (!form.getFormId().toLowerCase().contains(search) && !form.getDisplayName().toLowerCase().contains(search)) continue;
            this.searched.add(form);
        }
    }

    public List<Form> getForms() {
        if (this.search.isEmpty()) {
            return this.category.getForms();
        }
        return this.searched;
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (this.area.isInside(context)) {
            int x = context.mouseX - this.area.x;
            int y = context.mouseY - this.area.y - 20;
            int perRow = this.area.w / 60;
            if (y < 0) {
                if (x < this.area.x + 30 + context.batcher.getFont().getWidth(this.category.title.get())) {
                    this.category.visible.set((Boolean)this.category.visible.get() == false);
                    return true;
                }
                return super.subMouseClicked(context);
            }
            List<Form> forms = this.getForms();
            int i = (x /= 60) + (y /= 80) * perRow;
            if (i >= 0 && i < forms.size()) {
                this.select(forms.get(i), true);
            } else {
                this.select(null, true);
            }
        }
        return super.subMouseClicked(context);
    }

    public void select(Form form, boolean notify) {
        if (this.list != null) {
            this.list.selectCategory(this, form, notify);
        }
        this.selected = form;
    }

    @Override
    public void render(UIContext context) {
        super.render(context);
        context.batcher.textCard(this.category.getProcessedTitle(), this.area.x + 26, this.area.y + 6);
        if (((Boolean)this.category.visible.get()).booleanValue()) {
            context.batcher.icon(Icons.MOVE_DOWN, this.area.x + 16, this.area.y + 5, 0.5f, 0.0f);
        } else {
            context.batcher.icon(Icons.MOVE_UP, this.area.x + 16, this.area.y + 4, 0.5f, 0.0f);
        }
        List<Form> forms = this.getForms();
        int h = 20;
        int x = 0;
        int i = 0;
        int perRow = this.area.w / 60;
        if (!forms.isEmpty() && ((Boolean)this.category.visible.get()).booleanValue()) {
            for (Form form : forms) {
                if (i == perRow) {
                    h += 80;
                    x = 0;
                    i = 0;
                }
                int cx = this.area.x + x;
                int cy = this.area.y + h;
                boolean isSelected = this.selected == form;
                context.batcher.clip(cx, cy, 60, 80, context);
                if (isSelected) {
                    context.batcher.box(cx, cy, cx + 60, cy + 80, 0x88000000 | (Integer)BBSSettings.primaryColor.get());
                    context.batcher.outline(cx, cy, cx + 60, cy + 80, 0x88000000 | (Integer)BBSSettings.primaryColor.get(), 2);
                }
                FormUtilsClient.renderUI(form, context, cx, cy, cx + 60, cy + 80);
                context.batcher.unclip(context);
                x += 60;
                ++i;
            }
            h += 80;
        }
        if (this.last != h) {
            this.last = h;
            UIElement container = this.getParentContainer();
            if (container != null) {
                this.h(h);
                container.resize();
            }
        }
    }
}

